/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.ui.actions.ExpandAllAction;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Display;

public class MonitorExpandAllAction
extends ExpandAllAction {
    @Override
    public void run(IAction arg0) {
        if (this.treeViewer != null) {
            this.expandAllElementsToDepth(PreferenceUI.getMonitorExpandDepth());
        }
    }

    private void expandAllElementsToDepth(int depth) {
        Object[] rootElements;
        Object rootElement = this.treeViewer.getInput();
        IStructuredContentProvider contentProvider = (IStructuredContentProvider)this.treeViewer.getContentProvider();
        Object[] objectArray = rootElements = contentProvider.getElements(rootElement);
        int n = rootElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            this.expandElementToDepth(child, depth, contentProvider);
            ++n2;
        }
    }

    private void expandElementToDepth(final Object element, final int depth, final IStructuredContentProvider contentProvider) {
        if (element == null || depth <= 0) {
            return;
        }
        Job job = new Job(PICLLabels.MonitorView_printjobtitle){

            protected IStatus run(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(() -> {
                    MonitorExpandAllAction.this.treeViewer.expandToLevel(element, 1);
                    Object[] children = contentProvider.getElements(element);
                    if (children != null && children.length > 0) {
                        Object[] objectArray = children;
                        int n2 = children.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            Object child = objectArray[n3];
                            MonitorExpandAllAction.this.expandElementToDepth(child, depth - 1, contentProvider);
                            ++n3;
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

