/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.LocalFilter;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jface.action.Action;

public class LocalFilterAction
extends Action {
    private LocalFilter fLocalFilter;
    private PDTDebugTarget fDebugTarget;

    public LocalFilterAction(LocalFilter localFilter, int menomic, PDTDebugTarget debugTarget) {
        super("&" + menomic + " " + localFilter.getFilterLabel(), 2);
        this.fLocalFilter = localFilter;
        this.fDebugTarget = debugTarget;
    }

    public void run() {
        if (this.fLocalFilter.isEnabled()) {
            this.fLocalFilter.disable();
        } else {
            this.fLocalFilter.enable();
        }
        try {
            IThread[] threads = this.fDebugTarget.getThreads();
            int i = 0;
            while (i < threads.length) {
                DebuggeeThread pt = (DebuggeeThread)threads[i];
                try {
                    pt.stopMonitoringLocalVariables();
                }
                catch (EngineRequestException e) {
                    PICLUtils.logError((Exception)((Object)e));
                }
                pt.fireChangeEvent(512);
                ++i;
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
    }

    public boolean isChecked() {
        return this.fLocalFilter.isEnabled();
    }
}

