/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;

public class HeapCheckAction
extends Action {
    private PDTDebugTarget fDebugTarget;
    private boolean fState;
    private IAction fDelegatedAction = null;

    public HeapCheckAction(IAction action, PDTDebugTarget debugTarget) {
        super(PICLLabels.HeapCheckAction_label);
        this.fDelegatedAction = action;
        this.fDebugTarget = debugTarget;
        try {
            this.fState = ((DebuggeeProcess)this.fDebugTarget.getProcess()).isHeapCheckEnabled();
        }
        catch (NullPointerException npe) {
            this.fState = false;
        }
        this.setChecked(this.fState);
        this.setEnabled(this.fDebugTarget.isAcceptingRequests());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("heap_check_action"));
        if (this.fDelegatedAction != null) {
            this.fDelegatedAction.setChecked(this.isChecked());
            this.fDelegatedAction.setText(this.getText());
            this.fDelegatedAction.setEnabled(this.isEnabled());
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.fDelegatedAction, PICLUtils.getHelpResourceString("heap_check_action"));
        }
    }

    public void run() {
        new Job("Heap Check action"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ((DebuggeeProcess)HeapCheckAction.this.fDebugTarget.getProcess()).setHeapCheckEnabled(!HeapCheckAction.this.fState);
                }
                catch (EngineRequestException e) {
                    PICLDebugPlugin.showMessageDialog(null, e.getMessage(), true);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

