/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupFacility;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupResult;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.debug.ui.sourcelookup.SourceLookupDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorSourceLookupAction
extends Action {
    private ITextEditor fEditor = null;

    public EditorSourceLookupAction(ITextEditor editor) {
        super(PICLLabels.sourceNotFoundButton_editSourceLookup);
        this.fEditor = editor;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "com.ibm.debug.idebug.cpp.cshelp.edit_source_lookup_path_context");
    }

    public void run() {
        if (this.fEditor != null && this.fEditor.getEditorInput() instanceof EngineSuppliedViewEditorInput) {
            EngineSuppliedViewEditorInput esv = (EngineSuppliedViewEditorInput)this.fEditor.getEditorInput();
            ViewFile viewFile = esv.getViewFile();
            ISourceLocator sourceLocator = esv.getPICLDebugTarget().getLaunch().getSourceLocator();
            Shell shell = this.fEditor.getEditorSite().getShell();
            SourceLookupDialog dialog = new SourceLookupDialog(shell, (ISourceLookupDirector)sourceLocator);
            if (dialog.open() == 0) {
                IWorkbenchPage page = this.fEditor.getEditorSite().getPage();
                SourceLookupResult lookupResult = SourceLookupFacility.getDefault().lookup(viewFile.getContext(), sourceLocator, true);
                DebugUITools.displaySource((ISourceLookupResult)lookupResult, (IWorkbenchPage)page);
            }
        }
    }
}

