/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.core.ILinkedResourceMapper;
import com.ibm.debug.pdt.core.PDTDebugUtils;
import com.ibm.debug.pdt.core.breakpoints.GenericLineBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLLocationBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLSourceLineBreakpoint;
import com.ibm.debug.pdt.internal.core.OptionalBreakpointData;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.Breakpoint;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.Language;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.LocationBreakpoint;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.model.ViewInformation;
import com.ibm.debug.pdt.internal.epdc.EPDC_Request;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.lpex.alef.LpexAbstractTextEditor;
import com.ibm.lpex.core.LpexView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class EditorBreakpointAction
extends Action
implements IUpdate {
    private ITextEditor fTextEditor = null;
    private IVerticalRulerInfo fRuler = null;
    protected boolean isRulerAction = false;
    protected boolean isEnableAction = false;
    private IBreakpointManager fBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();

    public EditorBreakpointAction(ITextEditor editor, IVerticalRulerInfo ruler, String initialLabel, boolean setAsRulerAction, boolean setAsEnableAction) {
        super(initialLabel);
        this.fTextEditor = editor;
        this.fRuler = ruler;
        this.isRulerAction = setAsRulerAction;
        this.isEnableAction = setAsEnableAction;
    }

    public void update() {
        if (this.isEnableAction) {
            if (this.useEnableAction(this.getLineNumber())) {
                this.setText(PICLLabels.EnableBreakpointAction_label2);
            } else {
                this.setText(PICLLabels.DisableBreakpointAction_label2);
            }
        } else if (this.getMarkers().isEmpty()) {
            this.setText(PICLLabels.EditorAddBreakpoint_add_label);
        } else {
            this.setText(PICLLabels.EditorAddBreakpoint_remove_label);
        }
        if (this.isEnableAction) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("enable_editor_breakpoint_action"));
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("add_editor_breakpoint_action"));
        }
    }

    public boolean showAction() {
        if (this.isEnableAction) {
            return !this.getMarkers().isEmpty();
        }
        return true;
    }

    public void run() {
        final int lineNumber = this.getLineNumber();
        Job job = new Job("EditorBreakpointAction"){

            public IStatus run(IProgressMonitor monitor) {
                if (EditorBreakpointAction.this.isEnableAction) {
                    boolean useEnableAction = EditorBreakpointAction.this.useEnableAction(lineNumber);
                    EditorBreakpointAction.this.enableDisableBreakpoints(useEnableAction, lineNumber);
                } else {
                    List<IMarker> markers = EditorBreakpointAction.this.getMarkers(lineNumber);
                    if (markers.isEmpty()) {
                        EditorBreakpointAction.this.addMarker(lineNumber);
                    } else {
                        EditorBreakpointAction.this.removeMarkers(markers);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private boolean useEnableAction(int lineNumber) {
        boolean useEnableAction = false;
        List<IMarker> allMarkers = this.getMarkers(lineNumber);
        Iterator<IMarker> iter = allMarkers.iterator();
        IMarker marker = null;
        IBreakpoint ibkpt = null;
        try {
            while (iter.hasNext()) {
                marker = iter.next();
                if (marker == null || (ibkpt = this.getBreakpointManager().getBreakpoint(marker)) == null || ibkpt.isEnabled()) continue;
                useEnableAction = true;
                break;
            }
        }
        catch (CoreException ce) {
            PICLUtils.logError((Exception)((Object)ce));
        }
        return useEnableAction;
    }

    protected void enableDisableBreakpoints(boolean enable, int lineNumber) {
        List<IMarker> allMarkers = this.getMarkers(lineNumber);
        Iterator<IMarker> iter = allMarkers.iterator();
        IMarker marker = null;
        IBreakpoint ibkpt = null;
        try {
            while (iter.hasNext()) {
                marker = iter.next();
                if (marker == null || (ibkpt = this.getBreakpointManager().getBreakpoint(marker)) == null) continue;
                if (!ibkpt.isEnabled() && enable) {
                    ibkpt.setEnabled(enable);
                    continue;
                }
                if (!ibkpt.isEnabled() || enable) continue;
                ibkpt.setEnabled(enable);
            }
        }
        catch (CoreException ce) {
            PICLUtils.logError((Exception)((Object)ce));
        }
    }

    private void addMarker(int line) {
        int editorLine;
        LpexView lpexView;
        String lineText;
        if (line <= 0) {
            return;
        }
        IEditorInput input = this.getTextEditor().getEditorInput();
        PICLDebugTarget dbgtgt = null;
        if (!(input instanceof EngineSuppliedViewEditorInput)) {
            if (input instanceof IFileEditorInput) {
                this.createBreakpoint((IFileEditorInput)input, line);
            }
            return;
        }
        EngineSuppliedViewEditorInput engineViewEI = (EngineSuppliedViewEditorInput)input;
        ViewInformation viewInfo = engineViewEI.getViewInformation();
        boolean doAddressBreakpoint = false;
        String prefix = null;
        if (viewInfo.isDisassemblyView() || viewInfo.isMixedView()) {
            doAddressBreakpoint = true;
        }
        if ((lineText = (lpexView = ((LpexAbstractTextEditor)this.getTextEditor()).getLpexView()).elementText(editorLine = PICLUtils.getBufferedLineNumber((IEditorInput)engineViewEI, line))) == null) {
            return;
        }
        prefix = lineText.substring(0, engineViewEI.getPrefixLength()).trim();
        if (engineViewEI.isLineExecutable(editorLine)) {
            dbgtgt = engineViewEI.getPICLDebugTarget();
            if (doAddressBreakpoint && dbgtgt.supportsBrkptType("com.ibm.debug.pdt.core.PICLAddressBreakpoint")) {
                try {
                    ((DebuggeeProcess)dbgtgt.getProcess()).setAddressBreakpoint(true, prefix, null, new OptionalBreakpointData(dbgtgt.getEngineSession()), null);
                }
                catch (EngineRequestException e) {
                    PICLDebugPlugin.showMessageDialog(null, dbgtgt, e, false);
                }
            } else if (dbgtgt.supportsBrkptType("com.ibm.debug.pdt.core.PICLLineBreakpoint")) {
                String stmtNumber = null;
                if (dbgtgt.supportsStatementBreakpoints()) {
                    stmtNumber = prefix == null || prefix.trim().equals("") ? Integer.toString(line) : prefix.trim();
                }
                Location loc = new Location(engineViewEI.getViewFile(), line);
                try {
                    dbgtgt.createLineBreakpoint(true, loc, stmtNumber, new OptionalBreakpointData(dbgtgt.getEngineSession()), null, null);
                }
                catch (EngineRequestException e) {
                    PICLDebugPlugin.showMessageDialog(null, dbgtgt, e, false);
                }
            }
        }
    }

    protected boolean createBreakpoint(IFileEditorInput input, int line) {
        IFile file = input.getFile();
        if (file == null) {
            return false;
        }
        ViewFile viewFile = PICLUtils.getViewFile((IEditorInput)input);
        if (viewFile != null && viewFile.getDebugTarget() instanceof PDTDebugTarget) {
            Location loc = new Location(viewFile, line);
            PDTDebugTarget dbgtgt = (PDTDebugTarget)viewFile.getDebugTarget();
            String stmtNumber = String.valueOf(line);
            if (dbgtgt.supportsStatementBreakpoints()) {
                try {
                    String prefix = viewFile.getLine(line).getPrefix(viewFile.getPrefixLength());
                    stmtNumber = prefix.trim();
                }
                catch (Exception prefix) {
                    // empty catch block
                }
            }
            EPDC_Request.EProperty vfProp = new EPDC_Request.EProperty(5, (Object)viewFile);
            try {
                dbgtgt.createLineBreakpoint(true, loc, stmtNumber, new OptionalBreakpointData(dbgtgt.getEngineSession()), vfProp, null);
            }
            catch (EngineRequestException e) {
                return false;
            }
        }
        new PICLSourceLineBreakpoint((IResource)file, null, null, null, line, -1, -1);
        return true;
    }

    protected void removeMarkers(List<IMarker> markers) {
        try {
            Iterator<IMarker> e = markers.iterator();
            IBreakpoint breakpoint = null;
            while (e.hasNext()) {
                breakpoint = this.getBreakpointManager().getBreakpoint(e.next());
                if (breakpoint == null) continue;
                this.getBreakpointManager().removeBreakpoint(breakpoint, true);
            }
        }
        catch (CoreException e) {
            PICLUtils.logError((Exception)((Object)e));
        }
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)model;
        }
        return null;
    }

    protected IBreakpointManager getBreakpointManager() {
        return this.fBreakpointManager;
    }

    private List<IMarker> getBreakpointMarkersFromResource(int lineNumber) {
        IConfigurationElement[] linkedResourceMappers;
        ArrayList<IMarker> allMarkers = new ArrayList<IMarker>();
        IResource editorResource = this.getResource();
        List<IMarker> editorMarkers = this.getBreakpointMarkersFromResource(editorResource, lineNumber);
        if (editorMarkers != null) {
            allMarkers.addAll(editorMarkers);
        }
        if ((linkedResourceMappers = PDTCorePlugin.getLinkedResourceMappers()) == null) {
            return allMarkers;
        }
        try {
            int i = 0;
            while (i < linkedResourceMappers.length) {
                IResource[] linkedResources;
                Object adapterClass = linkedResourceMappers[i].createExecutableExtension("class");
                if (adapterClass instanceof ILinkedResourceMapper && (linkedResources = ((ILinkedResourceMapper)adapterClass).getLinkedResource(editorResource)) != null) {
                    int j = 0;
                    while (j < linkedResources.length) {
                        List<IMarker> linkedMarkers = this.getBreakpointMarkersFromResource(linkedResources[j], lineNumber);
                        if (linkedMarkers != null) {
                            allMarkers.addAll(linkedMarkers);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException ce) {
            PICLUtils.logError((Exception)((Object)ce));
        }
        return allMarkers;
    }

    private List<IMarker> getBreakpointMarkersFromResource(IResource resource, int lineNumber) {
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        if (resource != null && resource.exists()) {
            try {
                IMarker[] allMarkers = resource.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 0);
                if (allMarkers == null) {
                    return markers;
                }
                IBreakpoint iBP = null;
                int i = 0;
                while (i < allMarkers.length) {
                    if (!(allMarkers[i] == null || (iBP = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(allMarkers[i])) == null || iBP instanceof GenericLineBreakpoint && ((GenericLineBreakpoint)iBP).hasBeenProcessed() || MarkerUtilities.getLineNumber((IMarker)allMarkers[i]) != lineNumber)) {
                        markers.add(allMarkers[i]);
                    }
                    ++i;
                }
            }
            catch (CoreException ce) {
                PICLUtils.logError((Exception)((Object)ce));
            }
        }
        return markers;
    }

    protected IDocument getDocument() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    protected int getLineNumber() {
        if (this.isRulerAction) {
            if (this.getVerticalRulerInfo() != null) {
                return PICLUtils.getRealLineNumber(this.fTextEditor.getEditorInput(), this.getVerticalRulerInfo().getLineOfLastMouseButtonActivity() + 1);
            }
            return 0;
        }
        return PICLUtils.getLineNumber((IEditorPart)this.fTextEditor);
    }

    protected IResource getResource() {
        IEditorInput input = this.fTextEditor.getEditorInput();
        IResource resource = (IResource)input.getAdapter(IFile.class);
        if (resource == null) {
            resource = (IResource)input.getAdapter(IResource.class);
        }
        return resource;
    }

    protected List<IMarker> getMarkers() {
        return this.getMarkers(this.getLineNumber());
    }

    protected List<IMarker> getMarkers(int lineNumber) {
        IEditorInput input = this.getTextEditor().getEditorInput();
        if (input == null || lineNumber <= 0) {
            return Collections.emptyList();
        }
        String documentName = input.getName();
        if (documentName == null) {
            return Collections.emptyList();
        }
        List<IMarker> markers = new ArrayList<IMarker>();
        try {
            if (!(input instanceof EngineSuppliedViewEditorInput)) {
                markers = this.getBreakpointMarkersFromResource(lineNumber);
                IMarker[] piclBPMarkers = ResourcesPlugin.getWorkspace().getRoot().findMarkers("com.ibm.debug.pdt.core.PICLLocationBreakpoint", true, 0);
                if (piclBPMarkers == null) {
                    return markers;
                }
                IBreakpoint iBP = null;
                int i = 0;
                while (i < piclBPMarkers.length) {
                    int piclBPlineNumber;
                    ViewInformation sourceViewInfo;
                    Location piclBPLocation;
                    PICLLocationBreakpoint piclBP;
                    PDTDebugTarget dbgtgt;
                    iBP = this.getBreakpointManager().getBreakpoint(piclBPMarkers[i]);
                    if (iBP instanceof PICLLocationBreakpoint && (dbgtgt = (piclBP = (PICLLocationBreakpoint)iBP).getDebugTarget()) != null && !dbgtgt.isTerminated() && !piclBP.isDeferred() && (piclBPLocation = piclBP.getLocation(sourceViewInfo = piclBP.getViewInformation())) != null && (piclBPlineNumber = piclBPLocation.getLineNumber()) == lineNumber) {
                        String BPfileNameExt;
                        ViewFile viewFile = piclBPLocation.getViewFile();
                        String viewFileName = dbgtgt.isiSeriesOS() || dbgtgt.getEngineSession().isSLD() || PDTDebugUtils.isDebugToolEngine((IDebugTarget)dbgtgt) && viewFile.getPart().getLanguage().isCOBOL() ? viewFile.getBaseFileName() : viewFile.getFileName();
                        if (viewFileName == null) {
                            return markers;
                        }
                        Path path = new Path(viewFileName);
                        String BPfileName = path.lastSegment();
                        Language lang = viewFile.getPart().getLanguage();
                        if (lang == null) {
                            return markers;
                        }
                        String string = BPfileNameExt = viewFile.isIncludeFile() ? lang.appendIncludeFileExtension(BPfileName) : lang.appendFileExtension(BPfileName);
                        if (documentName.equals(BPfileName) || documentName.equals(BPfileNameExt)) {
                            markers.add(piclBPMarkers[i]);
                        }
                    }
                    ++i;
                }
            } else {
                EngineSuppliedViewEditorInput esv = (EngineSuppliedViewEditorInput)input;
                PICLDebugTarget dbgtgt = esv.getPICLDebugTarget();
                if (dbgtgt == null || dbgtgt.isTerminated()) {
                    return markers;
                }
                IMarker[] allMarkers = ResourcesPlugin.getWorkspace().getRoot().findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
                if (allMarkers == null) {
                    return markers;
                }
                Breakpoint modelBP = null;
                int i = 0;
                while (i < allMarkers.length) {
                    String BPfileName;
                    int modelBPlineNumber;
                    Location modelBPLocation;
                    modelBP = dbgtgt.getBreakpoint(allMarkers[i]);
                    if (modelBP != null && modelBP instanceof LocationBreakpoint && !modelBP.isDeferred() && ((LocationBreakpoint)modelBP).getPart() == esv.getViewFile().getPart() && (modelBPLocation = ((LocationBreakpoint)modelBP).getLocationWithinView(esv.getViewFile().getView())) != null && (modelBPlineNumber = modelBPLocation.getLineNumber()) == lineNumber && (BPfileName = modelBPLocation.getViewFile().getBaseFileName()) != null && BPfileName.equalsIgnoreCase(documentName)) {
                        markers.add(allMarkers[i]);
                    }
                    ++i;
                }
            }
        }
        catch (Exception ce) {
            PICLUtils.logError(ce);
        }
        return markers;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRuler;
    }
}

