/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;

public class DateBreakpointAction
extends Action {
    private PDTDebugTarget fDebugTarget;
    private IAction fDelegatedAction = null;

    public DateBreakpointAction(IAction action, PDTDebugTarget debugTarget) {
        super(PICLLabels.DateBreakpointAction_label);
        this.fDelegatedAction = action;
        this.fDebugTarget = debugTarget;
        this.setEnabled(this.fDebugTarget != null && this.fDebugTarget.isAcceptingRequests());
        this.setToolTipText(PICLLabels.DateBreakpointAction_tooltip);
        boolean isChecked = false;
        if (this.fDebugTarget != null && this.fDebugTarget.getDebugEngine() != null) {
            isChecked = this.fDebugTarget.getDebugEngine().isDateBreakpointsEnabled();
        }
        this.setChecked(isChecked);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("date_breakpoint_action"));
        if (this.fDelegatedAction != null) {
            this.fDelegatedAction.setText(this.getText());
            this.fDelegatedAction.setEnabled(this.isEnabled());
            this.fDelegatedAction.setChecked(this.isChecked());
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.fDelegatedAction, PICLUtils.getHelpResourceString("date_breakpoint_action"));
        }
    }

    public void run() {
        new Job("Date Breakpoint action"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    DateBreakpointAction.this.fDebugTarget.getDebugEngine().setDateBreakpointsEnabled(!DateBreakpointAction.this.fDebugTarget.getDebugEngine().isDateBreakpointsEnabled());
                }
                catch (EngineRequestException e) {
                    PICLDebugPlugin.showMessageDialog(null, e.getMessage(), true);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

