/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class CopyTreeViewToClipboardAction
extends Action {
    private static final String EMPTY = "";
    protected static final String PREFIX = "CopyViewToClipboardAction.";
    protected StructuredViewer fViewer;

    public CopyTreeViewToClipboardAction(StructuredViewer viewer) {
        super(PICLLabels.CopyViewToClipboardAction_label);
        this.setToolTipText(PICLLabels.CopyViewToClipboardAction_tooltip);
        this.fViewer = viewer;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("copy_view_to_clipboard_action"));
    }

    private String concatenateTreeAsString(TreeItem[] itemList, int treeDepth) {
        if (itemList.length == 0) {
            return EMPTY;
        }
        Object treeContents = EMPTY;
        int i = 0;
        while (i < itemList.length) {
            if (!itemList[i].getText().equals(EMPTY)) {
                int j = 0;
                while (j < treeDepth) {
                    treeContents = (String)treeContents + "  ";
                    ++j;
                }
                treeContents = (String)treeContents + itemList[i].getText() + PDTCoreUtils.LINE_SEPARATOR + this.concatenateTreeAsString(itemList[i].getItems(), treeDepth + 1);
            }
            ++i;
        }
        return treeContents;
    }

    public void run() {
        Clipboard clip = new Clipboard(this.fViewer.getControl().getDisplay());
        TreeItem[] treeItems = ((Tree)this.fViewer.getControl()).getItems();
        String treeAsString = EMPTY;
        treeAsString = this.concatenateTreeAsString(treeItems, 0);
        if (!treeAsString.equals(EMPTY)) {
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            clip.setContents(new Object[]{treeAsString}, new Transfer[]{plainTextTransfer});
        }
        this.setChecked(false);
    }

    public void setChecked(boolean value) {
        super.setChecked(value);
    }
}

