/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.actions;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractEditorActionDelegate
implements IWorkbenchWindowActionDelegate,
IEditorActionDelegate,
ISelectionListener {
    protected IWorkbenchWindow fWindow = null;
    protected IAction fAction = null;

    public void dispose() {
        this.fWindow.getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.fAction = action;
        if (targetEditor != null) {
            this.fWindow = targetEditor.getEditorSite().getWorkbenchWindow();
        }
        if (this.fWindow != null) {
            this.fWindow.getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
            ISelection selection = this.fWindow.getSelectionService().getSelection("org.eclipse.debug.ui.DebugView");
            this.fAction.setEnabled(this.checkValidSelection(selection));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.fAction == null) {
            return;
        }
        this.fAction.setEnabled(this.checkValidSelection(selection));
    }

    protected boolean checkValidSelection(ISelection selection) {
        PDTDebugTarget dbgtgt = PICLDebugPlugin.getPDTDebugTarget(selection);
        return dbgtgt != null && dbgtgt.isAcceptingRequests();
    }

    public ITextEditor getEditor() {
        return PICLDebugPlugin.getActiveTextEditor(this.fWindow);
    }
}

