/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui;

import com.ibm.debug.pdt.core.IMessageEvent;
import com.ibm.debug.pdt.core.IMessageListener;
import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.core.PDTDebugUtils;
import com.ibm.debug.pdt.internal.core.IPDTDebugCoreConstants;
import com.ibm.debug.pdt.internal.core.PDTCorePlugin;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestErrorException;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.StackFrame;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.epdc.EPDCUtils;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.editor.DebuggerDocumentProvider;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUI;
import com.ibm.debug.pdt.internal.ui.util.DefaultEditWidgetFactory;
import com.ibm.debug.pdt.rsecommon.IEditWidgetFactory;
import com.ibm.debug.pdt.rsecommon.RSECommonPlugin;
import com.ibm.debug.pdt.ui.IDebugHelp;
import com.ibm.debug.pdt.ui.IEditorDecorationsContributor;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class PICLDebugPlugin
extends AbstractUIPlugin
implements IDebugContextListener,
IMessageListener {
    private static PICLDebugPlugin fInstance;
    private static boolean fShuttingDown;
    private static final String PLUGIN_ID = "com.ibm.debug.pdt.ui";
    private DebuggerDocumentProvider editorDocumentProvider = null;
    private ISelection fCurrentDebugContext = null;
    private static final String DEFAULT_PASSWORD_SECURE_PREFERENCES = "changeit";
    private static final String SECURE_PREFERENCES_FILE_NAME = "securePreferences.properties";
    public static final String EDITORDECORATIONSCONTRIBUTOR = "com.ibm.debug.pdt.ui.ieditordecorationscontributor";
    private static boolean retrievedEditorDecorationsContributors;
    public static IConfigurationElement[] fEditorDecorationsContributors;
    public static final String OVERRIDEMEMORYRENDERINGBINDINGS = "com.ibm.debug.pdt.ui.overridememoryrenderingbindings";
    private static boolean retrievedOverrideMemoryRenderingBindings;
    public static IConfigurationElement[] fOverrideMemoryRenderingBindings;
    private static final String HELP_EXTENSION_POINT = "com.ibm.debug.pdt.ui.debughelpoverride";
    private static boolean retrievedDebugHelpImplementors;
    public static IConfigurationElement[] fDebugHelpImplementors;
    private static HashMap<String, IDebugHelp> fDebugHelpImplementorMap;
    public static final String LAUNCHCONFIGENVDEFAULTPROVIDER = "com.ibm.debug.pdt.ui.locallaunchconfigenvdefaultprovider";
    private static boolean retrievedLaunchConfigEnvDefaultProviders;
    public static IConfigurationElement[] fLaunchConfigEnvDefaultProviders;
    private static IEditWidgetFactory fEditWidgetFactoryImplementation;
    private static IEditWidgetFactory fEditWidgetFactoryDefaultImplementation;
    public static boolean fPDT;
    public static boolean fIsCanChecks;
    public static boolean fPDTEvents;
    public static boolean fPDTEventStack;
    public static boolean fTiming;
    public static ILog fLogFile;
    public static long fElapsedTime;
    private static ISecurePreferences fSecurePreferences;
    private static File fSecurePreferencesDataFile;
    private static boolean fSquelch;
    public static final int ERROR = 1;
    public static final int INFORMATION = 2;
    public static final int QUESTION = 3;
    public static final int WARNING = 4;
    private static int fRememberFork;

    static {
        fShuttingDown = false;
        retrievedEditorDecorationsContributors = false;
        retrievedOverrideMemoryRenderingBindings = false;
        retrievedDebugHelpImplementors = false;
        fDebugHelpImplementorMap = new HashMap();
        retrievedLaunchConfigEnvDefaultProviders = false;
        fPDT = false;
        fIsCanChecks = false;
        fPDTEvents = false;
        fPDTEventStack = false;
        fTiming = false;
        fLogFile = null;
        fElapsedTime = 0L;
        fSquelch = false;
        fRememberFork = -1;
    }

    public static final String getPluginID() {
        return PLUGIN_ID;
    }

    public static Bundle getPluginBundle() {
        return Platform.getBundle((String)PLUGIN_ID);
    }

    public static final PICLDebugPlugin getInstance() {
        return fInstance;
    }

    public static final boolean isShuttingDown() {
        return fShuttingDown;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        fLogFile = this.getLog();
        fInstance = this;
        Class<Breakpoint> bpClassReferenceObj = Breakpoint.class;
        bpClassReferenceObj.getClass();
        DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
        PDTDebugUtils.addMessageListener((IMessageListener)this);
        if (this.isDebugging()) {
            String id = PLUGIN_ID;
            String test = Platform.getDebugOption((String)(id + "/events"));
            if (test != null) {
                fPDTEvents = test.equals("true");
            }
            if ((test = Platform.getDebugOption((String)(id + "/eventstack"))) != null) {
                fPDTEventStack = test.equals("true");
            }
            if ((test = Platform.getDebugOption((String)(id + "/trace"))) != null) {
                fPDT = test.equals("true");
            }
            if ((test = Platform.getDebugOption((String)(id + "/is_can_checks"))) != null) {
                fIsCanChecks = test.equals("true");
            }
            if ((test = Platform.getDebugOption((String)(id + "/timing"))) != null && (fTiming = test.equals("true"))) {
                fElapsedTime = System.currentTimeMillis();
            }
        }
        if (fPDT) {
            PICLUtils.logString((Object)this, "In startup()");
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (fPDT) {
            PICLUtils.logString((Object)this, ".stop()");
        }
        try {
            fShuttingDown = true;
            DebugUITools.getDebugContextManager().removeDebugContextListener((IDebugContextListener)this);
        }
        finally {
            super.stop(context);
        }
        PDTDebugUtils.removeMessageListener((IMessageListener)this);
        fInstance = null;
    }

    public IPreferenceStore getPreferenceStore() {
        return PreferenceUI.getPreferenceStore();
    }

    public ISecurePreferences getSecurePreferences() {
        if (fSecurePreferences == null) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("org.eclipse.equinox.security.storage.defaultPassword", new PBEKeySpec(DEFAULT_PASSWORD_SECURE_PREFERENCES.toString().toCharArray()));
            options.put("org.eclipse.equinox.security.storage.promptUser", true);
            try {
                fSecurePreferencesDataFile = new File(this.getStateLocation().toOSString() + File.separator + SECURE_PREFERENCES_FILE_NAME);
                fSecurePreferences = SecurePreferencesFactory.open((URL)fSecurePreferencesDataFile.toURI().toURL(), options).node(PLUGIN_ID);
            }
            catch (Exception e) {
                PICLUtils.logError(e);
            }
        }
        return fSecurePreferences;
    }

    public static final IWorkbenchPart getPart(String partId) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            return page.findView(partId);
        }
        return null;
    }

    public static final IWorkbenchPart[] getParts(String partId, boolean visibleOnly) {
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>(5);
        IWorkbenchWindow[] windows = PICLUtils.getWorkbenchWindows();
        int windowIndex = 0;
        while (windowIndex < windows.length) {
            IWorkbenchPart[] tmpParts = PICLDebugPlugin.getParts(windows[windowIndex], partId, visibleOnly);
            int partIndex = 0;
            while (partIndex < tmpParts.length) {
                parts.add(tmpParts[partIndex]);
                ++partIndex;
            }
            ++windowIndex;
        }
        return parts.toArray(new IWorkbenchPart[parts.size()]);
    }

    public static final IWorkbenchPart[] getParts(IWorkbenchWindow window, String partId, boolean visibleOnly) {
        ArrayList<IViewPart> parts = new ArrayList<IViewPart>(5);
        IWorkbenchPage[] pages = window.getPages();
        if (pages != null) {
            int pageIndex = 0;
            while (pageIndex < pages.length) {
                IViewPart part = pages[pageIndex].findView(partId);
                if (part != null && (!visibleOnly || pages[pageIndex].isPartVisible((IWorkbenchPart)part))) {
                    parts.add(part);
                }
                ++pageIndex;
            }
        }
        return parts.toArray(new IWorkbenchPart[parts.size()]);
    }

    public static final IEditorReference[] getEditors(String editorId) {
        ArrayList<IEditorReference> editorList = new ArrayList<IEditorReference>(5);
        IWorkbenchWindow[] windows = PICLUtils.getWorkbenchWindows();
        int windowIndex = 0;
        while (windowIndex < windows.length) {
            IEditorReference[] tmpEditors = PICLDebugPlugin.getEditors(windows[windowIndex], editorId);
            int partIndex = 0;
            while (partIndex < tmpEditors.length) {
                editorList.add(tmpEditors[partIndex]);
                ++partIndex;
            }
            ++windowIndex;
        }
        return editorList.toArray(new IEditorReference[editorList.size()]);
    }

    public static final IEditorReference[] getEditors(IWorkbenchWindow window, String editorId) {
        ArrayList<IEditorReference> editorList = new ArrayList<IEditorReference>(5);
        IWorkbenchPage[] pages = window.getPages();
        if (pages != null) {
            int pageIndex = 0;
            while (pageIndex < pages.length) {
                IEditorReference[] editors = pages[pageIndex].getEditorReferences();
                if (editors != null) {
                    IEditorReference editorRef = null;
                    int i = 0;
                    while (i < editors.length) {
                        editorRef = editors[i];
                        if (editorRef != null && editorRef.getId().equals(editorId)) {
                            editorList.add(editorRef);
                        }
                        ++i;
                    }
                }
                ++pageIndex;
            }
        }
        return editorList.toArray(new IEditorReference[editorList.size()]);
    }

    public static ITextEditor getTextEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        if (part instanceof MultiPageEditorPart) {
            IEditorPart[] parts;
            IEditorInput ei = ((MultiPageEditorPart)part).getEditorInput();
            IEditorPart[] iEditorPartArray = parts = ((MultiPageEditorPart)part).findEditors(ei);
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorPart editorPart = iEditorPartArray[n2];
                if (editorPart instanceof ITextEditor) {
                    return (ITextEditor)editorPart;
                }
                ++n2;
            }
            return null;
        }
        return null;
    }

    public static Location getLocationFromEditor(final ITextEditor editor) {
        final Location[] editorLocation = new Location[1];
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                IEditorPart ep;
                ITextEditor ted = editor;
                editorLocation[0] = null;
                if (ted == null && (ted = PICLDebugPlugin.getTextEditor((IWorkbenchPart)(ep = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()))) == null) {
                    return;
                }
                ViewFile vf = PICLDebugPlugin.getViewFile(ted);
                if (vf == null) {
                    return;
                }
                int lineNumber = PICLUtils.getLineNumber((IEditorPart)ted);
                editorLocation[0] = new Location(vf, lineNumber);
            }
        });
        return editorLocation[0];
    }

    public static ViewFile getViewFile(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput ei = editor.getEditorInput();
        PDTDebugTarget tgt = null;
        tgt = ei instanceof EngineSuppliedViewEditorInput ? ((EngineSuppliedViewEditorInput)ei).getPICLDebugTarget() : PICLDebugPlugin.getCurrentPDTDebugTarget();
        if (tgt == null) {
            return null;
        }
        return PICLUtils.getViewFile(ei);
    }

    public static ITextEditor getActiveTextEditor() {
        return PICLDebugPlugin.getActiveTextEditor(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public static ITextEditor getActiveTextEditor(IWorkbenchWindow workbenchWindow) {
        if (workbenchWindow == null) {
            return null;
        }
        IEditorPart part = workbenchWindow.getActivePage().getActiveEditor();
        return PICLDebugPlugin.getTextEditor((IWorkbenchPart)part);
    }

    public static final PICLDebugTarget getPICLDebugTarget(IDebugElement debugElement) {
        IDebugTarget dbgTgt = PICLDebugPlugin.getDebugTarget(debugElement);
        return (PICLDebugTarget)((Object)(dbgTgt instanceof PICLDebugTarget ? dbgTgt : null));
    }

    public static final PDTDebugTarget getPDTDebugTarget(IDebugElement debugElement) {
        IDebugTarget dbgTgt = PICLDebugPlugin.getDebugTarget(debugElement);
        return (PDTDebugTarget)(dbgTgt instanceof PDTDebugTarget ? dbgTgt : null);
    }

    public static final IDebugTarget getDebugTarget(IDebugElement debugElement) {
        if (debugElement == null) {
            return null;
        }
        return debugElement.getDebugTarget();
    }

    public static final PICLDebugTarget getCurrentPICLDebugTarget() {
        IDebugTarget dbgTgt = PICLDebugPlugin.getDebugTarget(PICLDebugPlugin.getCurrentDebugElement());
        return (PICLDebugTarget)((Object)(dbgTgt instanceof PICLDebugTarget ? dbgTgt : null));
    }

    public static final PDTDebugTarget getCurrentPDTDebugTarget() {
        IDebugTarget dbgTgt = PICLDebugPlugin.getDebugTarget(PICLDebugPlugin.getCurrentDebugElement());
        return (PDTDebugTarget)(dbgTgt instanceof PDTDebugTarget ? dbgTgt : null);
    }

    public static final IDebugTarget getCurrentDebugTarget() {
        return PICLDebugPlugin.getDebugTarget(PICLDebugPlugin.getCurrentDebugElement());
    }

    public static final PICLDebugTarget getPICLDebugTarget(ISelection selection) {
        IDebugTarget dbgTgt = PICLDebugPlugin.getDebugTarget(PICLDebugPlugin.getDebugElement(selection));
        return (PICLDebugTarget)((Object)(dbgTgt instanceof PICLDebugTarget ? dbgTgt : null));
    }

    public static final PDTDebugTarget getPDTDebugTarget(ISelection selection) {
        IDebugTarget dbgTgt = PICLDebugPlugin.getDebugTarget(PICLDebugPlugin.getDebugElement(selection));
        return (PDTDebugTarget)(dbgTgt instanceof PDTDebugTarget ? dbgTgt : null);
    }

    public static final IPDTDebugTarget getIPDTDebugTarget(ISelection selection) {
        IDebugTarget dbgTgt = PICLDebugPlugin.getDebugTarget(PICLDebugPlugin.getDebugElement(selection));
        return (IPDTDebugTarget)(dbgTgt instanceof IPDTDebugTarget ? dbgTgt : null);
    }

    public static final IDebugTarget getDebugTarget(ISelection selection) {
        return PICLDebugPlugin.getDebugTarget(PICLDebugPlugin.getDebugElement(selection));
    }

    private static final IDebugElement getCurrentDebugElement() {
        if (PICLDebugPlugin.getInstance() != null) {
            return PICLDebugPlugin.getDebugElement(PICLDebugPlugin.getInstance().getCurrentDebugContext());
        }
        return null;
    }

    private static final IDebugElement getDebugElement(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object elem = ((IStructuredSelection)selection).getFirstElement();
            if (elem instanceof ILaunch) {
                elem = ((ILaunch)elem).getDebugTarget();
            }
            if (elem instanceof IDebugElement) {
                return (IDebugElement)elem;
            }
        }
        return null;
    }

    public static final DebuggeeThread getCurrentThread() {
        return PICLDebugPlugin.getThread(PICLDebugPlugin.getCurrentDebugElement());
    }

    private static final DebuggeeThread getThread(IDebugElement debugElement) {
        if (debugElement == null) {
            return null;
        }
        IDebugElement elem = debugElement;
        if (elem instanceof StackFrame) {
            elem = ((StackFrame)debugElement).getThread();
        }
        if (elem instanceof DebuggeeThread) {
            return (DebuggeeThread)elem;
        }
        IDebugTarget tgt = debugElement.getDebugTarget();
        if (tgt != null && tgt instanceof PICLDebugTarget) {
            return ((PDTDebugTarget)tgt).getStoppingThread();
        }
        return null;
    }

    public static final DebuggeeThread getThread(ISelection selection) {
        return PICLDebugPlugin.getThread(PICLDebugPlugin.getDebugElement(selection));
    }

    public static final StackFrame getCurrentStackFrame() {
        return PICLDebugPlugin.getStackFrame(PICLDebugPlugin.getCurrentDebugElement());
    }

    public static final StackFrame getStackFrame(ISelection selection) {
        return PICLDebugPlugin.getStackFrame(PICLDebugPlugin.getDebugElement(selection));
    }

    public static final StackFrame getStackFrame(IDebugElement debugElement) {
        if (debugElement == null) {
            return null;
        }
        if (debugElement instanceof StackFrame) {
            return (StackFrame)debugElement;
        }
        DebuggeeThread thread = PICLDebugPlugin.getThread(debugElement);
        if (thread != null) {
            try {
                return (StackFrame)thread.getTopStackFrame();
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        return null;
    }

    public void saveDialogSettings() {
        PlatformUI.getDialogSettingsProvider((Bundle)this.getBundle()).saveDialogSettings();
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        Bundle bndl = Platform.getBundle((String)element.getDeclaringExtension().getNamespaceIdentifier());
        if (bndl.getState() == 32) {
            return element.createExecutableExtension(classAttribute);
        }
        final Object[] ret = new Object[1];
        final CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ret[0] = element.createExecutableExtension(classAttribute);
                }
                catch (CoreException e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    public static IConfigurationElement[] getEditorDecorationContributors() {
        if (!retrievedEditorDecorationsContributors) {
            IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(EDITORDECORATIONSCONTRIBUTOR);
            if (ep != null) {
                fEditorDecorationsContributors = ep.getConfigurationElements();
            }
            retrievedEditorDecorationsContributors = true;
        }
        return fEditorDecorationsContributors;
    }

    public static void loadEditorDecorationContributors() {
        IConfigurationElement[] decorators = PICLDebugPlugin.getEditorDecorationContributors();
        if (decorators == null) {
            return;
        }
        try {
            int i = 0;
            while (i < decorators.length) {
                Object decoratorClass = decorators[i].createExecutableExtension("class");
                if (!(decoratorClass instanceof IEditorDecorationsContributor)) {
                    // empty if block
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static boolean loadRestartContributors() {
        return false;
    }

    public static IDebugHelp getHelpClass(String helpClassExtensionID) {
        block8: {
            if (!retrievedDebugHelpImplementors) {
                IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(HELP_EXTENSION_POINT);
                if (ep != null) {
                    fDebugHelpImplementors = ep.getConfigurationElements();
                }
                retrievedDebugHelpImplementors = true;
            }
            if (helpClassExtensionID != null && fDebugHelpImplementors != null) break block8;
            return null;
        }
        try {
            if (fDebugHelpImplementorMap.containsKey(helpClassExtensionID)) {
                return fDebugHelpImplementorMap.get(helpClassExtensionID);
            }
            int i = 0;
            while (i < fDebugHelpImplementors.length) {
                Object obj;
                String sid = fDebugHelpImplementors[i].getAttribute("id");
                if (helpClassExtensionID.equals(sid) && (obj = fDebugHelpImplementors[i].createExecutableExtension("class")) instanceof IDebugHelp) {
                    IDebugHelp implementor = (IDebugHelp)obj;
                    fDebugHelpImplementorMap.put(helpClassExtensionID, implementor);
                    return implementor;
                }
                ++i;
            }
        }
        catch (Exception e) {
            PICLUtils.logError(e);
        }
        return null;
    }

    public static IConfigurationElement[] getOverrideMemoryRenderingBindings() {
        if (!retrievedOverrideMemoryRenderingBindings) {
            retrievedOverrideMemoryRenderingBindings = true;
            IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(OVERRIDEMEMORYRENDERINGBINDINGS);
            if (ep != null) {
                fOverrideMemoryRenderingBindings = ep.getConfigurationElements();
            } else {
                return IPDTDebugCoreConstants.EMPTYCONFIGELEMENTS;
            }
        }
        return fOverrideMemoryRenderingBindings;
    }

    public static IConfigurationElement[] getLocalLaunchConfigEnvDefaultProviders() {
        if (!retrievedLaunchConfigEnvDefaultProviders) {
            retrievedLaunchConfigEnvDefaultProviders = true;
            IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(LAUNCHCONFIGENVDEFAULTPROVIDER);
            if (ep != null) {
                fLaunchConfigEnvDefaultProviders = ep.getConfigurationElements();
            } else {
                return IPDTDebugCoreConstants.EMPTYCONFIGELEMENTS;
            }
        }
        return fLaunchConfigEnvDefaultProviders;
    }

    public static IEditWidgetFactory getEditWidgetFactory() {
        if (fEditWidgetFactoryImplementation == null) {
            fEditWidgetFactoryDefaultImplementation = new DefaultEditWidgetFactory();
            fEditWidgetFactoryImplementation = RSECommonPlugin.getEditWidgetFactory();
            if (fEditWidgetFactoryImplementation == null) {
                fEditWidgetFactoryImplementation = fEditWidgetFactoryDefaultImplementation;
            }
        }
        if (PreferenceUI.isBIDIVisualEditing()) {
            return fEditWidgetFactoryImplementation;
        }
        return fEditWidgetFactoryDefaultImplementation;
    }

    public static void showMessageDialog(Shell msgShell, PDTDebugTarget debugTarget, EngineRequestException engineException, boolean wait) {
        if (PDTCoreUtils.isEmpty((String)engineException.getMessage())) {
            return;
        }
        if (engineException instanceof EngineRequestErrorException) {
            EngineRequestErrorException err = (EngineRequestErrorException)engineException;
            debugTarget.setError(err.getReturnCode(), err.getMessage());
        }
        PICLDebugPlugin.showMessageDialog(msgShell, 1, engineException.getMessage(), wait);
    }

    public static void showMessageDialog(Shell msgShell, String msgText, boolean wait) {
        if (PDTCoreUtils.isEmpty((String)msgText)) {
            return;
        }
        PICLDebugPlugin.showMessageDialog(msgShell, 1, msgText, wait);
    }

    public static void showMessageDialog(Shell msgShell, int msgType, String msgText, boolean wait) {
        PICLDebugPlugin.showMessageDialog(msgShell, msgType, switch (msgType) {
            case 2 -> PICLLabels.MessageDialog_title_Informational;
            case 4 -> PICLLabels.MessageDialog_title_Warning;
            case 1 -> PICLLabels.MessageDialog_title_Error;
            default -> PICLLabels.MessageDialog_title_Informational;
        }, msgText, wait);
    }

    public static void showMessageDialog(final Shell msgShell, final int msgType, final String msgTitle, final String msgText, boolean wait) {
        if (fSquelch) {
            return;
        }
        final Display display = PlatformUI.getWorkbench().getDisplay();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Shell shell = msgShell == null ? display.getActiveShell() : msgShell;
                switch (msgType) {
                    case 2: {
                        this.openMessageDialog(msgTitle, msgText, shell, false);
                        break;
                    }
                    case 4: {
                        this.openMessageDialog(msgTitle, msgText, shell, true);
                        break;
                    }
                    case 1: {
                        MessageDialog.openError((Shell)shell, (String)msgTitle, (String)msgText);
                        break;
                    }
                }
            }

            private void openMessageDialog(String msgTitle2, String msgText2, Shell shell, boolean warning) {
                if (PreferenceUI.isHiddenMessage(msgText2)) {
                    PICLUtils.logString(this, "Hidden message : " + msgText2);
                    return;
                }
                if (EPDCUtils.isValidMessageID((String)msgText2)) {
                    MessageDialogWithToggle msgDialog = warning ? MessageDialogWithToggle.openWarning((Shell)shell, (String)msgTitle2, (String)msgText2, (String)PICLLabels.MessageDialogBox_donotshowmessage, (boolean)false, null, null) : MessageDialogWithToggle.openInformation((Shell)shell, (String)msgTitle2, (String)msgText2, (String)PICLLabels.MessageDialogBox_donotshowmessage, (boolean)false, null, null);
                    if (msgDialog.getToggleState()) {
                        PreferenceUI.setHiddenMessage(msgText2);
                    }
                } else if (warning) {
                    MessageDialog.openWarning((Shell)shell, (String)msgTitle2, (String)msgText2);
                } else {
                    MessageDialog.openInformation((Shell)shell, (String)msgTitle2, (String)msgText2);
                }
            }
        };
        if (!display.isDisposed()) {
            if (wait) {
                display.syncExec(runnable);
            } else {
                display.asyncExec(runnable);
            }
        }
    }

    public static boolean showQuestionDialog(final String titleText, final String msgText) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        final HashSet result = new HashSet();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = display.getActiveShell();
                String messageKey = "hidden_msg." + EPDCUtils.getValidMessageID((String)msgText);
                switch (PreferenceUI.getPreferenceStore().getString(messageKey)) {
                    case "always": {
                        result.add(true);
                        break;
                    }
                    case "never": {
                        result.add(false);
                        break;
                    }
                    default: {
                        MessageDialogWithToggle msgDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)titleText, (String)msgText, (String)PICLLabels.MessageDialogWithToggle_remembermydecision, (boolean)false, (IPreferenceStore)PreferenceUI.getPreferenceStore(), (String)messageKey);
                        int questionResultIndex = msgDialog.getReturnCode();
                        result.add(questionResultIndex == 2);
                    }
                }
            }
        });
        return (Boolean)result.iterator().next();
    }

    public DebuggerDocumentProvider getDebuggerEditorDocumentProvider() {
        if (this.editorDocumentProvider == null) {
            this.editorDocumentProvider = new DebuggerDocumentProvider();
        }
        return this.editorDocumentProvider;
    }

    public static void squelch(boolean on) {
        fSquelch = on;
    }

    public static void setPrefRememberFork(int forkChoice) {
        fRememberFork = forkChoice;
    }

    public static int getPrefRememberFork() {
        return fRememberFork;
    }

    public static String getPrefGlobalEnginePath() {
        IPreferenceStore store = PICLDebugPlugin.getInstance().getPreferenceStore();
        String value = store.getString("global_engine_path");
        return value;
    }

    public static void setPrefGlobalEnginePath(String path) {
        IPreferenceStore store = PICLDebugPlugin.getInstance().getPreferenceStore();
        store.setValue("global_engine_path", path);
    }

    public static void resetPrefGlobalEnginePath() {
        IPreferenceStore store = PICLDebugPlugin.getInstance().getPreferenceStore();
        store.setToDefault("global_engine_path");
    }

    public void debugContextChanged(DebugContextEvent event) {
        this.fCurrentDebugContext = event.getContext();
        if (this.fCurrentDebugContext instanceof IStructuredSelection) {
            PDTCorePlugin.getInstance().setCurrentSelection(((IStructuredSelection)this.fCurrentDebugContext).getFirstElement());
        }
    }

    private ISelection getCurrentDebugContext() {
        return this.fCurrentDebugContext;
    }

    public void messageEventFired(IMessageEvent messageEvent) {
        if (messageEvent != null) {
            PICLDebugPlugin.showMessageDialog(null, messageEvent.getSeverity(), messageEvent.getMessage(), false);
        }
    }
}

