/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui;

import com.ibm.debug.pdt.internal.core.model.DebuggeeException;
import com.ibm.debug.pdt.internal.ui.dialogs.ICheckedListItem;
import org.eclipse.swt.graphics.Image;

public class ExceptionItem
implements ICheckedListItem {
    private DebuggeeException fException;
    private boolean fEnabled;
    private boolean fShowDefault;

    public ExceptionItem(DebuggeeException exception, boolean showDefault) {
        this.fException = exception;
        this.fEnabled = this.fException.isEnabled();
        this.fShowDefault = showDefault;
    }

    @Override
    public boolean isEnabled() {
        return this.fEnabled;
    }

    @Override
    public String getLabel() {
        Object label = this.fException.getName();
        if (this.fShowDefault && this.fException.getDefaultEnabled()) {
            label = (String)label + "*";
        }
        return label;
    }

    @Override
    public void setDefaultEnabledState() {
        this.fEnabled = this.fException.getDefaultEnabled();
    }

    @Override
    public void setEnabled(boolean state) {
        this.fEnabled = state;
    }

    public DebuggeeException getException() {
        return this.fException;
    }

    @Override
    public Image getImage() {
        return null;
    }

    public void commitChanges() {
        this.fException.setEnable(this.fEnabled);
    }

    @Override
    public int compareTo(ICheckedListItem o) {
        if (this.equals(o)) {
            return 0;
        }
        if (o instanceof ExceptionItem) {
            return this.fException.getName().compareTo(((ExceptionItem)o).getException().getName());
        }
        return 0;
    }
}

