/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.timeout;

import com.ibm.debug.pdt.internal.ui.timeout.Labels;
import com.ibm.debug.pdt.internal.ui.timeout.SessionTimeoutPreferenceInitializer;
import com.ibm.debug.pdt.internal.ui.timeout.TimeOutDialog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SessionTimeoutThread
extends Thread
implements IPropertyChangeListener {
    private IDebugTarget fDebugTarget;
    private int fInitialTimeOut;
    private int fCurrentTimeOut;
    private ByteArrayOutputStream fOutputStream;
    private boolean fTimerEnabled = true;
    private static int CONFIRM_DIALOG_TIMER = 30;
    private static int CONFIRM_DIALOG_TIMER_INCR = 10;

    SessionTimeoutThread(IDebugTarget debugTarget, ByteArrayOutputStream outputStream, int initialTimeOut) {
        super("Debug Session Timer");
        this.fDebugTarget = debugTarget;
        this.fOutputStream = outputStream;
        this.fCurrentTimeOut = this.fInitialTimeOut = initialTimeOut * 60;
    }

    @Override
    public void run() {
        while (this.fTimerEnabled) {
            if (this.fOutputStream.size() > 0) {
                this.fOutputStream.reset();
                this.reset();
                continue;
            }
            try {
                SessionTimeoutThread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
            --this.fCurrentTimeOut;
            if (this.fCurrentTimeOut > 0 || !this.fTimerEnabled) continue;
            if (this.confirmTerminate()) {
                try {
                    this.fDebugTarget.terminate();
                }
                catch (DebugException debugException) {}
                break;
            }
            this.reset();
        }
        if (this.fOutputStream != null) {
            try {
                this.fOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void reset() {
        this.fCurrentTimeOut = this.fInitialTimeOut;
    }

    public void stopTimer() {
        this.fTimerEnabled = false;
    }

    private boolean confirmTerminate() {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        final boolean[] rc = new boolean[]{true};
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                TimeOutDialog dialog = new TimeOutDialog(display.getActiveShell());
                try {
                    dialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            int countDown = CONFIRM_DIALOG_TIMER * CONFIRM_DIALOG_TIMER_INCR;
                            int delay = 1000 / CONFIRM_DIALOG_TIMER_INCR;
                            monitor.beginTask(Labels.SessionTimeoutThread_progress_text, countDown);
                            while (countDown-- > 0) {
                                monitor.worked(1);
                                if (monitor.isCanceled()) {
                                    rc[0] = false;
                                    break;
                                }
                                Thread.sleep(delay);
                            }
                            monitor.done();
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        if (rc[0]) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    int timeout = SessionTimeoutPreferenceInitializer.getPrefStore().getInt("sessionTimeout");
                    String message = NLS.bind((String)Labels.SessionTimeoutThread_timedout_message, (Object)timeout);
                    MessageDialog.openInformation((Shell)display.getActiveShell(), (String)Labels.SessionTimeoutThread_timedout_message_title, (String)message);
                }
            });
        }
        return rc[0];
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("sessionTimeout")) {
            this.fInitialTimeOut = (Integer)event.getNewValue() * 60;
            this.reset();
        } else if (event.getProperty().equals("sessionTimeoutEnabled")) {
            Object newValue = event.getNewValue();
            this.fTimerEnabled = newValue instanceof String ? ((String)newValue).equalsIgnoreCase("true") : (Boolean)event.getNewValue();
        }
    }
}

