/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profileManagement.internal;

import com.ibm.debug.pdt.profile.internal.LogUtils;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileException;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.ui.profileManagement.internal.ProfileManagementEditorInput;
import java.net.URL;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class ProfileManagementViewer
extends EditorPart
implements IDebugProfileConstants {
    private Browser fBrowser;
    private IEclipsePreferences.IPreferenceChangeListener fPreferenceChangeListener;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof ProfileManagementEditorInput) {
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(input);
            URL url = ((ProfileManagementEditorInput)input).getURL();
            this.fPreferenceChangeListener = event -> {
                if (event.getKey().equals("themeid") || event.getKey().equals("TokenAuthenticationEnabled")) {
                    Collection conns = ConnectionUtilities.getConnections();
                    for (Connection conn : conns) {
                        if (!conn.isConnected() || !conn.getHostName().equalsIgnoreCase(url.getHost())) continue;
                        try {
                            URL updatedUrl = conn.getProfileManagementServerURL();
                            this.fBrowser.setUrl(updatedUrl.toString());
                            ((ProfileManagementEditorInput)input).setURL(updatedUrl);
                        }
                        catch (DebugProfileException e) {
                            LogUtils.log((Throwable)e);
                        }
                    }
                }
            };
            IEclipsePreferences theme_prefs = InstanceScope.INSTANCE.getNode("org.eclipse.e4.ui.css.swt.theme");
            IEclipsePreferences launch_zpicl_prefs = InstanceScope.INSTANCE.getNode("com.ibm.debug.pdt.launch.zpicl");
            theme_prefs.addPreferenceChangeListener(this.fPreferenceChangeListener);
            launch_zpicl_prefs.addPreferenceChangeListener(this.fPreferenceChangeListener);
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        IEditorInput input = this.getEditorInput();
        if (input != null && input instanceof ProfileManagementEditorInput) {
            this.fBrowser = new Browser(parent, 264192);
            this.fBrowser.setUrl(((ProfileManagementEditorInput)input).getURL().toString());
        }
    }

    public void setFocus() {
        this.fBrowser.setFocus();
    }

    public void dispose() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.e4.ui.css.swt.theme");
        prefs.removePreferenceChangeListener(this.fPreferenceChangeListener);
    }
}

