/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.view;

import com.ibm.debug.pdt.profile.internal.cc.CodeCoverageUtils;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.ims.IIMSIsolationAPIProvider;
import com.ibm.debug.pdt.profile.internal.ims.IMSIsolationProfileUtils;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTCN;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTSP;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileIMS;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileUtils;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;

public class DebugProfileViewToolTipSupport
extends ColumnViewerToolTipSupport
implements IDebugProfileConstants {
    private Composite fParent;
    private DebugProfile fProfile;
    private boolean fShowAdvanced;

    DebugProfileViewToolTipSupport(ColumnViewer viewer, boolean manualActivation) {
        super(viewer, 2, manualActivation);
        this.setHideOnMouseDown(false);
    }

    protected Composite createViewerToolTipContentArea(Event event, ViewerCell cell, Composite parent) {
        Composite mainParent = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().equalWidth(true).applyTo(mainParent);
        this.fParent = mainParent;
        Composite main = new Composite(mainParent, 0);
        this.fProfile = (DebugProfile)cell.getElement();
        if (!this.fProfile.isValid() && cell.getColumnIndex() == 1) {
            GridLayoutFactory.swtDefaults().numColumns(1).applyTo(main);
            String[] stringArray = this.fProfile.getValidationIssues();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String m = stringArray[n2];
                Label l = new Label(main, 0);
                l.setText(m);
                ++n2;
            }
        } else {
            this.addBasicOptions(main);
            if (this.fShowAdvanced) {
                this.addAdvancedOptions(main);
            } else {
                Link link = new Link(main, 0);
                link.setText("<a>" + ProfileLabels.hover_show_details + "</a>");
                GridDataFactory.fillDefaults().span(2, 2).align(131072, 1024).applyTo((Control)link);
                link.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent arg0) {
                        DebugProfileViewToolTipSupport.this.doLinkSelected();
                    }

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                        DebugProfileViewToolTipSupport.this.doLinkSelected();
                    }
                });
            }
        }
        return main;
    }

    private void addBasicOptions(Composite main) {
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(main);
        this.addEntry(main, ProfileLabels.editor_profile_name, this.fProfile.getName());
        if (this.fProfile instanceof DebugProfileDTCN) {
            this.addDTCNBasicEntries((DebugProfileDTCN)this.fProfile, main);
        }
        if (this.fProfile instanceof DebugProfileIMS) {
            this.addIMSBasicEntries((DebugProfileIMS)this.fProfile, main);
        }
        if (this.fProfile instanceof DebugProfileDTSP) {
            this.addDTSPBasicEntries((DebugProfileDTSP)this.fProfile, main);
        }
        this.addLoadModulePairs(this.fProfile, main);
    }

    private void addDTSPBasicEntries(DebugProfileDTSP profile, Composite main) {
        if (profile.getIMSOptions() != null) {
            if (profile.getIMSOptions().getSubsystemID() != null && !profile.getIMSOptions().getSubsystemID().isEmpty()) {
                this.addEntry(main, ProfileLabels.hover_subsystem_id, profile.getIMSOptions().getSubsystemID());
            }
            if (profile.getIMSOptions().getTransactionID() != null && !profile.getIMSOptions().getTransactionID().isEmpty()) {
                this.addEntry(main, ProfileLabels.hover_transaction_id, profile.getIMSOptions().getTransactionID());
            }
        }
        if (profile.getJobInfo() != null) {
            if (profile.getJobInfo().getJobName() != null && !profile.getJobInfo().getJobName().isEmpty()) {
                this.addEntry(main, ProfileLabels.editor_job_name, profile.getJobInfo().getJobName());
            }
            if (profile.getJobInfo().getStepName() != null && !profile.getJobInfo().getStepName().isEmpty()) {
                this.addEntry(main, ProfileLabels.editor_step_name, profile.getJobInfo().getStepName());
            }
        }
    }

    private void addLoadModulePairs(DebugProfile profile, Composite main) {
        List pairs = profile.getLoadModulePairs();
        if (pairs != null && pairs.size() > 0) {
            Composite tableComposite = new Composite(main, 0);
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)tableComposite);
            TableColumnLayout layout = new TableColumnLayout(false);
            tableComposite.setLayout((Layout)layout);
            TableViewer table = new TableViewer(tableComposite, 67584);
            table.getTable().setHeaderVisible(true);
            table.getTable().setLinesVisible(true);
            TableViewerColumn col1 = new TableViewerColumn(table, 0);
            col1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof DebugProfile.LoadModulePair) {
                        return ((DebugProfile.LoadModulePair)element).getLoadModule();
                    }
                    return super.getText(element);
                }
            });
            col1.getColumn().setText(ProfileLabels.editor_load_module);
            layout.setColumnData((Widget)col1.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, 100, true));
            TableViewerColumn col2 = new TableViewerColumn(table, 0);
            col2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof DebugProfile.LoadModulePair) {
                        return ((DebugProfile.LoadModulePair)element).getCompilationUnit();
                    }
                    return super.getText(element);
                }
            });
            col2.getColumn().setText(ProfileLabels.editor_compile_unit);
            layout.setColumnData((Widget)col2.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, 100, true));
            table.setContentProvider((IContentProvider)new ArrayContentProvider());
            table.setInput((Object)pairs.toArray());
        }
    }

    private void addDTCNBasicEntries(DebugProfileDTCN profile, Composite main) {
        if (profile.getPort() > 0) {
            this.addEntry(main, ProfileLabels.editor_connect_port, Integer.toString(profile.getPort()));
        } else {
            this.addEntry(main, ProfileLabels.editor_cics_region, profile.getRegion());
        }
        this.addEntry(main, ProfileLabels.editor_cics_transaction, profile.getTransaction());
        this.addEntry(main, ProfileLabels.editor_cics_user_id, profile.getAdditionalCICSFilters().getUserID());
        this.addEntry(main, ProfileLabels.editor_cics_netname, profile.getAdditionalCICSFilters().getNetName());
        this.addEntry(main, ProfileLabels.editor_cics_ip, profile.getAdditionalCICSFilters().getIP());
        this.addEntry(main, ProfileLabels.editor_cics_sysid, profile.getAdditionalCICSFilters().getCICSSysID());
        this.addEntry(main, ProfileLabels.editor_cics_terminal_id, profile.getAdditionalCICSFilters().getTerminalID());
    }

    private void addEntry(Composite main, String label, String value) {
        this.addEntry(main, label, value, true, false);
    }

    private void addEntry(Composite main, String label, String value, boolean boldLabel, boolean boldValue) {
        if (value != null && !value.isEmpty()) {
            Font bold = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            Font normal = JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont");
            Label l = new Label(main, 0);
            l.setText(label);
            l.setFont(boldLabel ? bold : normal);
            l = new Label(main, 0);
            l.setText(value);
            l.setFont(boldValue ? bold : normal);
        }
    }

    private void doLinkSelected() {
        Point currentSize = this.fParent.getShell().getSize();
        Control[] controlArray = this.fParent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        Composite main = new Composite(this.fParent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(main);
        this.addBasicOptions(main);
        this.addAdvancedOptions(main);
        this.fParent.layout();
        this.fParent.getShell().layout(true);
        Point idealSize = this.fParent.getShell().computeSize(-1, -1);
        this.fParent.getShell().setSize(Math.max(currentSize.x, idealSize.x), Math.max(currentSize.y, idealSize.y));
        idealSize = this.fParent.getShell().getSize();
        Rectangle screenSize = this.fParent.getShell().getDisplay().getBounds();
        if (this.fParent.getShell().getDisplay().getPrimaryMonitor() != null) {
            screenSize = this.fParent.getShell().getDisplay().getPrimaryMonitor().getClientArea();
        }
        Point location = this.fParent.getShell().getLocation();
        Point newLocation = new Point(location.x, location.y);
        if (location.x + idealSize.x > screenSize.width) {
            newLocation.x = screenSize.width - idealSize.x - 5;
        }
        if (location.y + idealSize.y > screenSize.height) {
            newLocation.y = screenSize.height - idealSize.y - 5;
        }
        if (location.x != newLocation.x || location.y != newLocation.y) {
            this.fParent.getShell().setLocation(newLocation);
        }
    }

    private void addAdvancedOptions(Composite main) {
        if (this.fProfile instanceof DebugProfileDTCN) {
            this.addAdvancedDTCNOptions(main);
        }
        this.addConnectionInfo(main);
        this.addTestRuntimeInfo(main);
        this.addLEOptions(main);
        this.addProfileErrors(main);
    }

    private void addAdvancedDTCNOptions(Composite main) {
        DebugProfileDTCN.AdvancedProgramInterruptionCriteria filters = ((DebugProfileDTCN)this.fProfile).getAdvancedProgramInterruptionCriteria();
        if (filters != null) {
            DebugProfileDTCN.CommAreaInfo cainfo;
            DebugProfileDTCN.ContainerInfo cinfo;
            DebugProfileDTCN.ApplicationInfo ainfo = filters.getApplicationInfo();
            if (ainfo != null) {
                this.addEntry(main, ProfileLabels.editor_cics_platform_name, ainfo.getPlatformName());
                this.addEntry(main, ProfileLabels.editor_cics_application_name, ainfo.getApplicationName());
                this.addEntry(main, ProfileLabels.editor_cics_operation_name, ainfo.getOperationName());
                this.addEntry(main, ProfileLabels.editor_cics_application_version, ainfo.getApplicationVersion());
            }
            if ((cinfo = filters.getContainerInfo()) != null) {
                this.addEntry(main, ProfileLabels.hover_container_name, cinfo.getName());
                this.addEntry(main, ProfileLabels.hover_container_data, cinfo.getData());
                this.addEntry(main, ProfileLabels.hover_container_offset, cinfo.getOffset());
            }
            if ((cainfo = filters.getCommAreaInfo()) != null) {
                this.addEntry(main, ProfileLabels.editor_cics_communication_area_data, cainfo.getData());
                this.addEntry(main, ProfileLabels.editor_cics_communication_area_offset, cainfo.getOffset());
            }
        }
    }

    private void addLEOptions(Composite main) {
        String startupKey;
        DebugProfile.DebuggerOptions debugOptions = this.fProfile.getDebuggerOptions();
        if (debugOptions != null && debugOptions.getLanguageEnvironmentOptions() != null && !debugOptions.getLanguageEnvironmentOptions().isEmpty()) {
            this.addEntry(main, ProfileLabels.editor_language_environment_options, debugOptions.getLanguageEnvironmentOptions());
        }
        if (CodeCoverageUtils.isCodeCoverageClient() && (this.fProfile.getState() != 1 || this.fProfile.getMode() != 1) && (startupKey = CodeCoverageUtils.generateStartupKey((DebugProfile)this.fProfile)) != null) {
            this.addEntry(main, ProfileLabels.hover_startup_key, startupKey);
            if (this.fProfile.getMode() == 2) {
                this.addEntry(main, ProfileLabels.hover_updated_le_options, DebugProfileUtils.getUpdatedLEOptions((DebugProfile)this.fProfile, (boolean)true));
            }
        }
    }

    private void addProfileErrors(Composite main) {
        String[] errors = this.fProfile.getValidationIssues();
        if (errors != null && errors.length > 0) {
            Font bold = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            Label l = new Label(main, 0);
            l.setText(ProfileLabels.hover_profile_errors);
            l.setFont(bold);
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)l);
            String[] stringArray = errors;
            int n = errors.length;
            int n2 = 0;
            while (n2 < n) {
                String m = stringArray[n2];
                l = new Label(main, 0);
                l.setText(m);
                GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)l);
                ++n2;
            }
        }
    }

    private void addTestRuntimeInfo(Composite main) {
        this.addEntry(main, ProfileLabels.hover_test_runtime, DebugProfileUtils.getTestRuntimeOption((DebugProfile)this.fProfile).replace("&", "&&"));
    }

    private void addConnectionInfo(Composite main) {
        this.addEntry(main, ProfileLabels.editor_connection, this.fProfile.getConnectionName());
        Connection c = ConnectionUtilities.getConnection((String)this.fProfile.getConnectionName(), (boolean)false);
        if (c != null) {
            Object connectionStatus = ProfileLabels.hover_connected;
            if (c.getErrorState() == Connection.ERROR_STATE.BACK_LEVEL) {
                connectionStatus = ProfileLabels.hover_not_supported;
            } else if (c.getErrorState() == Connection.ERROR_STATE.NOT_CONNECTED) {
                connectionStatus = ProfileLabels.hover_not_connected;
            } else if (c.getErrorState() == Connection.ERROR_STATE.HOST_ERROR || c.getErrorState() == Connection.ERROR_STATE.CLIENT_ERROR) {
                connectionStatus = ProfileLabels.hover_not_available;
            } else if (c.getErrorState() == Connection.ERROR_STATE.CICS_ONLY) {
                connectionStatus = NLS.bind((String)ProfileLabels.editor_dtcn_profile, (Object)ProfileLabels.hover_connected) + "\n" + NLS.bind((String)ProfileLabels.editor_dtsp_profile, (Object)ProfileLabels.hover_not_available);
            }
            if (c.getAPIServerURL() != null) {
                this.addEntry(main, ProfileLabels.hover_api_url, c.getAPIServerURL().toString());
            }
            this.addEntry(main, ProfileLabels.hover_api_status, (String)connectionStatus);
            if (this.fProfile instanceof DebugProfileIMS) {
                DebugProfileIMS ims = (DebugProfileIMS)this.fProfile;
                IIMSIsolationAPIProvider provider = IMSIsolationProfileUtils.getIMSIsolationAPIProvider();
                IIMSIsolationAPIProvider.IMS_API_STATUS status = provider.getIMSAPIStatus(ims);
                Object imsAPIStatus = null;
                switch (status) {
                    case IMS_API_BACK_LEVEL: {
                        imsAPIStatus = ProfileLabels.hover_ims_back_level;
                        break;
                    }
                    case IMS_REST_API: {
                        imsAPIStatus = ProfileLabels.hover_connected + "[DPS]";
                        break;
                    }
                    default: {
                        imsAPIStatus = ProfileLabels.hover_not_connected;
                    }
                }
                this.addEntry(main, ProfileLabels.hover_ims_api_status, (String)imsAPIStatus);
            }
        }
    }

    public void showAdvanced(Point location) {
        this.fShowAdvanced = true;
        this.show(location);
        this.fShowAdvanced = false;
    }

    private void addIMSBasicEntries(DebugProfileIMS profile, Composite main) {
        this.addEntry(main, ProfileLabels.hover_ims_id, profile.getIMSID());
        String region = profile.getIMSJobName();
        region = region == null ? "@&USER" : region;
        region = region.replace("&", "&&");
        this.addEntry(main, ProfileLabels.hover_ims_region, region);
        DebugProfileIMS.Transaction[] transactions = profile.getTransactions();
        if (transactions != null) {
            StringBuilder sb = new StringBuilder();
            DebugProfileIMS.Transaction[] transactionArray = transactions;
            int n = transactions.length;
            int n2 = 0;
            while (n2 < n) {
                DebugProfileIMS.Transaction t = transactionArray[n2];
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if (sb.length() > 40) {
                    sb.append('\n');
                }
                sb.append(t.getName());
                ++n2;
            }
            if (sb.length() > 0) {
                this.addEntry(main, ProfileLabels.hover_ims_transaction, sb.toString());
            }
        }
    }
}

