/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.view;

import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class DebugProfileTableComparator
extends ViewerComparator {
    private static final int[] fSortFactor;
    private static final int NOSORT = 0;
    private static final int ASCENDING = 1;
    private static final int DESCENDING = 2;
    protected int fSortColumn = -1;
    protected int fSortDirection = 0;
    private CellLabelProvider fLabelProvider;
    private CellLabelProvider fDefaultLabelProvider;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = -1;
        fSortFactor = nArray;
    }

    public void setDefaultLabelProvider(CellLabelProvider defaultLabelProvider) {
        this.fDefaultLabelProvider = defaultLabelProvider;
    }

    public void setColumn(int column, CellLabelProvider labelProvider) {
        if (column == this.fSortColumn) {
            switch (this.fSortDirection) {
                case 0: {
                    this.fSortDirection = 1;
                    break;
                }
                case 1: {
                    this.fSortDirection = 2;
                    break;
                }
                case 2: {
                    this.fSortDirection = 0;
                    this.fLabelProvider = null;
                    break;
                }
            }
        } else {
            this.fSortColumn = column;
            this.fSortDirection = 1;
            this.fLabelProvider = labelProvider;
        }
    }

    public int getSortDirection() {
        switch (this.fSortDirection) {
            case 1: {
                return 128;
            }
            case 2: {
                return 1024;
            }
        }
        return 0;
    }

    public int compare(Viewer viewer, Object profile1, Object profile2) {
        if (this.fLabelProvider != null || this.fDefaultLabelProvider != null) {
            String label1 = this.getLabel(profile1);
            String label2 = this.getLabel(profile2);
            int sortResult = label1.compareTo(label2);
            if (this.fSortDirection == 0) {
                return sortResult;
            }
            return sortResult * fSortFactor[this.fSortDirection];
        }
        return super.compare(viewer, profile1, profile2);
    }

    private String getLabel(Object profile) {
        if (this.fLabelProvider instanceof ColumnLabelProvider) {
            return ((ColumnLabelProvider)this.fLabelProvider).getText(profile);
        }
        if (this.fLabelProvider instanceof DecoratingStyledCellLabelProvider) {
            return ((DecoratingStyledCellLabelProvider)this.fLabelProvider).getStyledStringProvider().getStyledText(profile).getString();
        }
        if (this.fDefaultLabelProvider instanceof DecoratingStyledCellLabelProvider) {
            return ((DecoratingStyledCellLabelProvider)this.fDefaultLabelProvider).getStyledStringProvider().getStyledText(profile).getString();
        }
        return "";
    }
}

