/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.view;

import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTCN;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTSP;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileIMS;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.ui.profile.internal.Activator;
import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.dialogs.SearchPattern;

public class DebugProfileLabelProvider
extends ColumnLabelProvider
implements IDebugProfileConstants,
DelegatingStyledCellLabelProvider.IStyledLabelProvider,
IFontProvider {
    private static final String EMPTY = "";
    private static final String[] STATE_LABELS = new String[]{ProfileLabels.profile_state_inactive, ProfileLabels.profile_state_active, ProfileLabels.profile_state_inactive, ProfileLabels.profile_state_inactive, ProfileLabels.profile_state_inactive};
    static final String[] MODE_LABELS = new String[]{"", ProfileLabels.profile_mode_debug, ProfileLabels.profile_mode_codecoverage, ProfileLabels.profile_mode_recording, ProfileLabels.profile_mode_recording};
    private Map<String, Image> fImageMap = new HashMap<String, Image>();
    private int fColumnIdx;
    private FilteredTree fTree;

    public DebugProfileLabelProvider(int columnIdx, FilteredTree filterTree) {
        this.fColumnIdx = columnIdx;
        this.fTree = filterTree;
    }

    public String getText(Object element) {
        if (!(element instanceof DebugProfile)) {
            return EMPTY;
        }
        switch (this.fColumnIdx) {
            case 2: {
                return DebugProfileLabelProvider.getModeLabel((DebugProfile)element);
            }
            case 0: {
                return ((DebugProfile)element).getName();
            }
            case 1: {
                return DebugProfileLabelProvider.getStateLabel((DebugProfile)element);
            }
            case 4: {
                return ((DebugProfile)element).getConnectionName();
            }
            case 5: {
                return ((DebugProfile)element).getDescription();
            }
            case 3: {
                return this.getLocationText((DebugProfile)element);
            }
            case 6: {
                return this.getLoadModuleAndCU((DebugProfile)element);
            }
            case 7: {
                return this.getTransaction((DebugProfile)element);
            }
            case 8: {
                return this.getUser((DebugProfile)element);
            }
            case 9: {
                return this.getSysId((DebugProfile)element);
            }
            case 10: {
                return this.getNetName((DebugProfile)element);
            }
            case 11: {
                return this.getIp((DebugProfile)element);
            }
            case 12: {
                return this.getTerminalID((DebugProfile)element);
            }
            case 13: {
                return this.getJobName((DebugProfile)element);
            }
            case 14: {
                return this.getStepName((DebugProfile)element);
            }
            case 15: {
                return this.getIMSID((DebugProfile)element);
            }
        }
        return EMPTY;
    }

    private String getIMSID(DebugProfile element) {
        if (element instanceof DebugProfileIMS) {
            return ((DebugProfileIMS)element).getIMSID() == null ? EMPTY : ((DebugProfileIMS)element).getIMSID();
        }
        if (element instanceof DebugProfileDTSP && ((DebugProfileDTSP)element).getIMSOptions() != null) {
            return ((DebugProfileDTSP)element).getIMSOptions().getSubsystemID();
        }
        return EMPTY;
    }

    private String getStepName(DebugProfile element) {
        if (element instanceof DebugProfileDTSP && ((DebugProfileDTSP)element).getJobInfo() != null) {
            return ((DebugProfileDTSP)element).getJobInfo().getStepName();
        }
        return EMPTY;
    }

    private String getJobName(DebugProfile element) {
        if (element instanceof DebugProfileDTSP && ((DebugProfileDTSP)element).getJobInfo() != null) {
            return ((DebugProfileDTSP)element).getJobInfo().getJobName();
        }
        return EMPTY;
    }

    private String getTerminalID(DebugProfile element) {
        if (element instanceof DebugProfileDTCN && ((DebugProfileDTCN)element).getAdditionalCICSFilters() != null) {
            return ((DebugProfileDTCN)element).getAdditionalCICSFilters().getTerminalID();
        }
        return EMPTY;
    }

    private String getIp(DebugProfile element) {
        if (element instanceof DebugProfileDTCN && ((DebugProfileDTCN)element).getAdditionalCICSFilters() != null) {
            return ((DebugProfileDTCN)element).getAdditionalCICSFilters().getIP();
        }
        return EMPTY;
    }

    private String getNetName(DebugProfile element) {
        if (element instanceof DebugProfileDTCN && ((DebugProfileDTCN)element).getAdditionalCICSFilters() != null) {
            return ((DebugProfileDTCN)element).getAdditionalCICSFilters().getNetName();
        }
        return EMPTY;
    }

    private String getUser(DebugProfile element) {
        if (element instanceof DebugProfileDTCN && ((DebugProfileDTCN)element).getAdditionalCICSFilters() != null) {
            return ((DebugProfileDTCN)element).getAdditionalCICSFilters().getUserID();
        }
        return EMPTY;
    }

    private String getSysId(DebugProfile element) {
        if (element instanceof DebugProfileDTCN && ((DebugProfileDTCN)element).getAdditionalCICSFilters() != null) {
            return ((DebugProfileDTCN)element).getAdditionalCICSFilters().getCICSSysID();
        }
        return EMPTY;
    }

    private String getTransaction(DebugProfile element) {
        if (element instanceof DebugProfileDTCN) {
            return ((DebugProfileDTCN)element).getTransaction();
        }
        if (element instanceof DebugProfileIMS) {
            DebugProfileIMS.Transaction[] transactions = ((DebugProfileIMS)element).getTransactions();
            if (transactions != null) {
                StringBuilder sb = new StringBuilder();
                DebugProfileIMS.Transaction[] transactionArray = transactions;
                int n = transactions.length;
                int n2 = 0;
                while (n2 < n) {
                    DebugProfileIMS.Transaction t = transactionArray[n2];
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(t.getName());
                    ++n2;
                }
                return sb.toString();
            }
        } else if (((DebugProfileDTSP)element).getIMSOptions() != null) {
            return ((DebugProfileDTSP)element).getIMSOptions().getTransactionID();
        }
        return EMPTY;
    }

    private String getLoadModuleAndCU(DebugProfile element) {
        StringBuilder result = new StringBuilder();
        List pairs = element.getLoadModulePairs();
        for (DebugProfile.LoadModulePair pair : pairs) {
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(pair.getLoadModule());
            result.append('/');
            result.append(pair.getCompilationUnit());
        }
        return result.toString();
    }

    private String getLocationText(DebugProfile profile) {
        if (profile instanceof DebugProfileDTCN) {
            String region = ((DebugProfileDTCN)profile).getRegion();
            if (region != null && !region.isEmpty()) {
                return region;
            }
            if (((DebugProfileDTCN)profile).getPort() > 0) {
                return Integer.toString(((DebugProfileDTCN)profile).getPort());
            }
        } else if (profile instanceof DebugProfileDTSP) {
            String location = ((DebugProfileDTSP)profile).getLocation();
            return location == null ? EMPTY : location;
        }
        return EMPTY;
    }

    static String getTypeLabel(DebugProfile debugProfile) {
        if (debugProfile instanceof DebugProfileDTCN) {
            return ProfileLabels.profile_type_cics;
        }
        if (debugProfile instanceof DebugProfileIMS) {
            return ProfileLabels.profile_type_ims;
        }
        return ProfileLabels.profile_type_noncics;
    }

    static String getStateLabel(DebugProfile debugProfile) {
        if (debugProfile.isValid()) {
            return STATE_LABELS[debugProfile.getState()];
        }
        return ProfileLabels.profile_state_incomplete;
    }

    static String getModeLabel(DebugProfile debugProfile) {
        return MODE_LABELS[debugProfile.getMode()];
    }

    public Image getImage(Object element) {
        if (!(element instanceof DebugProfile)) {
            return null;
        }
        switch (this.fColumnIdx) {
            case 0: {
                return this.getTypeImage((DebugProfile)element);
            }
            case 1: {
                return this.getStateImage((DebugProfile)element);
            }
            case 4: {
                return this.getConnectionImage((DebugProfile)element);
            }
            case 2: {
                return this.getModeImage((DebugProfile)element);
            }
        }
        return null;
    }

    private Image getConnectionImage(DebugProfile profile) {
        Connection c = ConnectionUtilities.getConnection((String)profile.getConnectionName(), (boolean)false);
        if (c != null && !c.isConnected()) {
            return this.getImage("PROFILE_ICON_CONN_DISCONNECTED");
        }
        if (profile.getConnectionName() != null && !profile.getConnectionName().isEmpty() && (c == null || profile.isBackLevelRequired(c))) {
            return this.getImage("PROFILE_ICON_WARNING");
        }
        return null;
    }

    private Image getTypeImage(DebugProfile profile) {
        if (profile instanceof DebugProfileDTCN) {
            return this.getImage("PROFILE_ICON_DTCN");
        }
        if (profile instanceof DebugProfileIMS) {
            return this.getImage("PROFILE_ICON_IMS");
        }
        return this.getImage("PROFILE_ICON_DTSP");
    }

    private Image getImage(String key) {
        if (!this.fImageMap.containsKey(key)) {
            this.fImageMap.put(key, Activator.getDefault().getImageRegistry().getDescriptor(key).createImage());
        }
        return this.fImageMap.get(key);
    }

    private Image getStateImage(DebugProfile profile) {
        if (!profile.isValid()) {
            return this.getImage("PROFILE_ICON_STATE_INCOMPLETE");
        }
        switch (profile.getState()) {
            case 1: {
                return this.getImage("PROFILE_ICON_STATE_ACTIVE");
            }
        }
        return this.getImage("PROFILE_ICON_STATE_INACTIVE");
    }

    private Image getModeImage(DebugProfile profile) {
        switch (profile.getMode()) {
            case 1: {
                return this.getImage("PROFILE_ICON_DEBUG");
            }
            case 2: {
                return this.getImage("PROFILE_ICON_CODE_COVERAGE");
            }
            case 3: 
            case 4: {
                return this.getImage("PROFILE_ICON_RECORD");
            }
        }
        return null;
    }

    public void dispose() {
        for (Image i : this.fImageMap.values()) {
            i.dispose();
        }
        this.fImageMap.clear();
    }

    public String getToolTipText(Object element) {
        return this.getText(element);
    }

    public StyledString getStyledText(Object element) {
        return new StyledString(this.getText(element));
    }

    public Font getFont(Object element) {
        Object filterText = this.fTree.getFilterControl().getText();
        filterText = ((String)filterText).startsWith("*") ? filterText : "*" + (String)filterText;
        SearchPattern pattern = new SearchPattern();
        pattern.setPattern((String)filterText);
        if (this.getText(element) != null && pattern.matches(this.getText(element))) {
            Font f = FilteredTree.getBoldFont((Object)element, (FilteredTree)this.fTree, (PatternFilter)this.fTree.getPatternFilter());
            return f;
        }
        return JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont");
    }
}

