/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.outline;

import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.ui.profile.internal.Activator;
import com.ibm.debug.pdt.ui.profile.internal.IDebugProfileViewConstants;
import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import com.ibm.debug.pdt.ui.profile.internal.editor.DebugProfileEditorHelper;
import com.ibm.debug.pdt.ui.profile.internal.editor.IDebugProfileEditorConstants;
import com.ibm.debug.pdt.ui.profile.internal.editor.ims.IIMSIsolationComposite;
import com.ibm.ftt.debug.ui.composites.dlydbg.DelayDebugComposite;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.Section;

public class DebugProfileOutlineLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
IDebugProfileConstants,
IDebugProfileViewConstants {
    private Map<String, Image> fImageMap = new HashMap<String, Image>();
    private StyledString.Styler stylerFieldWithValue;
    private StyledString.Styler stylerFieldEmptyValue;
    IDebugProfileEditorConstants.PROFILE_TYPE fType;

    public DebugProfileOutlineLabelProvider(IDebugProfileEditorConstants.PROFILE_TYPE type) {
        this.fType = type;
        this.stylerFieldEmptyValue = new StyledString.Styler(){

            public void applyStyles(TextStyle arg0) {
            }
        };
        this.stylerFieldWithValue = new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                Font bold;
                textStyle.font = bold = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
            }
        };
    }

    public void addListener(ILabelProviderListener arg0) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object arg0, String arg1) {
        return false;
    }

    public void removeListener(ILabelProviderListener arg0) {
    }

    public Image getImage(Object element) {
        Image image = null;
        if (element instanceof Section) {
            image = this.getImage("PROFILE_ICON_SECTION");
        } else if (element instanceof Group) {
            image = this.getImage("PROFILE_ICON_GROUP");
        } else if (element instanceof Control) {
            Control control = (Control)element;
            image = control.isEnabled() ? this.getImage("PROFILE_ICON_FIELD") : this.getImage("PROFILE_ICON_FIELD_GRAY");
        }
        return image;
    }

    private Image getImage(String key) {
        if (!this.fImageMap.containsKey(key)) {
            this.fImageMap.put(key, Activator.getDefault().getImageRegistry().getDescriptor(key).createImage());
        }
        return this.fImageMap.get(key);
    }

    public StyledString getStyledText(Object inputElement) {
        String labelText = this.getText(inputElement);
        StyledString.Styler styler = this.getStyler(this.elementHasValueOrNonDefault(inputElement));
        StyledString styledString = new StyledString(labelText, styler);
        return styledString;
    }

    private boolean elementHasValueOrNonDefault(Object inputElement) {
        if (inputElement instanceof Text) {
            Text text = (Text)inputElement;
            String defaultValue = (String)((Text)inputElement).getData("outlineDefault");
            if (defaultValue == null) {
                return text.getText().length() > 0;
            }
            return !text.getText().equals(defaultValue);
        }
        if (inputElement instanceof Button) {
            Button button = (Button)inputElement;
            return button.getSelection();
        }
        if (inputElement instanceof CCombo) {
            CCombo combo = (CCombo)inputElement;
            String defaultValue = (String)combo.getData("outlineDefault");
            if (defaultValue != null) {
                return !combo.getText().equals(defaultValue);
            }
            if (combo.getData("outlineWidget") instanceof Label) {
                Label label = (Label)combo.getData("outlineWidget");
                String labelText = label.getText();
                if (labelText.equals(ProfileLabels.editor_test_level)) {
                    return !combo.getText().equals(DebugProfileEditorHelper.TEST_LEVEL_DEFAULT);
                }
                if (labelText.equals(ProfileLabels.editor_error_level)) {
                    switch (this.fType) {
                        case PROFILE_NON_CICS: 
                        case PROFILE_IMS: {
                            return !combo.getText().equals(DebugProfileEditorHelper.ERROR_LEVEL_DEFAULT_NONCICS);
                        }
                    }
                    return !combo.getText().equals(DebugProfileEditorHelper.ERROR_LEVEL_DEFAULT_CICS);
                }
                if (labelText.equals(ProfileLabels.editor_prompt_level)) {
                    return !combo.getText().equals(DebugProfileEditorHelper.PROMPT_LEVEL_DEFAULT);
                }
                return combo.getText().length() > 0;
            }
        } else {
            Object labelElement;
            if (inputElement instanceof DelayDebugComposite) {
                DelayDebugComposite composite = (DelayDebugComposite)inputElement;
                return composite.getDebugItems().size() > 1;
            }
            if ((inputElement instanceof Table || inputElement instanceof List) && (labelElement = ((Widget)inputElement).getData("outlineWidget")) instanceof IIMSIsolationComposite) {
                return ((IIMSIsolationComposite)labelElement).isModified();
            }
        }
        return false;
    }

    private StyledString.Styler getStyler(boolean hasValue) {
        StyledString.Styler styler = hasValue ? this.stylerFieldWithValue : this.stylerFieldEmptyValue;
        return styler;
    }

    private String getText(Object inputElement) {
        String labelText = "";
        if (inputElement instanceof Widget && ((Widget)inputElement).getData("outlineWidget") != null) {
            Object labelElement = ((Widget)inputElement).getData("outlineWidget");
            if (labelElement instanceof DelayDebugComposite) {
                labelText = ProfileLabels.profile_table_column_loadmod_cu;
            } else if (labelElement instanceof IIMSIsolationComposite) {
                labelText = ((IIMSIsolationComposite)labelElement).getOutlineLabel();
            } else if (labelElement instanceof Section) {
                labelText = ((Section)labelElement).getText();
            } else if (labelElement instanceof Group) {
                labelText = ((Group)labelElement).getText();
            } else if (labelElement instanceof Button) {
                labelText = ((Button)labelElement).getText();
            } else if (labelElement instanceof Label) {
                labelText = ((Label)labelElement).getText();
            }
            labelText = labelText.trim();
            if (!labelText.isEmpty() && labelText.endsWith(ProfileLabels.editor_colon)) {
                int endIdx = labelText.indexOf(ProfileLabels.editor_colon);
                labelText = labelText.substring(0, endIdx);
                labelText = labelText.trim();
            }
        }
        return labelText;
    }
}

