/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.handlers;

import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.profile.internal.LogUtils;
import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileException;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import com.ibm.debug.pdt.ui.profile.internal.handlers.AbstractProfileHandler;
import com.ibm.debug.pdt.ui.profileManagement.internal.IProfileManagementConstants;
import com.ibm.debug.pdt.ui.profileManagement.internal.ProfileManagementEditorInput;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class ShowProfileManagementHandler
extends AbstractProfileHandler
implements IProfileManagementConstants,
IDebugProfileConstants {
    IEditorInput fEditorInput;

    private static boolean isWebview2Installed() {
        boolean webviewIsInstalled;
        try {
            Process HKLMprocess = Runtime.getRuntime().exec("reg query HKLM\\SOFTWARE\\WOW6432Node\\Microsoft\\EdgeUpdate\\Clients\\{F3017226-FE2A-4295-8BDF-00C3A9A7E4C5} /v pv");
            Process HKCUprocess = Runtime.getRuntime().exec("reg query HKCU\\Software\\Microsoft\\EdgeUpdate\\Clients\\{F3017226-FE2A-4295-8BDF-00C3A9A7E4C5} /v pv");
            ExecutorService service = Executors.newSingleThreadExecutor();
            Future<Boolean> future = service.submit(new CheckWebview2InstalledTask(HKCUprocess, HKLMprocess));
            webviewIsInstalled = future.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            LogUtils.log((Throwable)e);
            webviewIsInstalled = false;
        }
        return webviewIsInstalled;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final String hostParameter = event.getParameter("com.ibm.debug.pdt.ui.profile.eclipse.command.showProfileManagement.host");
        Job[] jobs = Job.getJobManager().find((Object)"Launch Profile Management Job Family");
        if (jobs.length > 0) {
            return null;
        }
        Collection conns = ConnectionUtilities.getConnections();
        for (final Connection conn : conns) {
            if (!conn.getConnectionName().equals(hostParameter)) continue;
            if (!conn.isConnected()) {
                Job signInJob = new Job(ProfileLabels.LAUNCH_PROFILE_MANAGEMENT_JOB_TITLE){

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.beginTask(ProfileLabels.LAUNCH_PROFILE_MANAGEMENT_JOB_TITLE, -1);
                        try {
                            ConnectionUtilities.getConnection((String)conn.getConnectionName(), (boolean)true);
                        }
                        catch (Exception e) {
                            ShowProfileManagementHandler.handleException(e);
                            return Status.CANCEL_STATUS;
                        }
                        monitor.done();
                        ShowProfileManagementHandler.this.openProfileManagementBrowser(hostParameter);
                        return Status.OK_STATUS;
                    }

                    public boolean belongsTo(Object family) {
                        return family.equals("Launch Profile Management Job Family");
                    }
                };
                signInJob.setSystem(false);
                signInJob.schedule();
                continue;
            }
            this.openProfileManagementBrowser(hostParameter);
        }
        return null;
    }

    private void openInternalBrowser(URL profileManagementURL) {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor(this.fEditorInput);
        if (editor == null) {
            this.fEditorInput = new ProfileManagementEditorInput(profileManagementURL);
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(this.fEditorInput, "com.ibm.debug.pdt.ui.profile.eclipse.ProfileManagementWebViewer");
            }
            catch (PartInitException e) {
                LogUtils.log((Throwable)e);
            }
        } else {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)editor);
            editor.setFocus();
        }
    }

    private void openExternalBrowser(URL profileManagementURL) {
        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            browserSupport.createBrowser(128, null, null, null).openURL(profileManagementURL);
        }
        catch (NullPointerException | PartInitException e) {
            LogUtils.log((Throwable)e);
        }
    }

    private void openProfileManagementBrowser(final String hostName) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Collection conns = ConnectionUtilities.getConnections();
                URL profileManagementURL = null;
                for (Connection conn : conns) {
                    if (!conn.getConnectionName().equals(hostName)) continue;
                    try {
                        profileManagementURL = conn.getProfileManagementServerURL();
                    }
                    catch (DebugProfileException e) {
                        ShowProfileManagementHandler.handleException((Exception)((Object)e));
                        return;
                    }
                    if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                        if (!ShowProfileManagementHandler.isWebview2Installed()) {
                            PICLDebugPlugin.showMessageDialog((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (int)2, (String)ProfileLabels.debug_profile_message, (String)ProfileMessages.CRRDG9171, (boolean)false);
                            ShowProfileManagementHandler.this.openExternalBrowser(profileManagementURL);
                            continue;
                        }
                        ShowProfileManagementHandler.this.openInternalBrowser(profileManagementURL);
                        continue;
                    }
                    ShowProfileManagementHandler.this.openInternalBrowser(profileManagementURL);
                }
            }
        });
    }

    static class CheckWebview2InstalledTask
    implements Callable<Boolean> {
        final Process HKLMprocess;
        final Process HKCUprocess;

        public CheckWebview2InstalledTask(Process HKCUprocess, Process HKLMprocess) {
            this.HKCUprocess = HKCUprocess;
            this.HKLMprocess = HKLMprocess;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Boolean call() {
            try {
                this.HKLMprocess.waitFor();
                this.HKCUprocess.waitFor();
            }
            catch (InterruptedException e) {
                LogUtils.log((Throwable)e);
                return false;
            }
            InputStream HKCUErrorStream = this.HKCUprocess.getErrorStream();
            InputStream HKLMErrorStream = this.HKLMprocess.getErrorStream();
            try {
                Throwable throwable = null;
                Object var4_7 = null;
                try {
                    BufferedReader HKLMReader;
                    BufferedReader HKCUreader;
                    block16: {
                        Boolean bl;
                        HKCUreader = new BufferedReader(new InputStreamReader(HKCUErrorStream, Charset.defaultCharset()));
                        try {
                            block17: {
                                HKLMReader = new BufferedReader(new InputStreamReader(HKLMErrorStream, Charset.defaultCharset()));
                                try {
                                    String HKCUErrorMessage = HKCUreader.lines().collect(Collectors.joining(System.lineSeparator()));
                                    String HKLMErrorMessage = HKLMReader.lines().collect(Collectors.joining(System.lineSeparator()));
                                    if (!HKLMErrorMessage.contains("ERROR: The system was unable to find the specified registry key or value.") || !HKCUErrorMessage.contains("ERROR: The system was unable to find the specified registry key or value.")) break block16;
                                    bl = false;
                                    if (HKLMReader == null) break block17;
                                }
                                catch (Throwable throwable2) {
                                    if (HKLMReader == null) throw throwable2;
                                    HKLMReader.close();
                                    throw throwable2;
                                }
                                HKLMReader.close();
                            }
                            if (HKCUreader == null) return bl;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (HKCUreader == null) throw throwable;
                            HKCUreader.close();
                            throw throwable;
                        }
                        HKCUreader.close();
                        return bl;
                    }
                    if (HKLMReader != null) {
                        HKLMReader.close();
                    }
                    if (HKCUreader == null) return true;
                    HKCUreader.close();
                    return true;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                        throw throwable;
                    }
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                    throw throwable;
                }
            }
            catch (IOException e) {
                LogUtils.log((Throwable)e);
            }
            return true;
        }
    }
}

