/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.extensions;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.ibm.debug.pdt.launch.internal.zpicl.preferences.LaunchzPICLPreferences;
import com.ibm.debug.pdt.profile.internal.LogUtils;
import com.ibm.debug.pdt.profile.internal.ProfilePlugin;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTCN;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTSP;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileNameUtils;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileRoot;
import com.ibm.debug.pdt.profile.internal.rest.client.DebugProfileRestClientV1;
import com.ibm.debug.pdt.profile.internal.rest.client.DebugProfileRestClientV1_DTCN_JSON;
import com.ibm.debug.pdt.profile.internal.rest.client.DebugProfileRestClientV1_DTSP_JSON;
import com.ibm.debug.pdt.profile.internal.rest.client.DebugProfileRestClientV1_JSON;
import com.ibm.debug.pdt.ui.profile.internal.extensions.DebugProfileRSEUtils;
import com.ibm.debug.pdt.ui.profile.internal.extensions.RSEEventListener;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

class DebugProfileSynchronizer
extends RSEEventListener {
    DebugProfileSynchronizer() {
        DebugProfileRSEUtils.getInstance().addRSEEventListener(this);
    }

    @Override
    public void handleEvent(Connection source, int eventType, String oldName) {
        switch (eventType) {
            case 3: {
                this.handleLogin(source);
                break;
            }
        }
    }

    private void handleLogin(final Connection connection) {
        if (connection.getErrorState() == Connection.ERROR_STATE.NONE && LaunchzPICLPreferences.getisSynchronizeProfiles()) {
            Job j = new Job("Synchronizing debug profiles"){

                protected IStatus run(IProgressMonitor monitor) {
                    ProfilePlugin.getTrace().trace("/profileEvents", "\nStart synchronizing for " + connection.getConnectionName());
                    DebugProfileSynchronizer.this.syncDTCNRegions(connection.getRegionNames(), connection);
                    DebugProfileSynchronizer.this.syncDTSPProfile(connection);
                    connection.setSynchronized();
                    ProfilePlugin.getTrace().trace("/profileEvents", "\nEnd synchronizing for " + connection.getConnectionName());
                    return Status.OK_STATUS;
                }
            };
            j.setSystem(true);
            j.schedule();
        } else {
            connection.setSynchronized();
        }
    }

    private void syncDTSPProfile(Connection connection) {
        try {
            if (connection.getErrorState() != Connection.ERROR_STATE.NONE) {
                return;
            }
            HttpRequestBase request = DebugProfileRestClientV1.buildRequest_GetRemoteDTSPProfile((String)connection.getUserId(), (Connection)connection);
            HttpResponse response = DebugProfileRestClientV1.executeRequest((HttpRequestBase)request, (Connection)connection);
            if (response == null) {
                return;
            }
            String responseMessage = DebugProfileRestClientV1.getReadableResponseString((HttpResponse)response);
            ProfilePlugin.getTrace().trace("/profileEvents", NLS.bind((String)"\nDTSP Sync-> connection:{0} user:{1} rc:{2} message:{3}", (Object[])new String[]{connection.getConnectionName(), connection.getUserId(), Integer.toString(response.getStatusLine().getStatusCode()), responseMessage}));
            if (response.getStatusLine().getStatusCode() == 200) {
                JsonElement profile;
                Gson gson = new Gson();
                String body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                JsonElement jsonBody = JsonParser.parseString((String)body);
                NonCICSSyncProfileReply jsonbody = (NonCICSSyncProfileReply)gson.fromJson(body, NonCICSSyncProfileReply.class);
                connection.setAPIVersion(jsonbody.apiversion);
                if (jsonBody.isJsonObject() && ((profile = jsonBody.getAsJsonObject().get("profile")) == null || profile.toString().equals("{}"))) {
                    ProfilePlugin.getTrace().trace("/profileEvents", "\nIgnoring sync of DTSP because profile was empty:\n" + body);
                    return;
                }
                if (jsonbody.dlaydbg) {
                    DebugProfileDTSP newProfile = DebugProfileRestClientV1_DTSP_JSON.getProfile((DebugProfileRestClientV1_DTSP_JSON)jsonbody.profile, (Connection)connection);
                    this.syncProfile((DebugProfile)newProfile, (DebugProfileRestClientV1_JSON)jsonbody.profile);
                } else {
                    ProfilePlugin.getTrace().trace("/profileEvents", "\nIgnoring sync of DTSP profile that is not dlaydbg:\n" + body);
                }
            } else if (response.getStatusLine().getStatusCode() == 404) {
                Gson gson = new Gson();
                String body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                NonCICSSyncProfileReply jsonbody = (NonCICSSyncProfileReply)gson.fromJson(body, NonCICSSyncProfileReply.class);
                connection.setAPIVersion(jsonbody.apiversion);
            }
        }
        catch (Exception e) {
            LogUtils.log((Throwable)e);
        }
    }

    private void syncProfile(DebugProfile newProfile, DebugProfileRestClientV1_JSON jsonProfileObject) throws Exception {
        DebugProfile profile = DebugProfileRoot.getInstance().getProfileByUUID(newProfile.getUUID());
        boolean push = true;
        if (profile == null) {
            profile.setName(DebugProfileNameUtils.generateNewName((String)((profile = newProfile) instanceof DebugProfileDTCN ? "CICS-PROFILE-" : "PROFILE-")));
            DebugProfileRoot.getInstance().addDebugProfile(profile);
            push = false;
        }
        DebugProfileRestClientV1_JSON.synchronize((boolean)push, (DebugProfile)profile, (DebugProfileRestClientV1_JSON)jsonProfileObject);
    }

    private void syncDTCNRegions(String[] regionNames, Connection connection) {
        if (regionNames != null) {
            String[] stringArray = regionNames;
            int n = regionNames.length;
            int n2 = 0;
            while (n2 < n) {
                String region = stringArray[n2];
                this.syncDTCNProfile(region, connection);
                ++n2;
            }
        }
    }

    private void syncDTCNProfile(String region, Connection connection) {
        try {
            if (connection.getErrorState() != Connection.ERROR_STATE.NONE && connection.getErrorState() != Connection.ERROR_STATE.CICS_ONLY) {
                ProfilePlugin.getTrace().trace("/profileEvents", NLS.bind((String)"Skipping profile synchronization due to previous error.  Region: {0}", (Object)region));
                return;
            }
            HttpRequestBase request = DebugProfileRestClientV1.buildRequest_QueryRemoteDTCNProfileForUser((String)region, (String)connection.getUserId(), (Connection)connection);
            HttpResponse response = DebugProfileRestClientV1.executeRequest((HttpRequestBase)request, (Connection)connection);
            String responseMessage = DebugProfileRestClientV1.getReadableResponseString((HttpResponse)response);
            ProfilePlugin.getTrace().trace("/profileEvents", NLS.bind((String)"\nDTCN Sync-> connection:{0} region:{1} rc:{2} message:{3}", (Object[])new String[]{connection.getConnectionName(), region, Integer.toString(response.getStatusLine().getStatusCode()), responseMessage}));
            if (response.getStatusLine().getStatusCode() == 200) {
                Gson gson = new Gson();
                String body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                CICSSyncProfileReply jsonbody = (CICSSyncProfileReply)gson.fromJson(body, CICSSyncProfileReply.class);
                if (jsonbody.profilerecord != null && jsonbody.profilerecord.length > 0) {
                    DebugProfileDTCN newProfile = DebugProfileRestClientV1_DTCN_JSON.getProfile((DebugProfileRestClientV1_DTCN_JSON)jsonbody.profilerecord[0], (String)region, (Connection)connection);
                    this.syncProfile((DebugProfile)newProfile, (DebugProfileRestClientV1_JSON)jsonbody.profilerecord[0]);
                    if (jsonbody.profilerecord.length > 1) {
                        ProfilePlugin.getTrace().trace("/profileEvents", NLS.bind((String)"\nMore than 1 DTCN profile found in region. Ignoring {0} profiles.Complete results:\n{1}", (Object[])new String[]{Integer.toString(jsonbody.profilerecord.length - 1), body}));
                    }
                } else {
                    ProfilePlugin.getTrace().trace("/profileEvents", "\nNo DTCN profiles to sync.");
                }
            } else if (response.getStatusLine().getStatusCode() != 404) {
                if (connection.getAuthInvalidCicsRegionErrorMessage(region.toLowerCase()).contains("EQAPS4060E")) {
                    connection.setErrorState(Connection.ERROR_STATE.AUTHENTICATION_NOT_VALID);
                }
                ProfilePlugin.getTrace().trace("/profileEvents", NLS.bind((String)"Debug profile synchronization error.  Region: {0}\tREST status code:{1}\nResponse: {2}", (Object[])new String[]{region, Integer.toString(response.getStatusLine().getStatusCode()), DebugProfileRestClientV1.getReadableResponseString((HttpResponse)response)}));
            }
        }
        catch (Exception e) {
            LogUtils.log((Throwable)e);
        }
    }

    static class CICSSyncProfileReply {
        String cicsregionname;
        String cicstslevel;
        String clientversion;
        String message;
        DebugProfileRestClientV1_DTCN_JSON[] profilerecord;

        CICSSyncProfileReply() {
        }
    }

    static class NonCICSSyncProfileReply {
        String datasetname;
        String apiversion;
        boolean dlaydbg;
        DebugProfileRestClientV1_DTSP_JSON profile;

        NonCICSSyncProfileReply() {
        }
    }
}

