/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.editor;

import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.profile.internal.rest.APIServerException;
import com.ibm.debug.pdt.ui.profile.internal.Activator;
import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import com.ibm.debug.pdt.ui.profile.internal.editor.IRegionHandler;
import com.ibm.debug.pdt.ui.profile.internal.editor.MessageManagerHelper;
import com.ibm.debug.pdt.ui.profile.internal.editor.Validator;
import com.ibm.etools.zos.system.ZOSSystemType;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.ui.actions.SystemNewConnectionAction;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class FormToolkitHelper
implements IDebugProfileConstants {
    protected static final String DESCRIPTION_KEY = "DESCRIPTION";
    private FormToolkit fToolkit;
    private DefaultToolTip fLastTooltip = null;
    private Control fErrorControl = null;

    public FormToolkitHelper(FormToolkit toolkit) {
        this.fToolkit = toolkit;
    }

    protected Label createLabel(Composite composite, String text, int colspan) {
        Label label = this.fToolkit.createLabel(composite, text, 16384);
        GridData data = this.getStyleGridData(false, true, 4, 0x1000000);
        data.horizontalSpan = colspan;
        label.setLayoutData((Object)data);
        return label;
    }

    public Label createLabel(Composite composite, String text) {
        Label label = this.fToolkit.createLabel(composite, text, 16384);
        GridData data = this.getStyleGridData(false, true, 4, 0x1000000);
        label.setLayoutData((Object)data);
        return label;
    }

    protected Label createLabel(Composite composite, String text, boolean enabled) {
        return this.createLabel(composite, text, true, true);
    }

    public Label createLabel(Composite composite, String text, boolean enabled, boolean grab) {
        Label label = this.fToolkit.createLabel(composite, text, 16384);
        GridData data = this.getStyleGridData(false, grab, 4, 0x1000000);
        label.setLayoutData((Object)data);
        label.setEnabled(enabled);
        return label;
    }

    public CCombo createCombo(Composite composite, String tooltip) {
        CCombo combo = new CCombo(composite, 2048);
        GridData data = this.getStyleGridData(true, false, 4, 0x1000000);
        data.horizontalIndent = 4;
        this.setTooltip((Control)combo, tooltip);
        combo.setLayoutData((Object)data);
        combo.setEditable(false);
        return combo;
    }

    protected CCombo createCombo(Composite composite, String tooltip, int colspan) {
        CCombo combo = new CCombo(composite, 2048);
        GridData data = this.getStyleGridData(true, false, 4, 4);
        data.horizontalSpan = colspan;
        data.horizontalIndent = 4;
        this.setTooltip((Control)combo, tooltip);
        combo.setLayoutData((Object)data);
        return combo;
    }

    protected Group createGroup(Composite composite, String text, int gridLayoutData) {
        Group group = new Group(composite, 20);
        GridData data = new GridData(gridLayoutData);
        group.setText(text);
        group.setLayoutData((Object)data);
        return group;
    }

    protected Group createGroup(Composite composite, String text) {
        Group group = new Group(composite, 4);
        GridData data = new GridData(256);
        group.setLayoutData((Object)data);
        return group;
    }

    protected Group createGroup(Composite composite, String text, int gridLayoutData, int colspan) {
        Group group = new Group(composite, 20);
        GridData data = new GridData(gridLayoutData);
        data.horizontalSpan = colspan;
        group.setText(text);
        group.setLayoutData((Object)data);
        return group;
    }

    public Text createText(Composite composite, String tooltip) {
        Text text = this.fToolkit.createText(composite, "", 2052);
        GridData data = this.getStyleGridData(true, false, 4, 4);
        data.horizontalIndent = 4;
        this.setTooltip((Control)text, tooltip);
        text.setLayoutData((Object)data);
        return text;
    }

    public void setTooltip(Control c, String tooltip) {
        if (tooltip != null && !tooltip.trim().isEmpty()) {
            if (c.getData("tooltip_obj") != null) {
                this.updateTooltip(c, tooltip);
            } else {
                DefaultToolTip t = this.createTooltip(c, 1, false, this.fToolkit);
                t.setHideOnMouseDown(false);
                t.setText(NLS.bind((String)tooltip, (Object)"\u2022"));
                c.setData("tooltip", (Object)tooltip);
                c.setData("tooltip_obj", (Object)t);
            }
        }
    }

    public void updateTooltip(Control c, String tooltip) {
        if (tooltip != null && !tooltip.trim().isEmpty()) {
            if (c.getData("tooltip_obj") == null) {
                this.setTooltip(c, tooltip);
            } else {
                c.setData("tooltip", (Object)tooltip);
                DefaultToolTip t = (DefaultToolTip)c.getData("tooltip_obj");
                t.setText(tooltip);
            }
        }
    }

    protected void hideTooltip() {
        if (this.fLastTooltip != null) {
            this.fLastTooltip.hide();
        }
        if (this.fErrorControl != null) {
            this.hideErrorTooltip();
        }
    }

    private DefaultToolTip createTooltip(Control c, int style, boolean manual, FormToolkit toolkit) {
        DefaultToolTip result = new DefaultToolTip(c, style, manual){

            public void show(Point location) {
                FormToolkitHelper.this.hideTooltip();
                super.show(location);
                FormToolkitHelper.this.fLastTooltip = this;
            }

            protected void afterHideToolTip(Event event) {
                super.afterHideToolTip(event);
                FormToolkitHelper.this.fLastTooltip = null;
            }
        };
        return result;
    }

    protected void showTooltip(final Control c) {
        TableViewer viewer;
        Object tooltipText = c.getData("tooltip");
        Object t = null;
        Point point = null;
        if (tooltipText instanceof String && !((String)tooltipText).isEmpty()) {
            t = this.createTooltip(c, 1, true, this.fToolkit);
            t.setText(((String)tooltipText).replace("''", "'"));
            point = new Point(15, 5);
        } else if (c instanceof Table && (viewer = (TableViewer)((Table)c).getData("VIEWER_DATA")) != null) {
            t = new OnDemandColumnViewerTooltipSupport((ColumnViewer)viewer, this);
            point = new Point(15, viewer.getTable().getHeaderHeight() + 5);
        }
        if (t != null) {
            final DefaultToolTip tooltip = t;
            c.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent arg0) {
                    tooltip.hide();
                    c.removeFocusListener((FocusListener)this);
                }

                public void focusGained(FocusEvent arg0) {
                }
            });
            t.show(point);
        }
    }

    protected Text createText(Composite composite, String tooltip, int colspan) {
        return this.createText(composite, tooltip, colspan, 2052, "");
    }

    public Text createText(Composite composite, String tooltip, int colspan, int style, String content) {
        int borderStyle = this.fToolkit.getBorderStyle();
        if (borderStyle != 0) {
            this.fToolkit.setBorderStyle(0);
        }
        Text text = this.fToolkit.createText(composite, content, style);
        if (borderStyle != 0) {
            this.fToolkit.setBorderStyle(borderStyle);
        }
        GridData data = this.getStyleGridData(true, false, 4, 4);
        data.horizontalSpan = colspan;
        data.horizontalIndent = 4;
        this.setTooltip((Control)text, tooltip);
        text.setLayoutData((Object)data);
        return text;
    }

    protected Button createCheckBox(Composite composite, String text, String tooltip, int colspan) {
        GridData data = this.getStyleGridData(true, false, 4, 4);
        data.horizontalSpan = colspan;
        data.horizontalIndent = 4;
        Button btn = this.fToolkit.createButton(composite, text, 32);
        btn.setLayoutData((Object)data);
        this.setTooltip((Control)btn, tooltip);
        return btn;
    }

    protected void initializeCombo(CCombo combo, String[] values, String initialValue, String tooltip) {
        if (values != null && values.length > 0) {
            int initialValueIndex = 0;
            int i = 0;
            while (i < values.length) {
                combo.add(values[i]);
                if (values[i].equalsIgnoreCase(initialValue)) {
                    initialValueIndex = i;
                }
                ++i;
            }
            if (combo.indexOf(initialValue) == -1) {
                combo.add(initialValue, initialValueIndex);
            }
            combo.select(initialValueIndex);
        } else if (initialValue != null && !initialValue.isEmpty()) {
            combo.add(initialValue);
            combo.setText(initialValue);
        }
        if (combo.getItemCount() == 1) {
            combo.select(0);
        }
        this.setTooltip((Control)combo, tooltip);
    }

    protected CCombo createCombo(Composite composite, int style, String[] values, String initialValue, String tooltip, int colspan) {
        GridData data = this.getStyleGridData(true, false, 4, 4);
        data.horizontalSpan = colspan;
        data.horizontalIndent = 4;
        CCombo combo = new CCombo(composite, style);
        this.fToolkit.adapt((Control)combo, true, true);
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                combo.add(values[i]);
                ++i;
            }
        } else if (initialValue != null && !initialValue.isEmpty()) {
            combo.add(initialValue);
        }
        if (initialValue != null && !initialValue.isEmpty()) {
            combo.setText(initialValue);
        } else if (combo.getItemCount() == 1) {
            combo.select(0);
        }
        this.setTooltip((Control)combo, tooltip);
        combo.setLayoutData((Object)data);
        return combo;
    }

    protected Link createLink(Composite composite, String text, String tooltip, int colspan, int style) {
        GridData data = new GridData(style);
        data.horizontalSpan = colspan;
        Link link = new Link(composite, 0);
        link.setText(text);
        link.setLayoutData((Object)data);
        this.setTooltip((Control)link, tooltip);
        return link;
    }

    public Button createButton(Composite composite, String text, String tooltip) {
        GridData data = this.getStyleGridData(false, true, 4, 4);
        data.widthHint = 200;
        Button btn = this.fToolkit.createButton(composite, text, 8);
        btn.setLayoutData((Object)data);
        this.setTooltip((Control)btn, tooltip);
        return btn;
    }

    protected Image getImage(int type) {
        switch (type) {
            case 3: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }
            case 2: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            }
            case 1: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
            }
        }
        return null;
    }

    protected Section createSection(Composite composite, int style, int colspan) {
        Section section = this.fToolkit.createSection(composite, style);
        GridData data = this.getGridData(colspan);
        section.setLayoutData((Object)data);
        return section;
    }

    public Section createSection(Composite composite, int style) {
        Section section = this.fToolkit.createSection(composite, style);
        return section;
    }

    protected GridLayout getGridLayout(int columns) {
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        return layout;
    }

    protected GridData getStyleGridData(boolean h, boolean v, int hAlign, int vAlign) {
        GridData data = GridDataFactory.fillDefaults().grab(h, v).align(hAlign, vAlign).create();
        return data;
    }

    protected GridData getGridData() {
        GridData data = GridDataFactory.fillDefaults().grab(true, false).align(4, 4).create();
        return data;
    }

    protected GridData getGridData(int colspan) {
        GridData data = GridDataFactory.fillDefaults().grab(true, false).align(4, 4).create();
        data.horizontalSpan = colspan;
        return data;
    }

    protected void showErrorTooltip(Control c) {
        this.hideTooltip();
        if (c instanceof Table) {
            c = c.getParent().getParent();
        }
        if (c.getParent() != null) {
            Listener[] test;
            this.fErrorControl = c;
            Listener[] listenerArray = test = c.getParent().getListeners(32);
            int n = test.length;
            int n2 = 0;
            while (n2 < n) {
                Listener l = listenerArray[n2];
                Event e = new Event();
                e.widget = c.getParent();
                e.type = 32;
                e.display = c.getDisplay();
                e.x = c.getBounds().x - 1;
                e.y = c.getBounds().y + c.getBounds().height - 1;
                l.handleEvent(e);
                ++n2;
            }
        }
    }

    protected void hideErrorTooltip() {
        if (this.fErrorControl != null) {
            Listener[] test;
            Listener[] listenerArray = test = this.fErrorControl.getParent().getListeners(7);
            int n = test.length;
            int n2 = 0;
            while (n2 < n) {
                Listener l = listenerArray[n2];
                Event e = new Event();
                e.widget = this.fErrorControl.getParent();
                e.type = 7;
                e.display = this.fErrorControl.getDisplay();
                e.x = this.fErrorControl.getBounds().x - 1;
                e.y = this.fErrorControl.getBounds().y + this.fErrorControl.getBounds().height - 1;
                l.handleEvent(e);
                ++n2;
            }
        }
    }

    public Composite createComposite(Composite parent, int style) {
        return this.fToolkit.createComposite(parent, style);
    }

    public void createSectionDescription(Section section, Composite parent, int colSpan) {
        Text text = new Text(parent, 66);
        FormColors colors = this.fToolkit.getColors();
        text.setForeground(section.getDisplay().getSystemColor(10));
        text.setBackground(colors.getBackground());
        Point size = text.computeSize(-1, -1);
        GridDataFactory.fillDefaults().grab(true, false).span(colSpan, 1).hint(size.x, -1).applyTo((Control)text);
        section.setData(DESCRIPTION_KEY, (Object)text);
    }

    public Section createProfileSection(Composite parent) {
        Section result = this.createSection(parent, 6144);
        if (parent.getLayout() instanceof TableWrapLayout) {
            TableWrapData td = new TableWrapData(256);
            result.setLayoutData((Object)td);
        }
        return result;
    }

    public Composite createProfileComposite(Section profileSection) {
        Composite result = this.fToolkit.createComposite((Composite)profileSection);
        result.setLayout((Layout)this.getGridLayout(3));
        result.setLayoutData((Object)this.getGridData());
        return result;
    }

    public CCombo createConnectionCombo(Composite client, SelectionListener listener) {
        return this.createConnectionCombo(client, listener, true);
    }

    public CCombo createConnectionCombo(Composite client, SelectionListener listener, boolean grab) {
        Label connComboLabel = this.createLabel(client, ProfileLabels.editor_connection, true, grab);
        CCombo result = this.createCombo(client, ProfileLabels.editor_connection_tooltip);
        result.setEditable(false);
        result.addSelectionListener(listener);
        result.setData("outlineWidget", (Object)connComboLabel);
        return result;
    }

    public Button createConnectionButton(Composite client, SelectionListener listener) {
        Button result = this.createButton(client, ProfileLabels.editor_profile_info_new_button, ProfileLabels.editor_profile_info_new_button_tooltip);
        result.addSelectionListener(listener);
        GridDataFactory.swtDefaults().applyTo((Control)result);
        return result;
    }

    public CCombo createRegionCombo(Composite client, int colspan, FocusListener focusListener) {
        CCombo result = this.createCombo(client, ProfileLabels.editor_cics_region_tooltip, colspan);
        result.setEditable(false);
        if (focusListener != null) {
            result.addFocusListener(focusListener);
        }
        return result;
    }

    public void setRegionComboException(APIServerException exception, final MessageManagerHelper messageHelper, final CCombo regionCombo) {
        if (exception != null) {
            String eol = System.getProperty("line.separator");
            final String message = NLS.bind((String)ProfileMessages.CRRDG9116, (Object)(eol + "\t" + exception.getTarget() + eol), (Object)(eol + "\t" + exception.getResult()));
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    messageHelper.displayErrorMessage(message, (Control)regionCombo);
                }
            });
        }
    }

    public void getConnectionUpdateRegion(final boolean needUpdate, final String connectionName, final boolean autoLogon, final ScrolledForm form, final IRegionHandler regionHandler, boolean waitForJob) {
        Job job = new Job(ProfileLabels.editor_get_RSE_connection){

            protected IStatus run(IProgressMonitor monitor) {
                Connection c;
                block7: {
                    c = null;
                    try {
                        try {
                            c = ConnectionUtilities.getConnection((String)connectionName, (boolean)false);
                            if (c != null && c.getErrorState() == Connection.ERROR_STATE.NOT_CONNECTED && autoLogon) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!form.isDisposed()) {
                                            form.setBusy(true);
                                            form.getBody().setEnabled(false);
                                        }
                                    }
                                });
                                c = ConnectionUtilities.getConnection((String)connectionName, (boolean)true);
                            }
                        }
                        catch (Exception e) {
                            Activator.log(e);
                            Display.getDefault().asyncExec(new Runnable(form){
                                private final /* synthetic */ ScrolledForm val$form;
                                {
                                    this.val$form = scrolledForm;
                                }

                                @Override
                                public void run() {
                                    if (!this.val$form.isDisposed()) {
                                        this.val$form.setBusy(false);
                                        this.val$form.getBody().setEnabled(true);
                                    }
                                }
                            });
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                    Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                }
                if (needUpdate && c != null) {
                    String[] regions = c.getRegionNames();
                    regionHandler.updateRegionLocation(c, regions);
                    regionHandler.setRegionComboException(c.getCICSException());
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family.equals(connectionName);
            }
        };
        if (waitForJob) {
            try {
                Job.getJobManager().join((Object)connectionName, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        job.setSystem(true);
        job.schedule();
    }

    public void getRegionList(Connection c, String profileRegion, String[] regions, CCombo regionCombo) {
        regionCombo.removeAll();
        String[] stringArray = regions;
        int n = regions.length;
        int n2 = 0;
        while (n2 < n) {
            String region = stringArray[n2];
            regionCombo.add(region);
            ++n2;
        }
        regionCombo.setText(profileRegion == null ? "" : profileRegion);
        regionCombo.setEditable(false);
    }

    public void determineConnectionError(Connection c, CCombo connectionCombo, Validator validator) {
        if (c.getErrorState() == Connection.ERROR_STATE.NOT_CONNECTED) {
            validator.updateMessage(connectionCombo, NLS.bind((String)ProfileMessages.CRRDG9111, (Object)c.getConnectionName()), "info");
        } else if (c.getErrorMessage() != null) {
            validator.updateMessage(connectionCombo, c.getErrorMessage(), "error");
        } else {
            validator.updateMessage(connectionCombo, ProfileMessages.CRRDG9112, "error");
        }
    }

    public String addNewConnection(Shell shell) {
        IHost[] beforeHosts = SystemStartHere.getConnections();
        SystemNewConnectionAction action = new SystemNewConnectionAction(shell, true, null);
        action.restrictSystemTypes(new IRSESystemType[]{new ZOSSystemType()});
        action.run();
        IHost[] afterHosts = SystemStartHere.getConnections();
        if (beforeHosts.length < afterHosts.length) {
            return afterHosts[afterHosts.length - 1].getAliasName();
        }
        return null;
    }

    public Section createFilterSection(Composite parent, String title, boolean addDescription) {
        Section result = this.createSection(parent, 258);
        if (parent.getLayout() instanceof TableLayout) {
            TableWrapData td = new TableWrapData(256);
            result.setLayoutData((Object)td);
        }
        result.setText(title);
        result.setData("outlineWidget", (Object)result);
        int colspan = 2;
        Composite client = this.fToolkit.createComposite((Composite)result);
        client.setLayout((Layout)this.getGridLayout(colspan));
        client.setLayoutData((Object)this.getGridData());
        result.setClient((Control)client);
        if (addDescription) {
            this.createSectionDescription(result, client, colspan);
        }
        return result;
    }

    public Text createTransactionText(Composite parent) {
        Label cicsTransLabel = this.createLabel(parent, ProfileLabels.editor_cics_transaction);
        Text result = this.createText(parent, ProfileLabels.editor_cics_transaction_tooltip);
        result.setTextLimit(4);
        result.setData("outlineWidget", (Object)cicsTransLabel);
        return result;
    }

    public Text createCICSUserIDText(Composite parent) {
        Label cicsUserIdLabel = this.createLabel(parent, ProfileLabels.editor_cics_user_id);
        Text result = this.createText(parent, ProfileLabels.editor_cics_user_id_tooltip);
        result.setTextLimit(8);
        result.setText("&USERID");
        result.setData("outlineWidget", (Object)cicsUserIdLabel);
        return result;
    }

    public Text createCICSSYSIDText(Composite parent) {
        Label cicsSysIdLabel = this.createLabel(parent, ProfileLabels.editor_cics_sysid);
        Text result = this.createText(parent, ProfileLabels.editor_cics_sysid_tooltip);
        result.setTextLimit(4);
        result.setData("outlineWidget", (Object)cicsSysIdLabel);
        return result;
    }

    public Section createAddtionalCICSFiltersSection(Composite parent, boolean addDescription) {
        int colspan = 2;
        Section result = this.createSection(parent, 258, colspan);
        result.setLayoutData((Object)this.getGridData(colspan));
        result.setText(ProfileLabels.editor_cics_additional_filters);
        result.setData("outlineWidget", (Object)result);
        Composite client = this.fToolkit.createComposite((Composite)result);
        client.setLayout((Layout)this.getGridLayout(colspan));
        client.setLayoutData((Object)this.getGridData(colspan));
        if (addDescription) {
            this.createSectionDescription(result, client, colspan);
        }
        result.setClient((Control)client);
        return result;
    }

    public Text createNetNameText(Composite parent) {
        Label cicsNetNameLabel = this.createLabel(parent, ProfileLabels.editor_cics_netname);
        Text result = this.createText(parent, ProfileLabels.editor_cics_netname_tooltip);
        result.setData("outlineWidget", (Object)cicsNetNameLabel);
        return result;
    }

    public Text createCICSIPText(Composite parent) {
        Label cicsIpLabel = this.createLabel(parent, ProfileLabels.editor_cics_ip);
        Text result = this.createText(parent, ProfileLabels.editor_cics_ip_tooltip);
        result.setData("outlineWidget", (Object)cicsIpLabel);
        return result;
    }

    public Text createTerminalIDText(Composite parent) {
        Label cicsTermIdLabel = this.createLabel(parent, ProfileLabels.editor_cics_terminal_id);
        Text result = this.createText(parent, ProfileLabels.editor_cics_terminal_id_tooltip);
        result.setTextLimit(4);
        result.setData("outlineWidget", (Object)cicsTermIdLabel);
        return result;
    }

    private static class OnDemandColumnViewerTooltipSupport
    extends ColumnViewerToolTipSupport {
        private FormToolkitHelper fParent;

        OnDemandColumnViewerTooltipSupport(ColumnViewer viewer, FormToolkitHelper parent) {
            super(viewer, 1, true);
            this.fParent = parent;
        }

        public void show(Point location) {
            this.fParent.hideTooltip();
            super.show(location);
            this.fParent.fLastTooltip = this;
        }

        protected void afterHideToolTip(Event event) {
            super.afterHideToolTip(event);
            this.fParent.fLastTooltip = null;
        }
    }
}

