/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.editor;

import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTCN;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTSP;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.profile.internal.model.ProfileLevels;
import com.ibm.debug.pdt.ui.profile.internal.Activator;
import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import com.ibm.debug.pdt.ui.profile.internal.editor.FormToolkitHelper;
import com.ibm.debug.pdt.ui.profile.internal.editor.IDebugProfileEditorConstants;
import com.ibm.debug.pdt.ui.profile.internal.editor.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class DebugProfileEditorHelper
implements IDebugProfileEditorConstants,
IDebugProfileConstants {
    private DebugProfile fDebugProfile;
    private IDebugProfileEditorConstants.PROFILE_TYPE fType;
    private FormToolkitHelper fToolkitHelper;
    private Validator fValidator;

    public DebugProfileEditorHelper(DebugProfile profile, IDebugProfileEditorConstants.PROFILE_TYPE type, FormToolkitHelper toolkitHelper, Validator validator) {
        this.fDebugProfile = profile;
        this.fType = type;
        this.fToolkitHelper = toolkitHelper;
        this.fValidator = validator;
    }

    protected void selectAdvanceConnect(Button fConnectWithClientInfoButton, Text fConnectIPText, Text fConnectPortText, Text fConnectUserIDText) {
        if (fConnectWithClientInfoButton.getSelection()) {
            fConnectIPText.setEnabled(true);
            fConnectPortText.setEnabled(true);
            fConnectUserIDText.setEnabled(true);
        } else {
            fConnectIPText.setEnabled(false);
            fConnectPortText.setEnabled(false);
            fConnectUserIDText.setEnabled(false);
        }
    }

    protected void updateAdvancedConnectionFieldsEnablement(String connectionName, Button connectWithClientInfoBtn, Button certBrowseBtn, Text connectUserIDText, Text connectIPText, Text connectPortText, Text certText, Label connectUserIDLabel, Label connectIPLabel, Label connectPortLabel, Label certLabel) {
        boolean userIDEnabled = connectWithClientInfoBtn.getSelection() && connectPortText.getText().trim().isEmpty() && connectIPText.getText().trim().isEmpty() && certText.getText().isEmpty();
        connectUserIDText.setEnabled(userIDEnabled);
        connectUserIDLabel.setEnabled(userIDEnabled);
        boolean ipPortEnabled = connectWithClientInfoBtn.getSelection() && (connectUserIDText.getText().trim().isEmpty() || !connectUserIDText.isEnabled());
        connectIPText.setEnabled(ipPortEnabled);
        connectIPLabel.setEnabled(ipPortEnabled);
        connectPortText.setEnabled(ipPortEnabled);
        connectPortLabel.setEnabled(ipPortEnabled);
        Connection connection = ConnectionUtilities.getConnection((String)connectionName, (boolean)false);
        boolean certificateEnabled = connection != null && connection.isConnected() && connection.isAuthCertSupported() && (connectWithClientInfoBtn.getSelection() && connectUserIDText.getText().isEmpty() || !connection.isUsingDBM());
        certText.setEnabled(certificateEnabled);
        certLabel.setEnabled(certificateEnabled);
        certBrowseBtn.setEnabled(certificateEnabled);
    }

    public static Connection initConnection(CCombo fConnectionCombo, String defaultConnection) {
        Connection c = null;
        fConnectionCombo.removeAll();
        for (Connection connection : ConnectionUtilities.getConnections()) {
            fConnectionCombo.add(connection.getConnectionName());
            if (defaultConnection == null || !connection.getConnectionName().equalsIgnoreCase(defaultConnection)) continue;
            fConnectionCombo.setText(connection.getConnectionName());
            c = connection;
        }
        if (c == null && fConnectionCombo.getItemCount() > 0) {
            fConnectionCombo.select(0);
            c = ConnectionUtilities.getConnection((String)fConnectionCombo.getText(), (boolean)false);
        }
        return c;
    }

    protected void showHideDescription(ScrolledForm form, Link fHideHintLink, Section profileSection, Section filterSection, Section additionalFilterSection, Section advancedFilterSection, Section debugOptionSection, Section addSubsysfilterSection, Section advConnOptionSection, Section imsIsolationSection, Section imsSteplibSection) {
        Point oldSize = form.getContent().computeSize(-1, -1, true);
        boolean showHint = this.getDialogSettings().getBoolean("SHOW_HINTS");
        if (this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_CICS) {
            this.showHint(profileSection, showHint, ProfileLabels.editor_profile_info_description_CICS);
            this.showHint(filterSection, showHint, ProfileLabels.editor_settings_description);
            this.showHint(additionalFilterSection, showHint, ProfileLabels.editor_additional_filter_description);
            this.showHint(advancedFilterSection, showHint, ProfileLabels.editor_advanced_criteria_description);
        } else {
            this.showHint(filterSection, showHint, ProfileLabels.editor_non_cics_settings_description);
            if (this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_NON_CICS) {
                this.showHint(profileSection, showHint, ProfileLabels.editor_profile_info_description_nonCICS);
                this.showHint(addSubsysfilterSection, showHint, ProfileLabels.editor_non_cics_additional_filter_description);
            } else {
                this.showHint(profileSection, showHint, ProfileLabels.editor_profile_info_description_IMS);
                this.showHint(imsIsolationSection, showHint, ProfileLabels.ims_isolation_description);
                this.showHint(imsSteplibSection, showHint, ProfileLabels.ims_isolation_steplib_description);
            }
        }
        this.showHint(debugOptionSection, showHint, ProfileLabels.editor_debugger_options_description);
        this.showHint(advConnOptionSection, showHint, ProfileLabels.editor_advanced_connection_options_description);
        if (showHint) {
            fHideHintLink.setText("<a>" + ProfileLabels.editor_profile_info_hint_link_hide + "</a>");
        } else {
            fHideHintLink.setText("<a>" + ProfileLabels.editor_profile_info_hint_link_show + "</a>");
        }
        Point newSize = form.getContent().computeSize(oldSize.x, -1, true);
        form.getContent().setSize(oldSize.x, newSize.y);
        fHideHintLink.getParent().layout();
        form.reflow(true);
    }

    private void showHint(Section section, boolean showHint, String hint) {
        Text description = (Text)section.getData("DESCRIPTION");
        if (description != null) {
            description.setEditable(true);
            description.setText(showHint ? hint : "");
            description.setEditable(false);
            description.setVisible(showHint);
            description.setEnabled(showHint);
            GridData data = (GridData)description.getLayoutData();
            data.heightHint = showHint ? -1 : 0;
            section.getParent().layout(true);
        }
    }

    protected void expandCollapseSection(Section section, String key) {
        this.expandCollapseSection(section, key, false);
    }

    protected void expandCollapseSection(Section section, String key, boolean override) {
        if (key != null || override) {
            boolean expand = override || this.getDialogSettings().getBoolean(key);
            section.setExpanded(expand);
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings result = Activator.getDefault().getDialogSettings().getSection("com.ibm.debug.pdt.idz.launches.common.profile.editor.DebugProfileEditor");
        if (result == null) {
            result = Activator.getDefault().getDialogSettings().addNewSection("com.ibm.debug.pdt.idz.launches.common.profile.editor.DebugProfileEditor");
        }
        return result;
    }

    protected void initAdvanceConnectionOptions(Section advConnOptionSection, String connectionName, Button connectWithClientInfoBtn, Button certBrowseBtn, Text connectUserIDText, Text connectIPText, Text connectPortText, Text certText, Label connectUserIDLabel, Label connectIPLabel, Label connectPortLabel, Label certLabel) {
        DebugProfile.AdvancedConnectionOptions advConnectionOptions;
        DebugProfile.AdvancedConnectionOptions advancedConnectionOptions = advConnectionOptions = this.fDebugProfile != null ? this.fDebugProfile.getAdvancedConnectionOptions() : null;
        if (advConnectionOptions != null) {
            String userID = advConnectionOptions.getUserID();
            String ip = advConnectionOptions.getIP();
            String port = advConnectionOptions.getPort();
            String cert = advConnectionOptions.getCertificate();
            connectIPText.setText(ip != null ? ip : "");
            connectPortText.setText(port != null ? port : "");
            connectUserIDText.setText(userID != null ? userID : "");
            certText.setText(cert != null ? cert : "");
            if (userID != null && !userID.isEmpty() || ip != null && !ip.isEmpty() || port != null && !port.isEmpty()) {
                connectWithClientInfoBtn.setSelection(true);
            }
        } else {
            connectWithClientInfoBtn.setSelection(false);
            connectIPLabel.setEnabled(false);
            connectIPText.setEnabled(false);
            connectPortLabel.setEnabled(false);
            connectPortText.setEnabled(false);
            connectUserIDLabel.setEnabled(false);
            connectUserIDText.setEnabled(false);
            certBrowseBtn.setEnabled(false);
            certLabel.setEnabled(false);
            certText.setEnabled(false);
        }
        this.updateAdvancedConnectionFieldsEnablement(connectionName, connectWithClientInfoBtn, certBrowseBtn, connectUserIDText, connectIPText, connectPortText, certText, connectUserIDLabel, connectIPLabel, connectPortLabel, certLabel);
    }

    private void setEnabledForGroup(Control ctrl, boolean enabled) {
        if (ctrl instanceof Composite) {
            Composite comp = (Composite)ctrl;
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                this.setEnabledForGroup(c, enabled);
                ++n2;
            }
        } else {
            ctrl.setEnabled(enabled);
        }
    }

    private void loopAllControlWithSection(Control ctrl, ModifyListener listener) {
        if (ctrl instanceof Composite) {
            Composite comp = (Composite)ctrl;
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                if (c instanceof Text) {
                    ((Text)c).addModifyListener(listener);
                } else if (c instanceof CCombo) {
                    ((CCombo)c).addModifyListener(listener);
                }
                this.loopAllControlWithSection(c, listener);
                ++n2;
            }
        }
    }

    protected void addModifyListenerForControls(Composite composite, ModifyListener listener) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Section) {
                this.loopAllControlWithSection(c, listener);
            }
            ++n2;
        }
    }

    protected void disableCOMMAREAGroup(Group groupCOMMAREA, Text fContainerNameText, Text fContainerOffsetText, Text fContainerDatasetText) {
        boolean enabled = fContainerNameText.getText().trim().isEmpty() && fContainerOffsetText.getText().trim().isEmpty() && fContainerDatasetText.getText().trim().isEmpty();
        this.setEnabledForGroup((Control)groupCOMMAREA, enabled);
    }

    protected void disableContainerGroup(Group groupContainer, Text fComAreaOffsetText, Text fComAreaDataText) {
        boolean enabled = fComAreaOffsetText.getText().trim().isEmpty() && fComAreaDataText.getText().trim().isEmpty();
        this.setEnabledForGroup((Control)groupContainer, enabled);
    }

    protected void getCICSPorts(CCombo fRegionCombo, CCombo fConnectionCombo, Label fRegionLabel, String port) {
        String[] ports = null;
        ports = this.retrieveList("CICS_PORTS");
        if (ports == null) {
            ports = new String[]{port};
        }
        fRegionCombo.removeAll();
        fRegionLabel.setText(ProfileLabels.editor_connect_port);
        this.fToolkitHelper.initializeCombo(fRegionCombo, ports, port, ProfileLabels.editor_cics_port_tooltip);
        fRegionCombo.setTextLimit(10);
        fRegionCombo.setEditable(true);
        this.fValidator.updateMessage(fConnectionCombo, ProfileMessages.CRRDG9119, "warn");
    }

    protected void initDebuggerOptions(Section debugOptionSection, CCombo fTestLevelCombo, CCombo fErrorLevelCombo, CCombo fPromptLevelCombo, Text fCommandDataSetText, Text fPreferenceDataSetText, Text fEnvOptionsText, Text fEqaOptsText) {
        DebugProfile.DebuggerOptions dbgOptions = this.fDebugProfile != null ? this.fDebugProfile.getDebuggerOptions() : null;
        this.fillInitValueCombo(fTestLevelCombo, ProfileLevels.getTestLevels());
        this.fillInitValueCombo(fErrorLevelCombo, ProfileLevels.getErrorLevels());
        this.fillInitValueCombo(fPromptLevelCombo, ProfileLevels.getPromptLevels());
        fTestLevelCombo.setText(dbgOptions != null ? this.getNonNullValue(dbgOptions.getTestLevel()) : TEST_LEVEL_DEFAULT);
        fErrorLevelCombo.setText(dbgOptions != null ? this.getNonNullValue(dbgOptions.getErrorLevel()) : (this.fType == IDebugProfileEditorConstants.PROFILE_TYPE.PROFILE_CICS ? ERROR_LEVEL_DEFAULT_CICS : ERROR_LEVEL_DEFAULT_NONCICS));
        fPromptLevelCombo.setText(dbgOptions != null ? this.getNonNullValue(dbgOptions.getPromptLevel()) : PROMPT_LEVEL_DEFAULT);
        fCommandDataSetText.setText(dbgOptions != null ? this.getNonNullValue(dbgOptions.getCommandDataSet()) : "");
        fPreferenceDataSetText.setText(dbgOptions != null ? this.getNonNullValue(dbgOptions.getPreferenceDataSet()) : "");
        fEnvOptionsText.setText(dbgOptions != null ? this.getNonNullValue(dbgOptions.getLanguageEnvironmentOptions()) : "");
        fEqaOptsText.setText(dbgOptions != null ? this.getNonNullValue(dbgOptions.getEqaOptsFile()) : "");
    }

    private String getNonNullValue(String value) {
        return value == null ? "" : value;
    }

    private void fillInitValueCombo(CCombo combo, String[] values) {
        int i = 0;
        while (i < values.length) {
            combo.add(values[i]);
            ++i;
        }
    }

    protected void initAddSysFilterNonCICS(Text fJobNameText, Text fStepNameText, Text fSubsystemIDText, Text fTransactionIDText) {
        DebugProfileDTSP.JobInfo jobInfo = null;
        DebugProfileDTSP.IMSOptions imsOptions = null;
        DebugProfileDTSP p = (DebugProfileDTSP)this.fDebugProfile;
        jobInfo = p.getJobInfo();
        imsOptions = p.getIMSOptions();
        fJobNameText.setText(jobInfo != null ? jobInfo.getJobName() : "");
        fStepNameText.setText(jobInfo != null ? jobInfo.getStepName() : "");
        fSubsystemIDText.setText(imsOptions != null ? imsOptions.getSubsystemID() : "");
        fTransactionIDText.setText(imsOptions != null ? imsOptions.getTransactionID() : "");
    }

    protected void initCICSFilters(Text fTransactionNameText, Text fUserIdText, Text fNetNameText, Text fIpText, Text fSYSIDText, Text fTermIDText, Text fContainerNameText, Text fContainerOffsetText, Text fContainerDatasetText, Text fComAreaOffsetText, Text fComAreaDataText, Text fPlatfromNameText, Text fAppNameText, Text fOperationNameText, Text fAppVersionText, Button fURMCheck) {
        String transaction = null;
        transaction = ((DebugProfileDTCN)this.fDebugProfile).getTransaction();
        fTransactionNameText.setText(transaction != null ? transaction : "");
        DebugProfileDTCN.AdditionalCICSFilters filters = null;
        filters = ((DebugProfileDTCN)this.fDebugProfile).getAdditionalCICSFilters();
        fUserIdText.setText(filters != null && filters.getUserID() != null ? filters.getUserID() : "");
        fNetNameText.setText(filters != null && filters.getNetName() != null ? filters.getNetName() : "");
        fIpText.setText(filters != null && filters.getIP() != null ? filters.getIP() : "");
        fSYSIDText.setText(filters != null && filters.getCICSSysID() != null ? filters.getCICSSysID() : "");
        fTermIDText.setText(filters != null && filters.getTerminalID() != null ? filters.getTerminalID() : "");
        DebugProfileDTCN.AdvancedProgramInterruptionCriteria criteria = null;
        DebugProfileDTCN.ContainerInfo containerInfo = null;
        DebugProfileDTCN.ApplicationInfo appInfo = null;
        DebugProfileDTCN.CommAreaInfo commAreaInfo = null;
        criteria = ((DebugProfileDTCN)this.fDebugProfile).getAdvancedProgramInterruptionCriteria();
        if (criteria != null) {
            containerInfo = criteria.getContainerInfo();
            appInfo = criteria.getApplicationInfo();
            commAreaInfo = criteria.getCommAreaInfo();
        }
        fContainerNameText.setText(containerInfo != null && containerInfo.getName() != null ? containerInfo.getName() : "");
        fContainerOffsetText.setText(containerInfo != null && containerInfo.getOffset() != null ? containerInfo.getOffset() : "");
        fContainerDatasetText.setText(containerInfo != null && containerInfo.getData() != null ? containerInfo.getData() : "");
        fComAreaOffsetText.setText(commAreaInfo != null && commAreaInfo.getOffset() != null ? commAreaInfo.getOffset() : "");
        fComAreaDataText.setText(commAreaInfo != null && commAreaInfo.getData() != null ? commAreaInfo.getData() : "");
        fPlatfromNameText.setText(appInfo != null && appInfo.getPlatformName() != null ? appInfo.getPlatformName() : "");
        fAppNameText.setText(appInfo != null && appInfo.getApplicationName() != null ? appInfo.getApplicationName() : "");
        fOperationNameText.setText(appInfo != null && appInfo.getOperationName() != null ? appInfo.getOperationName() : "");
        fAppVersionText.setText(appInfo != null && appInfo.getApplicationVersion() != null ? appInfo.getApplicationVersion() : "");
        fURMCheck.setSelection(criteria != null ? criteria.isUserReplaceableModules() : false);
    }

    protected void saveCICSSectionExpandState(Section filterSection, Section additionalFilterSection, Section advancedFilterSection) {
        this.getDialogSettings().put("EXPAND_FILTERS", filterSection.isExpanded());
        this.getDialogSettings().put("EXPAND_ADDITIONAL_CICS_FILTERS", additionalFilterSection.isExpanded());
        this.getDialogSettings().put("EXPAND_ADVANCED_PROGRAM_INTERRUPTION_FILTERS", advancedFilterSection.isExpanded());
    }

    protected void saveNonCICSSectionExpandState(Section addtionSubSysfilterSection) {
        this.getDialogSettings().put("EXPAND_ADD_SUBSYSTEM_FILTER", addtionSubSysfilterSection.isExpanded());
    }

    protected void saveIMSIsolationSectionExpandState(Section imsIsolationSection) {
        this.getDialogSettings().put("EXPAND_ADD_IMS_ISOLATION", imsIsolationSection.isExpanded());
    }

    protected void saveCommonSectionsExpandState(Section filterSection, Section debugOptionSection, Section advConnOptionSection) {
        this.getDialogSettings().put("EXPAND_FILTERS", true);
        this.getDialogSettings().put("EXPAND_DEBUGGER_OPTIONS", debugOptionSection.isExpanded());
        this.getDialogSettings().put("EXPAND_ADVANCED_CONNECTION_OPTIONS", advConnOptionSection.isExpanded());
    }

    protected void getBackLevelLocation(CCombo fRegionCombo, DebugProfileDTSP p) {
        String[] locations;
        String location = "&USERID.DLAYDBG.EQAUOPTS";
        if (p != null && p.getLocation() != null & !p.getLocation().isEmpty()) {
            location = p.getLocation();
        }
        if ((locations = this.retrieveList("NON_CICS_LOCATIONS")) == null) {
            locations = new String[]{location};
        }
        fRegionCombo.getParent().layout();
        fRegionCombo.removeAll();
        this.fToolkitHelper.initializeCombo(fRegionCombo, locations, location, ProfileLabels.editor_connect_location_nonAPI_tooltip);
        fRegionCombo.setEditable(true);
    }

    protected void updateArrayList(String newItem, String Key) {
        String[] stringArray;
        if (this.retrieveList(Key) != null) {
            stringArray = this.retrieveList(Key);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = newItem;
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(stringArray));
        if (list.size() > 0) {
            if (list.contains(newItem)) {
                list.remove(newItem);
            }
            if (list.size() == 10) {
                list.remove(list.size() - 1);
            }
        }
        list.add(0, newItem);
        String[] newList = new String[list.size()];
        newList = list.toArray(newList);
        this.getDialogSettings().put(Key, newList);
    }

    private String[] retrieveList(String Key) {
        String[] list = this.getDialogSettings().getArray(Key);
        return list;
    }

    protected void updateDeleteConnection(String connectionName, CCombo fConnectionCombo, CCombo fRegionCombo, Label fRegionLabel, IDebugProfileEditorConstants.PROFILE_TYPE type) {
        fConnectionCombo.remove(connectionName);
        if (connectionName.equalsIgnoreCase(fConnectionCombo.getText())) {
            fConnectionCombo.computeSize(-1, -1, true);
            fConnectionCombo.setText("");
            fConnectionCombo.layout();
            fRegionCombo.removeAll();
            fRegionCombo.computeSize(-1, -1, true);
            fRegionCombo.layout();
            fRegionCombo.setText("");
        }
    }
}

