/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.editor;

import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileNameUtils;
import com.ibm.debug.pdt.ui.profile.internal.Activator;
import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import com.ibm.debug.pdt.ui.profile.internal.editor.DebugProfileEditorPage;
import com.ibm.debug.pdt.ui.profile.internal.editor.IDebugProfileEditorConstants;
import com.ibm.debug.pdt.ui.profile.internal.editor.ProfileEditorInput;
import com.ibm.debug.pdt.ui.profile.internal.outline.DebugProfileOutlinePage;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class DebugProfileEditor
extends FormEditor
implements IDebugProfileEditorConstants {
    private ProfileEditorInput fEditorInput;
    private DebugProfile fDebugProfile;
    private DebugProfileEditorPage fDebugProfileEditorPage;
    private boolean fDirty = true;
    private static IContextActivation fContext;
    private DebugProfileOutlinePage fDebugProfileOutlinePage;
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            if (partRef.getId().equals("com.ibm.debug.pdt.idz.launches.common.profile.editor.DebugProfileEditor")) {
                DebugProfileEditor.this.disableContext();
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
            if (partRef.getId().equals("com.ibm.debug.pdt.idz.launches.common.profile.editor.DebugProfileEditor")) {
                DebugProfileEditor.this.disableContext();
            }
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (partRef.getId().equals("com.ibm.debug.pdt.idz.launches.common.profile.editor.DebugProfileEditor")) {
                DebugProfileEditor.this.disableContext();
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }
    };

    protected void addPages() {
        try {
            this.fDebugProfileEditorPage = new DebugProfileEditorPage(this, "profile", ProfileLabels.editor_title);
            this.addPage((IFormPage)this.fDebugProfileEditorPage);
        }
        catch (PartInitException e) {
            Activator.log(e);
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.fDebugProfileEditorPage.getFormMessageType() == 3) {
            PICLDebugPlugin.showMessageDialog((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (int)1, (String)ProfileLabels.debug_profile_message, (String)ProfileMessages.CRRDG9147, (boolean)false);
            return;
        }
        DebugProfile p = this.saveProfile();
        if (p != null && p.getMode() != 0) {
            String activateCmdId = p.getMode() == 1 ? "com.ibm.debug.pdt.ui.profile.eclipse.command.saveAndActivateDebugProfile" : "com.ibm.debug.pdt.ui.profile.eclipse.command.saveAndActivateCCProfile";
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
            Command command = commandService.getCommand(activateCmdId);
            if (command.getHandler().isHandled()) {
                IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand(activateCmdId, null);
                }
                catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                    Activator.log(e);
                }
            }
        }
    }

    public DebugProfile saveProfile() {
        DebugProfile p = this.fDebugProfileEditorPage.saveProfile();
        if (p != null) {
            this.setDirty(false);
            return p;
        }
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input instanceof ProfileEditorInput) {
            this.fEditorInput = (ProfileEditorInput)input;
            this.fDebugProfile = this.fEditorInput.getDebugProfile();
            if (this.fDebugProfile != null) {
                this.setPartName(this.fDebugProfile.getName());
            } else {
                String name = "";
                switch (this.fEditorInput.getProfileType()) {
                    case PROFILE_IMS: {
                        name = DebugProfileNameUtils.generateNewName((String)"IMS-PROFILE-");
                        break;
                    }
                    case PROFILE_NON_CICS: {
                        name = DebugProfileNameUtils.generateNewName((String)"PROFILE-");
                        break;
                    }
                    default: {
                        name = DebugProfileNameUtils.generateNewName((String)"CICS-PROFILE-");
                    }
                }
                this.setPartName(name);
            }
            String helpID = "";
            switch (this.fEditorInput.getProfileType()) {
                case PROFILE_IMS: {
                    helpID = "com.ibm.debug.pdt.ui.profile.eclipse.ims_editor";
                    break;
                }
                case PROFILE_NON_CICS: {
                    helpID = "com.ibm.debug.pdt.ui.profile.eclipse.dtsp_editor";
                    break;
                }
                default: {
                    helpID = "com.ibm.debug.pdt.ui.profile.eclipse.dtcn_editor";
                }
            }
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)site.getShell(), helpID);
        }
        this.getSite().getPage().addPartListener(this.fPartListener);
    }

    public void setEditorPartName(String name) {
        this.setPartName(name);
    }

    public ProfileEditorInput getProfileEditorInput() {
        return this.fEditorInput;
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    protected void setDirty(boolean isDirty) {
        if (this.fDirty != isDirty) {
            this.fDirty = isDirty;
            this.editorDirtyStateChanged();
        }
    }

    public void setFocus() {
        super.setFocus();
        IFormPage page = this.getActivePageInstance();
        if (page != null && page instanceof DebugProfileEditorPage) {
            ((DebugProfileEditorPage)page).setFocus();
            this.fDebugProfileEditorPage = (DebugProfileEditorPage)page;
        }
        this.enableContext();
    }

    public void showTooltip(boolean error) {
        if (this.getActivePageInstance() instanceof DebugProfileEditorPage) {
            ((DebugProfileEditorPage)this.getActivePageInstance()).showTooltip(error);
        }
    }

    public void hideTooltip() {
        if (this.getActivePageInstance() instanceof DebugProfileEditorPage) {
            ((DebugProfileEditorPage)this.getActivePageInstance()).hideTooltip();
        }
    }

    public void dispose() {
        super.dispose();
        this.disableContext();
        this.getSite().getPage().removePartListener(this.fPartListener);
    }

    private void enableContext() {
        if (fContext == null) {
            IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
            fContext = contextService.activateContext("com.ibm.debug.pdt.ui.profile.eclipse.context.profileEditor");
        }
    }

    private void disableContext() {
        if (fContext != null) {
            IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
            contextService.deactivateContext(fContext);
            fContext = null;
        }
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            return this.getContentOutlinePage();
        }
        return super.getAdapter(required);
    }

    public DebugProfileOutlinePage getContentOutlinePage() {
        if (this.fDebugProfileOutlinePage == null) {
            this.fDebugProfileOutlinePage = new DebugProfileOutlinePage(this, this.fDebugProfileEditorPage.getOutlineInput(), this.fEditorInput.getProfileType());
        }
        return this.fDebugProfileOutlinePage;
    }

    public void showMainErrorTooltip() {
        if (this.getActivePageInstance() instanceof DebugProfileEditorPage) {
            ((DebugProfileEditorPage)this.getActivePageInstance()).showMainErrorTooltip();
        }
    }

    public boolean isSaveOnCloseNeeded() {
        boolean result = super.isSaveOnCloseNeeded();
        if (this.getActivePageInstance() instanceof DebugProfileEditorPage) {
            result &= ((DebugProfileEditorPage)this.getActivePageInstance()).getFormMessageType() != 3;
        }
        return result;
    }

    public void refresh() {
        this.fDebugProfileEditorPage.refresh();
    }
}

