/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.dialogs;

import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.profile.internal.LogUtils;
import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.profile.internal.model.ExportedDebugProfiles;
import com.ibm.debug.pdt.ui.profile.internal.Activator;
import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import com.ibm.debug.pdt.ui.profile.internal.dialogs.ImportProfilesWizardPage;
import com.ibm.debug.pdt.ui.profile.internal.migration.DebugProfileMigrationUtils;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ImportProfileWizard
extends Wizard {
    private static final String SECTION = "com.ibm.debug.pdt.ui.profile.ImportProfileWizard";
    private static final String DEFAULT_JSON = "debugProfilesPath";
    private static final String DEFAULT_WORKSPACE = "workspace";
    private ImportProfilesWizardPage fImportPage;
    private int fNumImportedProfiles = -1;
    private String fImportLocation;

    public ImportProfileWizard() {
        this.setWindowTitle(ProfileLabels.import_debug_profiles);
        this.setDefaultPageImageDescriptor(PICLUtils.getImageDescriptor((String)"PICL_ICON_BREAKPOINT_WIZARD"));
        this.setHelpAvailable(true);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.fImportPage = new ImportProfilesWizardPage(this.getDefaultJSONDirectory(), this.getDefaultWorkspaceDirectory());
        this.addPage((IWizardPage)this.fImportPage);
    }

    public boolean performFinish() {
        try {
            this.fNumImportedProfiles = -1;
            this.fImportLocation = this.fImportPage.getImportLocation();
            if (this.fImportPage.isDebugProfileFile()) {
                this.fNumImportedProfiles = ExportedDebugProfiles.importProfiles((String)this.fImportLocation);
            } else {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            ImportProfileWizard.this.fNumImportedProfiles = DebugProfileMigrationUtils.migrateAndImport(monitor, ImportProfileWizard.this.fImportLocation);
                        }
                        catch (Exception e) {
                            ImportProfileWizard.this.fImportPage.setErrorMessage(NLS.bind((String)ProfileMessages.CRRDG9139, (Object)ImportProfileWizard.this.fImportLocation));
                            ImportProfileWizard.this.fNumImportedProfiles = -2;
                        }
                    }
                });
                while (this.fNumImportedProfiles == -1) {
                    Thread.sleep(10L);
                }
            }
            if (this.fNumImportedProfiles == 0) {
                this.fImportPage.setErrorMessage(NLS.bind((String)ProfileMessages.CRRDG9137, (Object)this.fImportLocation));
            }
            if (this.fNumImportedProfiles > 0) {
                if (this.fImportPage.isDebugProfileFile()) {
                    this.saveJSONLocation(this.fImportLocation);
                } else {
                    this.saveWorkspaceLocation(this.fImportLocation);
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.fImportPage.setErrorMessage(e.getMessage());
            if (e instanceof InvocationTargetException) {
                LogUtils.log((Throwable)e);
            }
            return false;
        }
    }

    public void displaySuccessMessage() {
        String message = NLS.bind((String)ProfileMessages.CRRDG9134, (Object)this.fImportLocation, (Object)Integer.toString(this.fNumImportedProfiles));
        PICLDebugPlugin.showMessageDialog((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (int)2, (String)ProfileLabels.debug_profile_message, (String)message, (boolean)false);
    }

    private void saveJSONLocation(String path) {
        if (path != null && !path.isEmpty()) {
            IDialogSettings settings = this.getSettings();
            settings.put(DEFAULT_JSON, path);
        }
    }

    private void saveWorkspaceLocation(String path) {
        if (path != null && !path.isEmpty()) {
            IDialogSettings settings = this.getSettings();
            settings.put(DEFAULT_WORKSPACE, path);
        }
    }

    private IDialogSettings getSettings() {
        IDialogSettings result = Activator.getDefault().getDialogSettings().getSection(SECTION);
        if (result == null) {
            result = Activator.getDefault().getDialogSettings().addNewSection(SECTION);
        }
        return result;
    }

    private String getDefaultJSONDirectory() {
        IDialogSettings settings = this.getSettings();
        return settings.get(DEFAULT_JSON);
    }

    private String getDefaultWorkspaceDirectory() {
        IDialogSettings settings = this.getSettings();
        return settings.get(DEFAULT_WORKSPACE);
    }
}

