/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.profile.internal.dialogs;

import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileException;
import com.ibm.debug.pdt.profile.internal.model.ExportedDebugProfiles;
import com.ibm.debug.pdt.ui.profile.internal.Activator;
import com.ibm.debug.pdt.ui.profile.internal.ProfileLabels;
import com.ibm.debug.pdt.ui.profile.internal.dialogs.ExportProfilesWizardPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ExportProfileWizard
extends Wizard {
    private static final String SECTION = "com.ibm.debug.pdt.ui.profile.ExportProfileWizard";
    private static final String DEFAULT = "filePath";
    private DebugProfile[] fProfiles;
    private ExportProfilesWizardPage fExportPage;
    private String fExportFile;

    public ExportProfileWizard(DebugProfile[] profiles) {
        this.fProfiles = profiles;
        this.setWindowTitle(ProfileLabels.export_debug_profiles);
        this.setDefaultPageImageDescriptor(PICLUtils.getImageDescriptor((String)"PICL_ICON_BREAKPOINT_WIZARD"));
        this.setHelpAvailable(true);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.fExportPage = new ExportProfilesWizardPage(this.getDefaultDirectory());
        this.addPage((IWizardPage)this.fExportPage);
    }

    public boolean performFinish() {
        ExportedDebugProfiles exportProfiles = new ExportedDebugProfiles(this.fProfiles);
        try {
            String directory = this.fExportPage.getExportDirectory();
            this.fExportFile = exportProfiles.export(directory);
            this.saveLocation(directory);
            return true;
        }
        catch (DebugProfileException e) {
            this.fExportPage.setErrorMessage(e.getMessage());
            return false;
        }
    }

    public void displaySuccessMessage() {
        String message = this.fProfiles.length == 1 ? NLS.bind((String)ProfileMessages.CRRDG9132, (Object)this.fExportFile) : NLS.bind((String)ProfileMessages.CRRDG9133, (Object)this.fExportFile, (Object)Integer.toString(this.fProfiles.length));
        PICLDebugPlugin.showMessageDialog((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (int)2, (String)ProfileLabels.debug_profile_message, (String)message, (boolean)false);
    }

    private void saveLocation(String directory) {
        if (directory != null && !directory.isEmpty()) {
            IDialogSettings settings = this.getSettings();
            settings.put(DEFAULT, directory);
        }
    }

    private IDialogSettings getSettings() {
        IDialogSettings result = Activator.getDefault().getDialogSettings().getSection(SECTION);
        if (result == null) {
            result = Activator.getDefault().getDialogSettings().addNewSection(SECTION);
        }
        return result;
    }

    private String getDefaultDirectory() {
        IDialogSettings settings = this.getSettings();
        return settings.get(DEFAULT);
    }
}

