/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.profile.internal.rest.client;

import com.ibm.debug.pdt.profile.internal.cc.CodeCoverageUtils;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTCN;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileUtils;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.profile.internal.rest.client.DebugProfileRestClientV1_JSON;
import com.ibm.debug.pdt.profile.internal.rest.client.IDebugProfileRestClientConstants;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class DebugProfileRestClientV1_DTCN_JSON
extends DebugProfileRestClientV1_JSON
implements IDebugProfileConstants,
IDebugProfileRestClientConstants {
    protected String profileid;
    protected String activation;
    protected List<LoadModuleJSON> program;
    protected String transactionid;
    protected String terminalid;
    protected String userid;
    protected String netname;
    protected String clientip;
    protected String commareaoffset;
    protected String commareadata;
    protected String containername;
    protected String containeroffset;
    protected String containerdata;
    protected String urmdeb;
    protected String certificate;
    protected String pmsysid;
    protected String pmplatform;
    protected String pmapplication;
    protected String pmoperation;
    protected String pmappvermaj;
    protected String pmappvermin;
    protected String pmappvermic;
    protected String trigger;
    protected String level;
    protected String sesstype;
    protected String sessaddr;
    protected String sessport;
    protected String sesscert;
    protected String commandfile;
    protected String preferencefile;
    protected String promptlevel;
    protected String otheropts;
    protected String envar;
    protected String eqaoptsfile;
    protected String uuid;
    protected String bzucfgfile;
    protected String bzuplayfile;
    public static final String ACTIVATED = "A";
    public static final String INACTIVATED = "I";
    public static final String URM_YES = "Y";
    public static final String URM_NO = "N";

    public DebugProfileRestClientV1_DTCN_JSON(DebugProfileDTCN localProfile) {
        this.activation = localProfile.getState() == 1 || localProfile.getState() == 4 ? ACTIVATED : INACTIVATED;
        this.uuid = localProfile.getUUID().toString();
        this.transactionid = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getTransaction());
        List<DebugProfile.LoadModulePair> loadModules = localProfile.getLoadModulePairs();
        if (loadModules != null && !loadModules.isEmpty()) {
            this.program = new ArrayList<LoadModuleJSON>();
            for (DebugProfile.LoadModulePair l : loadModules) {
                this.program.add(new LoadModuleJSON(l.getLoadModule(), l.getCompilationUnit()));
            }
        }
        if (localProfile.getAdditionalCICSFilters() != null) {
            this.terminalid = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getAdditionalCICSFilters().getTerminalID());
            this.userid = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getAdditionalCICSFilters().getUserID());
            this.netname = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getAdditionalCICSFilters().getNetName());
            this.clientip = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getAdditionalCICSFilters().getIP());
            this.pmsysid = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getAdditionalCICSFilters().getCICSSysID());
        }
        if (localProfile.getAdvancedProgramInterruptionCriteria() != null) {
            if (localProfile.getAdvancedProgramInterruptionCriteria().getCommAreaInfo() != null) {
                this.commareaoffset = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getAdvancedProgramInterruptionCriteria().getCommAreaInfo().getOffset());
                this.commareadata = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getAdvancedProgramInterruptionCriteria().getCommAreaInfo().getData());
            }
            if (localProfile.getAdvancedProgramInterruptionCriteria().getContainerInfo() != null) {
                this.containername = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getAdvancedProgramInterruptionCriteria().getContainerInfo().getName());
                this.containeroffset = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getAdvancedProgramInterruptionCriteria().getContainerInfo().getOffset());
                this.containerdata = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getAdvancedProgramInterruptionCriteria().getContainerInfo().getData());
            }
            if (localProfile.getAdvancedProgramInterruptionCriteria().getApplicationInfo() != null) {
                String[] tokens;
                this.pmplatform = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getAdvancedProgramInterruptionCriteria().getApplicationInfo().getPlatformName());
                this.pmapplication = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getAdvancedProgramInterruptionCriteria().getApplicationInfo().getApplicationName());
                this.pmoperation = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getAdvancedProgramInterruptionCriteria().getApplicationInfo().getOperationName());
                String appversion = localProfile.getAdvancedProgramInterruptionCriteria().getApplicationInfo().getApplicationVersion();
                String[] stringArray = tokens = appversion == null ? null : appversion.split("\\.");
                if (tokens != null && tokens.length == 3) {
                    this.pmappvermaj = DebugProfileRestClientV1_DTCN_JSON.padVersion(tokens[0]);
                    this.pmappvermin = DebugProfileRestClientV1_DTCN_JSON.padVersion(tokens[1]);
                    this.pmappvermic = DebugProfileRestClientV1_DTCN_JSON.padVersion(tokens[2]);
                }
            }
            String string = this.urmdeb = localProfile.getAdvancedProgramInterruptionCriteria().isUserReplaceableModules() ? URM_YES : URM_NO;
        }
        if (localProfile.getDebuggerOptions() != null) {
            boolean useEnvar;
            this.trigger = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getDebuggerOptions().getTestLevel());
            this.level = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getDebuggerOptions().getErrorLevel());
            this.commandfile = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getDebuggerOptions().getCommandDataSet());
            this.preferencefile = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getDebuggerOptions().getPreferenceDataSet());
            this.promptlevel = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getDebuggerOptions().getPromptLevel());
            this.eqaoptsfile = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getDebuggerOptions().getEqaOptsFile());
            String ccEnvar = null;
            if (localProfile.getMode() == 2) {
                ccEnvar = localProfile.getCodeCoverageStartupKey() != null ? localProfile.getCodeCoverageStartupKey() : CodeCoverageUtils.generateStartupKey(localProfile);
            }
            String zunitEnvar = null;
            switch (localProfile.getMode()) {
                case 3: 
                case 6: {
                    zunitEnvar = "EQA_DTR_MODE=Y";
                    break;
                }
                case 4: 
                case 7: {
                    zunitEnvar = "EQA_DTR_MODE=C";
                    break;
                }
            }
            Object dbrmEnvar = localProfile.getDBRM();
            if (dbrmEnvar != null) {
                dbrmEnvar = "EQA_DBG_DBRM=" + (String)dbrmEnvar;
            }
            String recEnvar = null;
            if (localProfile.getCollectorPort() >= 0) {
                recEnvar = "EQA_STARTUP_KEY=REC";
            }
            boolean bl = useEnvar = zunitEnvar != null || dbrmEnvar != null;
            if (useEnvar) {
                this.envar = DebugProfileRestClientV1_DTCN_JSON.buildEnvar(DebugProfileUtils.quote(zunitEnvar), DebugProfileUtils.quote((String)dbrmEnvar), DebugProfileUtils.quote(ccEnvar), DebugProfileUtils.quote(recEnvar));
            } else {
                this.otheropts = DebugProfileUtils.getUpdatedLEOptions(localProfile, !useEnvar);
            }
        }
        if (localProfile.getZUnitOptions() != null) {
            this.bzuplayfile = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getZUnitOptions().getRecordingFile());
            this.bzucfgfile = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getZUnitOptions().getConfigFile());
        }
        if (localProfile.getMode() == 4 || localProfile.getMode() == 3) {
            int collectorPort = localProfile.getCollectorPort();
            if (collectorPort < 0) {
                this.sesstype = "MFI";
                this.sessaddr = null;
                this.sessport = null;
                this.sesscert = null;
            } else {
                this.sesstype = "RECORD";
                this.sessaddr = InetAddress.getLoopbackAddress().getHostAddress();
                this.sessport = Integer.toString(collectorPort);
                this.sesscert = null;
            }
        } else {
            Connection c;
            if (localProfile.getAdvancedConnectionOptions() != null) {
                String userField = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getAdvancedConnectionOptions().getUserID());
                String ipField = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getAdvancedConnectionOptions().getIP());
                String portField = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getAdvancedConnectionOptions().getPort());
                if (userField != null && !userField.isEmpty()) {
                    this.sesstype = "DBMDT";
                    this.sessaddr = userField;
                    this.sessport = null;
                } else if (ipField != null && !ipField.isEmpty() || portField != null && !portField.isEmpty()) {
                    this.sesstype = "TCP";
                    this.sessaddr = ipField;
                    this.sessport = portField;
                }
                String certField = DebugProfileRestClientV1_DTCN_JSON.getValue(localProfile.getAdvancedConnectionOptions().getCertificate());
                this.sesscert = certField != null && !certField.isEmpty() && localProfile.getAdvancedConnectionOptions().isCertificateEnabled() != false ? certField : null;
            }
            if (this.sesstype == null && (c = ConnectionUtilities.getConnection(localProfile.getConnectionName(), true)) != null) {
                if (c.isUsingDBM()) {
                    c.getLocalClientPort();
                    this.sesstype = "DBMDT";
                    this.sessaddr = c.getUserId();
                    this.sessport = null;
                } else {
                    this.sesstype = "TCP";
                    this.sessaddr = c.getLocalClientIP();
                    this.sessport = c.getLocalClientPort();
                }
            }
        }
    }

    public static String padVersion(String version) {
        StringBuilder result = new StringBuilder(version);
        while (result.length() < 2) {
            result.insert(0, '0');
        }
        return result.toString();
    }

    public static DebugProfileDTCN getProfile(DebugProfileRestClientV1_DTCN_JSON json, String region, Connection connection) {
        DebugProfileDTCN profile = new DebugProfileDTCN(DebugProfileRestClientV1_DTCN_JSON.getUUID(json.uuid));
        profile.setConnectionName(connection.getConnectionName());
        profile.setRegion(region);
        profile.setTransaction(json.transactionid);
        DebugProfileDTCN.AdditionalCICSFilters additionalCICSFilters = new DebugProfileDTCN.AdditionalCICSFilters(json.userid, json.netname, json.clientip, json.pmsysid, json.terminalid);
        profile.setAdditionalCICSFilters(additionalCICSFilters);
        DebugProfileDTCN.ContainerInfo containerInfo = new DebugProfileDTCN.ContainerInfo(json.containername, json.containeroffset, json.containerdata);
        DebugProfileDTCN.ApplicationInfo applicationInfo = new DebugProfileDTCN.ApplicationInfo(json.pmplatform, json.pmapplication, json.pmoperation, DebugProfileRestClientV1_DTCN_JSON.getVersion(json));
        DebugProfileDTCN.CommAreaInfo commAreaInfo = new DebugProfileDTCN.CommAreaInfo(json.commareaoffset, json.commareadata);
        DebugProfileDTCN.AdvancedProgramInterruptionCriteria advancedCriteria = new DebugProfileDTCN.AdvancedProgramInterruptionCriteria(containerInfo, applicationInfo, commAreaInfo, DebugProfileRestClientV1_DTCN_JSON.getURM(json.urmdeb));
        profile.setAdvancedProgramInterruptionCriteria(advancedCriteria);
        DebugProfileRestClientV1_DTCN_JSON.setLoadModules(profile, json.program);
        DebugProfileRestClientV1_DTCN_JSON.setDebugOptions(profile, json.trigger, json.level, json.promptlevel, json.commandfile, json.eqaoptsfile, json.otheropts, json.preferencefile);
        DebugProfileRestClientV1_DTCN_JSON.setCodeCoverageOptions(profile, json.otheropts);
        DebugProfileRestClientV1_DTCN_JSON.setDBRM(profile, json.otheropts);
        DebugProfileRestClientV1_DTCN_JSON.setAdvancedConnectionOptions(profile, connection, json.sesstype, json.sessaddr, json.sessport, json.sesscert);
        DebugProfileRestClientV1_DTCN_JSON.setZUnitOptions(profile, json.bzucfgfile, json.bzuplayfile);
        return profile;
    }

    private static boolean getURM(String urmdeb) {
        return urmdeb != null && urmdeb.equals(URM_YES);
    }

    private static String getVersion(DebugProfileRestClientV1_DTCN_JSON json) {
        if (DebugProfileRestClientV1_DTCN_JSON.getValue(json.pmappvermaj) != null || DebugProfileRestClientV1_DTCN_JSON.getValue(json.pmappvermin) != null || DebugProfileRestClientV1_DTCN_JSON.getValue(json.pmappvermic) != null) {
            return NLS.bind((String)"{0}.{1}.{2}", (Object[])new String[]{DebugProfileRestClientV1_DTCN_JSON.getDigit(json.pmappvermaj), DebugProfileRestClientV1_DTCN_JSON.getDigit(json.pmappvermin), DebugProfileRestClientV1_DTCN_JSON.getDigit(json.pmappvermic)});
        }
        return null;
    }

    private static String getDigit(String version) {
        if (version != null && !version.isEmpty()) {
            try {
                int iVersion = Integer.parseInt(version);
                return Integer.toString(iVersion);
            }
            catch (NumberFormatException e) {
                return version;
            }
        }
        return null;
    }

    static class LoadModuleJSON {
        String loadname;
        String pgmname;

        public LoadModuleJSON(String load, String pgm) {
            this.loadname = load;
            this.pgmname = pgm;
        }
    }
}

