/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.profile.internal.rest.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.ibm.debug.pdt.launch.internal.zpicl.preferences.LaunchzPICLPreferences;
import com.ibm.debug.pdt.profile.internal.LogUtils;
import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.profile.internal.ProfilePlugin;
import com.ibm.debug.pdt.profile.internal.configuration.ExtendedSupportUtillities;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionEventListener;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionEventManager;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.rest.APIServerException;
import com.ibm.debug.pdt.profile.internal.rest.client.DebugProfileRestClientV1_DTCN_JSON;
import com.ibm.debug.pdt.profile.internal.rest.client.DebugProfileRestClientV1_DTSP_JSON;
import com.ibm.debug.pdt.profile.internal.rest.client.IDebugProfileRestClientConstants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class DebugProfileRestClientV1
implements IDebugProfileRestClientConstants {
    public static final String UTF_8 = "UTF-8";
    private static final Map<String, List<DTCN_Region_Response>> fRegionMap = new ConcurrentHashMap<String, List<DTCN_Region_Response>>();

    public static List<DTCN_Region_Response> getRegions(Connection connection) throws APIServerException {
        block8: {
            DTCN_List_Response jsonBody;
            block9: {
                HttpResponse response;
                block7: {
                    if (connection.getErrorState() != Connection.ERROR_STATE.NONE && connection.getErrorState() != Connection.ERROR_STATE.CICS_ONLY) {
                        return null;
                    }
                    if (fRegionMap.containsKey(connection.getConnectionName())) {
                        return fRegionMap.get(connection.getConnectionName());
                    }
                    HttpRequestBase request = DebugProfileRestClientV1.buildRequest_QueryRemoteListOfCICSRegions(connection);
                    response = DebugProfileRestClientV1.executeRequest(request, connection);
                    if (response != null) break block7;
                    return null;
                }
                if (200 != response.getStatusLine().getStatusCode()) break block8;
                Gson gson = new Gson();
                String body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)UTF_8);
                jsonBody = (DTCN_List_Response)gson.fromJson(body, DTCN_List_Response.class);
                if (jsonBody != null && jsonBody.regions != null && !jsonBody.regions.isEmpty()) break block9;
                return null;
            }
            try {
                fRegionMap.put(connection.getConnectionName(), jsonBody.regions);
                connection.setAPIVersion(jsonBody.apiversion);
                return jsonBody.regions;
            }
            catch (APIServerException se) {
                throw se;
            }
            catch (Exception e) {
                LogUtils.log(e);
            }
        }
        return null;
    }

    public static HttpRequestBase buildRequest_QueryRemoteListOfCICSRegions(Connection connection) throws Exception {
        HttpGet method = new HttpGet();
        return DebugProfileRestClientV1.buildRequest((HttpRequestBase)method, "profile/dtcn", connection, false);
    }

    public static HttpRequestBase buildRequest_QueryRemoteDTCNProfileList(String region, Connection connection) throws Exception {
        HttpGet method = new HttpGet();
        return DebugProfileRestClientV1.buildRequest((HttpRequestBase)method, "profile/dtcn?region=" + region, connection, true);
    }

    public static HttpRequestBase buildRequest_QueryRemoteDTCNProfileForUser(String region, String userName, Connection connection) throws Exception {
        HttpGet method = new HttpGet();
        return DebugProfileRestClientV1.buildRequest((HttpRequestBase)method, "profile/dtcn/" + userName + "?region=" + region, connection, true);
    }

    public static HttpRequestBase buildRequest_CreateRemoteDTCNProfile(String region, String userName, DebugProfileRestClientV1_DTCN_JSON profileJSON, Connection connection) throws Exception {
        HttpPost method = new HttpPost();
        Gson gson = new Gson();
        method.setEntity((HttpEntity)new StringEntity(gson.toJson((Object)profileJSON), UTF_8));
        return DebugProfileRestClientV1.buildRequest((HttpRequestBase)method, "profile/dtcn/" + userName + "?region=" + region, connection, true);
    }

    public static HttpRequestBase buildRequest_UpdateRemoteDTCNProfile(String region, String userName, DebugProfileRestClientV1_DTCN_JSON profileJSON, Connection connection) throws Exception {
        HttpPut method = new HttpPut();
        Gson gson = new Gson();
        method.setEntity((HttpEntity)new StringEntity(gson.toJson((Object)profileJSON), UTF_8));
        return DebugProfileRestClientV1.buildRequest((HttpRequestBase)method, "profile/dtcn/" + userName + "?region=" + region, connection, true);
    }

    public static HttpRequestBase buildRequest_DeleteRemoteDTCNProfile(String region, String userName, Connection connection) throws Exception {
        HttpDelete method = new HttpDelete();
        return DebugProfileRestClientV1.buildRequest((HttpRequestBase)method, "profile/dtcn/" + userName + "?region=" + region, connection, true);
    }

    public static HttpRequestBase buildRequest_CreateRemoteDTSPProfile(String userName, DebugProfileRestClientV1_DTSP_JSON profileJSON, Connection connection) throws Exception {
        HttpPost method = new HttpPost();
        Gson gson = new Gson();
        method.setEntity((HttpEntity)new StringEntity(gson.toJson((Object)profileJSON), UTF_8));
        return DebugProfileRestClientV1.buildRequest((HttpRequestBase)method, "profile/ds/" + userName + "?dlaydbg=true", connection, true);
    }

    public static HttpRequestBase buildRequest_UpdateRemoteDTSPProfile(String userName, DebugProfileRestClientV1_DTSP_JSON profileJSON, Connection connection) throws Exception {
        HttpPut method = new HttpPut();
        Gson gson = new Gson();
        method.setEntity((HttpEntity)new StringEntity(gson.toJson((Object)profileJSON), UTF_8));
        return DebugProfileRestClientV1.buildRequest((HttpRequestBase)method, "profile/ds/" + userName + "?dlaydbg=true", connection, true);
    }

    public static HttpRequestBase buildRequest_DeleteRemoteDTSPProfile(String userName, Connection connection) throws Exception {
        HttpDelete method = new HttpDelete();
        return DebugProfileRestClientV1.buildRequest((HttpRequestBase)method, "profile/ds/" + userName + "?dlaydbg=true", connection, true);
    }

    public static HttpRequestBase buildRequest_GetRemoteDTSPProfile(String userName, Connection connection) throws Exception {
        HttpGet method = new HttpGet();
        return DebugProfileRestClientV1.buildRequest((HttpRequestBase)method, "profile/ds/" + userName, connection, true);
    }

    public static HttpRequestBase buildRequest(HttpRequestBase method, String relativeURI, Connection connection, boolean requiresAuth) throws Exception {
        URI uri = new URI(connection.getAPIServerURL().toString() + "/" + relativeURI);
        method.setURI(uri);
        method.addHeader("Content-Type", "application/json");
        if (connection.getErrorState() != Connection.ERROR_STATE.NONE && connection.getErrorState() != Connection.ERROR_STATE.CICS_ONLY) {
            throw new APIServerException(method.getClass().getSimpleName() + " " + relativeURI, connection.getErrorMessage());
        }
        if (DebugProfileRestClientV1.isCicsRequest(method) && connection.hasAuthInvalidCicsRegion()) {
            String requestRegion = DebugProfileRestClientV1.getCicsRegionFromRequest(method);
            if (connection.getAuthInvalidCicsRegions().contains(requestRegion)) {
                throw new APIServerException(method.getClass().getSimpleName() + " " + relativeURI, ProfileMessages.CRRDG9183);
            }
        }
        if (requiresAuth) {
            DebugProfileRestClientV1.addAuthenticationCredentials((AbstractHttpMessage)method, connection);
        }
        return method;
    }

    public static HttpResponse executeRequest(HttpRequestBase request, Connection connection) throws Exception {
        ProfilePlugin.getTrace().trace("/REST", DebugProfileRestClientV1.getRequestTrace(request));
        HttpResponse response = null;
        if (connection.isSecured()) {
            response = DebugProfileRestClientV1.executeRequestSecured(request, connection);
        } else if (connection.getHttpPort(false) > 0) {
            response = DebugProfileRestClientV1.executeRequestUnsecured(request, connection);
        } else {
            LogUtils.log("Debug profile service unsecured connection is configured with invalid port");
        }
        if (response != null) {
            if (401 == response.getStatusLine().getStatusCode()) {
                if (DebugProfileRestClientV1.isCicsRequest(request) && connection.isTokenAuthSupported()) {
                    String authInvalidRegion = DebugProfileRestClientV1.getCicsRegionFromRequest(request);
                    if (authInvalidRegion != null) {
                        connection.addAuthInvalidCicsRegion(authInvalidRegion, response);
                        ConnectionEventManager.getInstance().fireConnectionEvent(connection, ConnectionEventListener.ConnectionEventType.AUTH_INVALID_CICS_REGION_ADDED);
                    }
                } else {
                    connection.setErrorMessage(DebugProfileRestClientV1.getReadableResponseString(response));
                    connection.setErrorState(Connection.ERROR_STATE.AUTHENTICATION_NOT_VALID);
                }
            }
            ProfilePlugin.getTrace().trace("/REST", DebugProfileRestClientV1.getResponseTrace(response));
        }
        return response;
    }

    private static boolean isCicsRequest(HttpRequestBase request) {
        return request.getRequestLine().getUri().toLowerCase().contains("profile/dtcn");
    }

    private static String getCicsRegionFromRequest(HttpRequestBase request) {
        if (!DebugProfileRestClientV1.isCicsRequest(request)) {
            return null;
        }
        String requestPath = request.getRequestLine().getUri();
        try {
            URI uri = new URI(requestPath);
            List queryParams = URLEncodedUtils.parse((URI)uri, (Charset)StandardCharsets.UTF_8);
            for (NameValuePair param : queryParams) {
                if (!param.getName().equalsIgnoreCase("region")) continue;
                return param.getValue().toLowerCase();
            }
        }
        catch (URISyntaxException e) {
            LogUtils.log(e);
            return null;
        }
        if (requestPath.toLowerCase().contains("settings")) {
            String[] pathSegments = request.getRequestLine().getUri().split("/");
            return pathSegments[pathSegments.length - 1].toLowerCase();
        }
        return null;
    }

    private static HttpRequestBase setRequestToUnsecured(HttpRequestBase request, Connection connection) throws Exception {
        URI oldURI = request.getURI();
        URI unsecuredURI = new URI("http", oldURI.getUserInfo(), oldURI.getHost(), connection.getHttpPort(false), oldURI.getPath(), oldURI.getQuery(), oldURI.getFragment());
        request.setURI(unsecuredURI);
        return request;
    }

    private static HttpResponse executeRequestSecured(HttpRequestBase request, Connection connection) throws Exception {
        SSLException savedException = null;
        X509TrustManager trustManager = ExtendedSupportUtillities.getTrustManager();
        HttpClient httpClient = DebugProfileRestClientV1.createSSLClient(connection, trustManager);
        HttpClientContext localContext = new HttpClientContext();
        HttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)request, (HttpContext)localContext);
        }
        catch (SSLException hse) {
            if (ExtendedSupportUtillities.handleSSLException(hse, trustManager, connection)) {
                httpClient = DebugProfileRestClientV1.createSSLClient(connection, trustManager);
                localContext = new HttpClientContext();
                try {
                    response = httpClient.execute((HttpUriRequest)request, (HttpContext)localContext);
                }
                catch (HttpHostConnectException e) {
                    ProfilePlugin.getTrace().trace("/profileEvents", "Fail making SSL connection to " + connection.getAPIServerURL().toString());
                }
                catch (Exception ex) {
                    LogUtils.log(ex);
                }
            }
            savedException = hse;
        }
        catch (HttpHostConnectException e) {
            ProfilePlugin.getTrace().trace("/profileEvents", "Fail making SSL connection to " + connection.getAPIServerURL().toString());
        }
        if (response == null) {
            if (connection.getHttpPort(false) > 0) {
                if (ExtendedSupportUtillities.isNonSecuredAllowed(connection)) {
                    connection.setSecured(false);
                    request = DebugProfileRestClientV1.setRequestToUnsecured(request, connection);
                    response = DebugProfileRestClientV1.executeRequestUnsecured(request, connection);
                }
            } else {
                LogUtils.log("Debug profile service does not have an unsecured port configured: " + connection.getConnectionName());
                if (savedException != null) {
                    throw new APIServerException(request.getMethod() + " " + String.valueOf(request.getURI()), savedException.getMessage());
                }
            }
        }
        return response;
    }

    private static HttpResponse executeRequestUnsecured(HttpRequestBase request, Connection connection) throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpClientContext localContext = new HttpClientContext();
        HttpResponse response = httpClient.execute((HttpUriRequest)request, (HttpContext)localContext);
        return response;
    }

    private static String getRequestTrace(HttpRequestBase method) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(("\n>> " + method.getClass().getSimpleName() + "    " + method.getURI().toString()).getBytes(Charset.defaultCharset()));
            outputStream.write("\n".getBytes(Charset.defaultCharset()));
            if (method instanceof HttpEntityEnclosingRequestBase) {
                outputStream.write("\t".getBytes(Charset.defaultCharset()));
                if (((HttpEntityEnclosingRequestBase)method).getEntity() != null) {
                    ((HttpEntityEnclosingRequestBase)method).getEntity().writeTo((OutputStream)outputStream);
                }
            }
            return new String(outputStream.toByteArray(), Charset.defaultCharset());
        }
        catch (IOException iOException) {
            return "";
        }
    }

    private static String getResponseTrace(HttpResponse response) {
        try {
            String respStr = DebugProfileRestClientV1.getBodyFromResponse(response);
            return "\n<< " + response.getStatusLine().getStatusCode() + "   " + respStr;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static HttpClient createSSLClient(Connection connection, X509TrustManager mgr) throws Exception {
        SSLContext sslcontext = connection.getSSLContext(mgr);
        if (LaunchzPICLPreferences.getIsSSLCertErrorIgnored()) {
            return HttpClientBuilder.create().setSSLContext(sslcontext).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).build();
        }
        return HttpClientBuilder.create().setSSLContext(sslcontext).build();
    }

    private static void addBasicAuthHeader(AbstractHttpMessage method, String userName, char[] userPassword) {
        byte[] encodedCredentialsArray = (ConnectionUtilities.uppercaseUserID(userName) + ":" + new String(userPassword)).getBytes(Charset.defaultCharset());
        Base64.Encoder e = Base64.getEncoder();
        String encodedCredentials = e.encodeToString(encodedCredentialsArray);
        method.setHeader("Authorization", "Basic " + encodedCredentials);
    }

    private static void addBearerTokenAuthHeader(AbstractHttpMessage method, String jwt) {
        method.setHeader("Authorization", "Bearer " + jwt);
    }

    public static void addImpersonateUserHeader(AbstractHttpMessage method, String ownerId) {
        method.addHeader("X-Impersonate-User", ownerId);
    }

    public static void addAuthenticationCredentials(AbstractHttpMessage method, Connection connection) throws Exception {
        String userName = connection.getUserId();
        char[] userPassword = connection.getUserPassword();
        if (connection.isTokenAuthSupported() && LaunchzPICLPreferences.getIsTokenAuthenticationEnabled()) {
            String jwt = connection.getJwt();
            if (jwt != null) {
                ProfilePlugin.getTrace().trace("/REST", "Successfully retrieved JWT. Bearer authentication will be used.");
                DebugProfileRestClientV1.addBearerTokenAuthHeader(method, jwt);
            } else {
                ProfilePlugin.getTrace().trace("/REST", "Failed to retrieve JWT. Basic authentication will be used.");
                DebugProfileRestClientV1.addBasicAuthHeader(method, userName, userPassword);
            }
        } else {
            ProfilePlugin.getTrace().trace("/REST", "Token authentication not supported by DPS API or the setting is disabled. Basic authentication will be used.");
            DebugProfileRestClientV1.addBasicAuthHeader(method, userName, userPassword);
        }
    }

    public static String getBodyFromResponse(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return null;
        }
        BufferedHttpEntity newEntity = new BufferedHttpEntity(entity);
        response.setEntity((HttpEntity)newEntity);
        return EntityUtils.toString((HttpEntity)newEntity, (String)UTF_8);
    }

    public static String getMessageFromJSONBody(String jsonBodyString) {
        if (jsonBodyString != null && !jsonBodyString.isEmpty() && !jsonBodyString.toLowerCase().startsWith("{")) {
            return jsonBodyString;
        }
        try {
            JsonElement element = JsonParser.parseString((String)jsonBodyString);
            JsonElement item = element.getAsJsonObject().get("message");
            if (item != null) {
                JsonElement id = element.getAsJsonObject().get("messageId");
                if (id != null) {
                    return id.getAsString() + " " + item.getAsString();
                }
                return item.getAsString();
            }
            item = element.getAsJsonObject().get("messageid");
            if (item != null) {
                return item.getAsString() + " " + element.getAsJsonObject().get("error").getAsString();
            }
            item = element.getAsJsonObject().get("error");
            if (item != null) {
                return element.getAsJsonObject().get("error").getAsString();
            }
        }
        catch (Exception e) {
            LogUtils.log(4, jsonBodyString, e);
        }
        return null;
    }

    public static String getReadableResponseString(HttpResponse response) {
        try {
            String fullResponseBody = DebugProfileRestClientV1.getBodyFromResponse(response);
            String responseMessage = DebugProfileRestClientV1.getMessageFromJSONBody(fullResponseBody);
            if (responseMessage != null) {
                return responseMessage;
            }
            return fullResponseBody;
        }
        catch (IOException e) {
            LogUtils.log(e);
            return null;
        }
    }

    public static HttpRequestBase buildRequest_GetDTCNForceSettings(String region, Connection connection) throws Exception {
        HttpGet method = new HttpGet();
        return DebugProfileRestClientV1.buildRequest((HttpRequestBase)method, "profile/dtcn/settings/" + region, connection, true);
    }

    public static void removeRegions(String connectionName) {
        fRegionMap.remove(connectionName);
    }

    public static class DTCNForceSettings_Response {
        public boolean userid;
        public boolean netname;
        public boolean tranid;
        public boolean termid;
        public boolean cuid;
        public boolean progid;
        public boolean loadmodid;
        public boolean ip;
    }

    private static class DTCN_List_Response {
        public String hostname;
        public String apiversion;
        public ArrayList<DTCN_Region_Response> regions;

        private DTCN_List_Response() {
        }
    }

    public static class DTCN_Region_Response {
        public String regionname;
        public String port;
        public boolean ssl;
    }

    public static class DTSP_Profile_Response {
        public String datasetname;
        public String apiversion;
        public boolean dlaydbg;
    }
}

