/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.profile.internal.persistence;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ibm.debug.pdt.profile.internal.LogUtils;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class DebugProfilePersistence
implements IDebugProfileConstants {
    public static final String PROFILE_UI_PREFSTORE = "com.ibm.debug.pdt.ui.profile.preferences";
    public static final String PREF_KEY_PROFILE_LIST = "profile.list";
    public static final String PREF_VALUE_EMPTY_LIST = "[]";

    @Deprecated
    public static synchronized void saveProfile(String profileAsString) {
        JsonObject p = JsonParser.parseString((String)profileAsString).getAsJsonObject();
        DebugProfilePersistence.saveProfile(p);
    }

    public static synchronized void saveProfile(DebugProfile p) {
        DebugProfilePersistence.saveProfile(p.getAsJsonObject());
    }

    private static synchronized void saveProfile(JsonObject pJson) {
        JsonElement profileNameElem = pJson.get("fName");
        String profileName = profileNameElem.getAsString();
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(PROFILE_UI_PREFSTORE);
        String profileListString = preferences.get(PREF_KEY_PROFILE_LIST, PREF_VALUE_EMPTY_LIST);
        JsonElement profileList = JsonParser.parseString((String)profileListString);
        if (profileList instanceof JsonArray) {
            JsonArray newProfileList = new JsonArray();
            for (JsonElement e : (JsonArray)profileList) {
                if (profileName.equals(e.getAsJsonObject().get("fName").getAsString())) continue;
                newProfileList.add(e);
            }
            newProfileList.add((JsonElement)pJson);
            profileList = newProfileList;
            preferences.put(PREF_KEY_PROFILE_LIST, profileList.toString());
            try {
                preferences.flush();
            }
            catch (BackingStoreException e) {
                LogUtils.log(e);
            }
        }
    }

    public static synchronized void deleteProfileByName(String profileName) {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(PROFILE_UI_PREFSTORE);
        String profileListString = preferences.get(PREF_KEY_PROFILE_LIST, PREF_VALUE_EMPTY_LIST);
        JsonElement profileList = JsonParser.parseString((String)profileListString);
        if (profileList instanceof JsonArray) {
            JsonArray newProfileList = new JsonArray();
            for (JsonElement e : (JsonArray)profileList) {
                if (profileName.equals(e.getAsJsonObject().get("fName").getAsString())) continue;
                newProfileList.add(e);
            }
            profileList = newProfileList;
            preferences.put(PREF_KEY_PROFILE_LIST, profileList.toString());
            try {
                preferences.flush();
            }
            catch (BackingStoreException e) {
                LogUtils.log(e);
            }
        }
    }

    public static synchronized void deleteAllProfiles() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(PROFILE_UI_PREFSTORE);
        preferences.put(PREF_KEY_PROFILE_LIST, PREF_VALUE_EMPTY_LIST);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            LogUtils.log(e);
        }
    }

    public static synchronized JsonElement retrieveProfileByName(String profileName) {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(PROFILE_UI_PREFSTORE);
        String profileListString = preferences.get(PREF_KEY_PROFILE_LIST, PREF_VALUE_EMPTY_LIST);
        JsonElement profileList = JsonParser.parseString((String)profileListString);
        if (profileName == null || "".equals(profileName)) {
            return null;
        }
        if (profileList instanceof JsonArray) {
            JsonArray profileArray = (JsonArray)profileList;
            for (JsonElement jsonElement : profileArray) {
                if (!profileName.equals(jsonElement.getAsJsonObject().get("fName").getAsString())) continue;
                return jsonElement;
            }
        }
        return null;
    }

    public static synchronized JsonArray retrieveProfileList() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(PROFILE_UI_PREFSTORE);
        String profileListAsString = preferences.get(PREF_KEY_PROFILE_LIST, PREF_VALUE_EMPTY_LIST);
        JsonElement profileList = JsonParser.parseString((String)profileListAsString);
        return (JsonArray)profileList;
    }
}

