/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.profile.internal.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.ibm.debug.pdt.profile.internal.LogUtils;
import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTCN;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTSP;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileException;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileIMS;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileNameUtils;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileRoot;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class ExportedDebugProfiles {
    public static final String EXPORT_FILENAME = "DebugProfiles{0}.json";
    private static final String CURRENT_VERSION = "1.0";
    private static final String ECLIPSE_FORMAT = "eclipse";
    private String version;
    private String pluginVersion;
    private String format;
    private DebugProfile[] profiles;

    public ExportedDebugProfiles(DebugProfile[] profilesToExport) {
        this.profiles = profilesToExport;
        this.version = CURRENT_VERSION;
        this.format = ECLIPSE_FORMAT;
        this.pluginVersion = Platform.getBundle((String)"com.ibm.debug.pdt.profile.eclipse").getVersion().toString();
    }

    public String export(String directory) throws DebugProfileException {
        File exportFile = this.getExportFileName(directory);
        if (this.profiles != null && this.profiles.length > 0) {
            OutputStreamWriter writer = null;
            try {
                if (!exportFile.createNewFile()) {
                    LogUtils.log("Unable to create profile export file:" + String.valueOf(exportFile));
                }
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(exportFile), StandardCharsets.UTF_8);
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                writer.write(gson.toJson((Object)this));
                String string = exportFile.toString();
                return string;
            }
            catch (IOException e) {
                LogUtils.log(e);
                throw new DebugProfileException(NLS.bind((String)ProfileMessages.CRRDG9131, (Object)exportFile.toString()));
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        LogUtils.log("No profiles were provided for export operation.");
        throw new DebugProfileException(NLS.bind((String)ProfileMessages.CRRDG9131, (Object)exportFile.toString()));
    }

    private File getExportFileName(String directory) {
        File f = new File(directory + File.separator + NLS.bind((String)EXPORT_FILENAME, (Object)""));
        if (!f.exists()) {
            return f;
        }
        int i = 0;
        while (f.exists()) {
            if ((f = new File(directory + File.separator + NLS.bind((String)EXPORT_FILENAME, (Object)("_" + ++i)))).exists()) continue;
            return f;
        }
        return null;
    }

    public static int importProfiles(String fileName) throws DebugProfileException {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(new File(fileName)), StandardCharsets.UTF_8);
            JsonElement element = JsonParser.parseReader((Reader)reader);
            Gson gson = new Gson();
            String version = element.getAsJsonObject().get("version").getAsString();
            String format = element.getAsJsonObject().get("format").getAsString();
            JsonElement profileElement = element.getAsJsonObject().get("profiles");
            if (version == null || !version.equals(CURRENT_VERSION) || format == null || !format.equals(ECLIPSE_FORMAT) || profileElement == null) {
                throw new DebugProfileException(NLS.bind((String)ProfileMessages.CRRDG9135, (Object)fileName));
            }
            int result = 0;
            JsonArray profileArray = profileElement.getAsJsonArray();
            for (JsonElement jsonElement : profileArray) {
                JsonElement profileTypeElem = jsonElement.getAsJsonObject().get("fType");
                if (profileTypeElem == null) continue;
                String type = profileTypeElem.getAsString();
                DebugProfile p = null;
                if ("dtcn".equals(type)) {
                    p = (DebugProfile)gson.fromJson(jsonElement, DebugProfileDTCN.class);
                } else if ("dtsp".equals(type)) {
                    p = (DebugProfile)gson.fromJson(jsonElement, DebugProfileDTSP.class);
                } else if ("IMS".equals(type)) {
                    DebugProfileUtils.addLogForMigrationForIMSDepracatedFields(jsonElement.getAsJsonObject());
                    p = (DebugProfile)gson.fromJson(jsonElement, DebugProfileIMS.class);
                }
                if (p == null) continue;
                p.fState = 0;
                p.fMode = 0;
                ExportedDebugProfiles.importProfile(p);
                ++result;
            }
            if (result == 0) {
                throw new DebugProfileException(NLS.bind((String)ProfileMessages.CRRDG9135, (Object)fileName));
            }
            int n = result;
            return n;
        }
        catch (JsonIOException | JsonSyntaxException e) {
            LogUtils.log(NLS.bind((String)ProfileMessages.CRRDG9135, (Object)fileName));
            LogUtils.log(e);
            throw new DebugProfileException(NLS.bind((String)ProfileMessages.CRRDG9135, (Object)fileName));
        }
        catch (IOException e) {
            LogUtils.log(NLS.bind((String)ProfileMessages.CRRDG9139, (Object)fileName));
            LogUtils.log(e);
            throw new DebugProfileException(NLS.bind((String)ProfileMessages.CRRDG9139, (Object)fileName));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void importProfile(DebugProfile p) {
        DebugProfile existing = DebugProfileRoot.getInstance().getProfileByUUID(p.getUUID());
        if (existing != null) {
            p.fUUID = null;
        }
        if (DebugProfileNameUtils.isNameInUse(p.getName())) {
            p.fName = DebugProfileNameUtils.generateNewName(p.getName());
        }
        DebugProfileRoot.getInstance().addDebugProfile(p);
    }
}

