/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.profile.internal.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ibm.debug.pdt.profile.internal.LogUtils;
import com.ibm.debug.pdt.profile.internal.cc.CodeCoverageUtils;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTCN;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTSP;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileIMS;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;

public class DebugProfileUtils
implements IDebugProfileConstants {
    private static final String EQA_STARTUP_KEY = "EQA_STARTUP_KEY=";
    private static final String PERCENT = "%";
    private static final String AMPERSAND = "&";
    private static final String WILCARD = "*";
    private static final String TEST = "TEST";
    private static final String CONNECTION_FORMAT = "%s%s%s";
    private static final String TEST_RUNTIME_FORMAT = "%s(%s,%s,%s,%s:%s)";
    private static final String ENVAR_START = "ENVAR(";
    private static final String ENVAR_END = ")";

    private static String buildEnvarParm(String ccParm, String existingLEOptions) {
        if (existingLEOptions == null || existingLEOptions.isEmpty()) {
            return "ENVAR(\"" + ccParm + "\")";
        }
        StringBuilder leoptions = new StringBuilder(existingLEOptions);
        int start = 0;
        boolean found = false;
        int i = 0;
        while (i < leoptions.length()) {
            if (leoptions.charAt(i) == '\"') {
                i = DebugProfileUtils.getEndQuote(leoptions, i + 1);
            } else if (leoptions.charAt(i) == '(') {
                if (leoptions.substring(start, i + 1).equals(ENVAR_START)) {
                    i = DebugProfileUtils.getEndBracket(leoptions, i);
                    leoptions.insert(i, "\"");
                    leoptions.insert(i, ccParm);
                    leoptions.insert(i, "\"");
                    leoptions.insert(i, ",");
                    found = true;
                    break;
                }
                i = DebugProfileUtils.getEndBracket(leoptions, i);
                start = i + 1;
            } else if (leoptions.charAt(i) == ',') {
                start = i + 1;
            }
            ++i;
        }
        if (!found) {
            leoptions.append(",");
            leoptions.append(ENVAR_START);
            leoptions.append("\"");
            leoptions.append(ccParm);
            leoptions.append("\"");
            leoptions.append(ENVAR_END);
        }
        return leoptions.toString();
    }

    private static int getEndBracket(StringBuilder leoptions, int i) {
        while (i < leoptions.length()) {
            if (leoptions.charAt(i) == '\"') {
                i = DebugProfileUtils.getEndQuote(leoptions, i) + 1;
                continue;
            }
            if (leoptions.charAt(i) == ')') break;
            ++i;
        }
        return i;
    }

    private static int getEndQuote(StringBuilder leoptions, int i) {
        while (i < leoptions.length()) {
            if (leoptions.charAt(i) == '\"') break;
            ++i;
        }
        return i;
    }

    public static String getUpdatedLEOptions(DebugProfile profile, boolean addCC) {
        String startupKey;
        String leOptions;
        String string = leOptions = profile.getDebuggerOptions() == null ? null : profile.getDebuggerOptions().getLanguageEnvironmentOptions();
        if (addCC && profile.getMode() == 2 && profile instanceof DebugProfileDTCN && (startupKey = CodeCoverageUtils.generateStartupKey(profile)) != null) {
            return DebugProfileUtils.buildEnvarParm(startupKey, leOptions);
        }
        return leOptions == null || leOptions.trim().isEmpty() ? "" : leOptions;
    }

    public static String getTestRuntimeOption(DebugProfile profile) {
        DebugProfile.DebuggerOptions debugOptions = profile.getDebuggerOptions();
        String testLevel = TEST;
        String errorLevel = "";
        Object commandsFile = "";
        String promptLevel = "";
        Object preferences = WILCARD;
        if (debugOptions != null) {
            if (debugOptions.getTestLevel() != null && !debugOptions.getTestLevel().isEmpty()) {
                testLevel = debugOptions.getTestLevel();
            }
            if (debugOptions.getErrorLevel() != null && !debugOptions.getErrorLevel().isEmpty()) {
                errorLevel = debugOptions.getErrorLevel();
            }
            if (!(debugOptions.getCommandDataSet() == null || debugOptions.getCommandDataSet().isEmpty() || ((String)(commandsFile = debugOptions.getCommandDataSet())).startsWith("VADSCP") || ((String)commandsFile).startsWith("-"))) {
                commandsFile = "-" + (String)commandsFile;
            }
            if (debugOptions.getPromptLevel() != null && !debugOptions.getPromptLevel().isEmpty()) {
                promptLevel = debugOptions.getPromptLevel();
            }
            if (debugOptions.getPreferenceDataSet() != null && !debugOptions.getPreferenceDataSet().isEmpty() && !((String)(preferences = debugOptions.getPreferenceDataSet())).startsWith("-")) {
                preferences = "-" + (String)preferences;
            }
        }
        DebugProfile.AdvancedConnectionOptions connectionOptions = profile.getAdvancedConnectionOptions();
        Connection c = ConnectionUtilities.getConnection(profile.getConnectionName(), false);
        String connection = CONNECTION_FORMAT;
        Object mode = c == null ? "" : "TCPIP&" + c.getLocalClientIP();
        String sep = PERCENT;
        String portUser = c == null ? "" : c.getLocalClientPort();
        boolean checkConnection = true;
        if (connectionOptions != null) {
            if (connectionOptions.getUserID() != null && !connectionOptions.getUserID().isEmpty()) {
                mode = "DBMDT";
                portUser = ConnectionUtilities.uppercaseUserID(connectionOptions.getUserID());
                checkConnection = false;
            }
            if (connectionOptions.getIP() != null && !connectionOptions.getIP().isEmpty() && connectionOptions.getPort() != null && !connectionOptions.getPort().isEmpty()) {
                mode = "TCPIP&" + connectionOptions.getIP();
                portUser = connectionOptions.getPort();
                checkConnection = false;
            }
        }
        if (checkConnection && c != null && c.isUsingDBM()) {
            mode = "DBMDT";
            if (c.getUserId() != null && !c.getUserId().isEmpty()) {
                portUser = ConnectionUtilities.uppercaseUserID(c.getUserId());
            } else {
                sep = "";
                portUser = "";
            }
        }
        connection = String.format(connection, mode, sep, portUser);
        return String.format(TEST_RUNTIME_FORMAT, testLevel, errorLevel, commandsFile, promptLevel, connection, preferences);
    }

    public static String getStartupKeyFromENVAR(String existingLEOptions) {
        return DebugProfileUtils.getENVAR(existingLEOptions, EQA_STARTUP_KEY);
    }

    public static String getDBRMFromENVAR(String existingLEOptions) {
        return DebugProfileUtils.getENVAR(existingLEOptions, "EQA_DBG_DBRM=");
    }

    private static String getENVAR(String existingLEOptions, String envarName) {
        if (existingLEOptions == null || existingLEOptions.isEmpty()) {
            return "";
        }
        if (existingLEOptions.startsWith(EQA_STARTUP_KEY)) {
            return existingLEOptions;
        }
        StringBuilder leoptions = new StringBuilder(existingLEOptions);
        int start = 0;
        int i = 0;
        while (i < leoptions.length()) {
            if (leoptions.charAt(i) == '\"') {
                i = DebugProfileUtils.getEndQuote(leoptions, i + 1);
            } else if (leoptions.charAt(i) == '(') {
                if (leoptions.substring(start, i + 1).equals(ENVAR_START)) {
                    int start2;
                    int end = DebugProfileUtils.getEndBracket(leoptions, i);
                    int j = start2 = start + ENVAR_START.length();
                    while (j < end) {
                        if (leoptions.charAt(j) == '\"') {
                            int end2 = DebugProfileUtils.getEndQuote(leoptions, j + 1);
                            String leopt = leoptions.substring(start2 + 1, end2);
                            if (leopt.startsWith(envarName)) {
                                return leopt;
                            }
                            start2 = end2;
                            j = end2;
                        } else if (leoptions.charAt(j) == ',') {
                            start2 = j + 1;
                        }
                        ++j;
                    }
                    return "";
                }
                i = DebugProfileUtils.getEndBracket(leoptions, i);
                start = i + 1;
            } else if (leoptions.charAt(i) == ',') {
                start = i + 1;
            }
            ++i;
        }
        return "";
    }

    public static String removeStartupKey(String existingLEOptions) {
        if (existingLEOptions == null || existingLEOptions.isEmpty()) {
            return existingLEOptions;
        }
        StringBuilder leoptions = new StringBuilder(existingLEOptions);
        int start = 0;
        int i = 0;
        while (i < leoptions.length()) {
            if (leoptions.charAt(i) == '\"') {
                i = DebugProfileUtils.getEndQuote(leoptions, i + 1);
            } else if (leoptions.charAt(i) == '(') {
                if (leoptions.substring(start, i + 1).equals(ENVAR_START)) {
                    int start2;
                    int end = DebugProfileUtils.getEndBracket(leoptions, i);
                    int j = start2 = start + ENVAR_START.length();
                    while (j < end) {
                        if (leoptions.charAt(j) == '\"') {
                            int end2 = DebugProfileUtils.getEndQuote(leoptions, j + 1);
                            String leopt = leoptions.substring(start2 + 1, end2);
                            if (leopt.startsWith(EQA_STARTUP_KEY)) {
                                String envarMinusStartup = leoptions.substring(start, start2) + (leoptions.length() > end2 ? leoptions.substring(end2 + 1) : "");
                                if (envarMinusStartup.equals("ENVAR()")) {
                                    leoptions.delete(start, end + 1);
                                    if (start > 0 && leoptions.length() >= start && leoptions.charAt(start - 1) == ',') {
                                        leoptions.deleteCharAt(start - 1);
                                    }
                                } else {
                                    leoptions.delete(j, end2 + 1);
                                    if (leoptions.length() >= j && leoptions.charAt(j - 1) == ',') {
                                        leoptions.deleteCharAt(j - 1);
                                    }
                                }
                                return leoptions.toString();
                            }
                            j = end2;
                        } else if (leoptions.charAt(j) == ',') {
                            start2 = j + 1;
                        }
                        ++j;
                    }
                    return existingLEOptions;
                }
                i = DebugProfileUtils.getEndBracket(leoptions, i);
                start = i + 1;
            } else if (leoptions.charAt(i) == ',') {
                start = i + 1;
            }
            ++i;
        }
        return existingLEOptions;
    }

    public static DebugProfile jsonToDebugProfile(JsonObject jsonObject) {
        DebugProfile p = null;
        Gson gson = new Gson();
        JsonElement profileTypeElem = jsonObject.get("fType");
        if (profileTypeElem == null) {
            return p;
        }
        String type = profileTypeElem.getAsString();
        if ("dtcn".equals(type)) {
            p = (DebugProfile)gson.fromJson((JsonElement)jsonObject, DebugProfileDTCN.class);
        } else if ("dtsp".equals(type)) {
            p = (DebugProfile)gson.fromJson((JsonElement)jsonObject, DebugProfileDTSP.class);
        } else if ("IMS".equals(type)) {
            p = (DebugProfile)gson.fromJson((JsonElement)jsonObject, DebugProfileIMS.class);
        }
        return p;
    }

    public static String quote(String value) {
        return value != null && !value.isEmpty() && !value.startsWith("\"") && !value.endsWith("\"") ? "\"" + value + "\"" : value;
    }

    public static void addLogForMigrationForIMSDepracatedFields(JsonObject profileJsonObject) {
        if (profileJsonObject.has("fADFZCCServerInfo") && profileJsonObject.has("fName")) {
            LogUtils.log(1, "  The following deprecated field fADFZCCServerInfo has been removed for profile" + String.valueOf(profileJsonObject.get("fName")) + ": " + String.valueOf(profileJsonObject.get("fADFZCCServerInfo")));
        }
    }
}

