/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.profile.internal.model;

import com.ibm.debug.pdt.profile.INonCICSDebugProfile;
import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.profile.internal.ProfilePlugin;
import com.ibm.debug.pdt.profile.internal.compatibility.BackLevelDebugProfileClient;
import com.ibm.debug.pdt.profile.internal.configuration.ExtendedSupportUtillities;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileException;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileIMS;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileNameUtils;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileRoot;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.profile.internal.rest.client.DebugProfileRestClientV1;
import com.ibm.debug.pdt.profile.internal.rest.client.DebugProfileRestClientV1_DTSP_JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.AbstractHttpMessage;

public class DebugProfileDTSP
extends DebugProfile
implements IDebugProfileConstants,
INonCICSDebugProfile {
    private JobInfo fJobInfo;
    private IMSOptions fIMSOptions;
    private DB2Options fDB2Options;
    private String fLocation;

    public DebugProfileDTSP(String name) {
        super(name);
        this.fType = "dtsp";
    }

    public DebugProfileDTSP(UUID uuid) {
        this(DebugProfileNameUtils.generateNewName("REMOTE-PROFILE-"));
        this.fUUID = uuid;
    }

    public void setJobInfo(JobInfo jobInfo) {
        this.fJobInfo = jobInfo;
    }

    public JobInfo getJobInfo() {
        return this.fJobInfo;
    }

    public void setIMSOptions(IMSOptions imsOptions) {
        this.fIMSOptions = imsOptions;
    }

    public IMSOptions getIMSOptions() {
        return this.fIMSOptions;
    }

    public void setDB2Options(DB2Options db2Options) {
        this.fDB2Options = db2Options;
    }

    public DB2Options getDB2Options() {
        return this.fDB2Options;
    }

    @Override
    protected HttpMessage[] doProfileActivation(Connection connection) throws Exception {
        this.inactivateIMSIsoProfiles();
        String userId = connection.getUserId();
        if (this.getOwnerId() != null) {
            if (!connection.isRecordingCollectorSupported()) {
                ProfilePlugin.getTrace().trace("/REST", String.format("DPS version %.1f doesn't support impersonation, user ID %s will be used instead of %s. v1.9+ required for impersonation.", connection.getAPIVersion(), userId.toUpperCase(), this.getOwnerId().toUpperCase()));
            } else {
                userId = this.getOwnerId();
            }
        }
        HttpRequestBase request = null;
        HttpResponse response = null;
        request = DebugProfileRestClientV1.buildRequest_DeleteRemoteDTSPProfile(userId, connection);
        if (this.getOwnerId() != null && connection.isRecordingCollectorSupported()) {
            DebugProfileRestClientV1.addImpersonateUserHeader((AbstractHttpMessage)request, this.getOwnerId());
        }
        response = DebugProfileRestClientV1.executeRequest(request, connection);
        DebugProfileRestClientV1_DTSP_JSON profileJSON = new DebugProfileRestClientV1_DTSP_JSON(this);
        request = DebugProfileRestClientV1.buildRequest_CreateRemoteDTSPProfile(userId, profileJSON, connection);
        if (this.getOwnerId() != null && connection.isRecordingCollectorSupported()) {
            DebugProfileRestClientV1.addImpersonateUserHeader((AbstractHttpMessage)request, this.getOwnerId());
        }
        response = DebugProfileRestClientV1.executeRequest(request, connection);
        return new HttpMessage[]{request, response};
    }

    private void inactivateIMSIsoProfiles() throws Exception {
        if (!(this instanceof DebugProfileIMS)) {
            for (DebugProfile profile : DebugProfileRoot.getInstance().getDebugProfiles(this.getConnectionName(), false, true)) {
                if (!(profile instanceof DebugProfileIMS) || profile.getState() != 1) continue;
                profile.deactivate();
            }
        }
    }

    @Override
    protected void doBackLevelProfileActivation(Connection connection, int mode) throws Exception {
        try {
            boolean successful = BackLevelDebugProfileClient.writeDebugProfile(this);
            this.fMode = mode;
            this.fState = 1;
            if (!successful) {
                this.resetStateUnknown();
                throw new DebugProfileException(ProfileMessages.CRRDG9151);
            }
        }
        catch (DebugProfileException e) {
            this.resetStateUnknown();
            throw e;
        }
    }

    @Override
    protected HttpMessage[] doProfileDelete(Connection connection) throws Exception {
        String userId = connection.getUserId();
        if (this.getOwnerId() != null && connection.isRecordingCollectorSupported()) {
            userId = this.getOwnerId();
        }
        HttpRequestBase request = null;
        HttpResponse response = null;
        request = DebugProfileRestClientV1.buildRequest_DeleteRemoteDTSPProfile(userId, connection);
        if (this.getOwnerId() != null && connection.isRecordingCollectorSupported()) {
            DebugProfileRestClientV1.addImpersonateUserHeader((AbstractHttpMessage)request, this.getOwnerId());
        }
        response = DebugProfileRestClientV1.executeRequest(request, connection);
        return new HttpMessage[]{request, response};
    }

    @Override
    protected void doBackLevelProfileDelete(Connection connection) throws Exception {
        try {
            boolean successful = BackLevelDebugProfileClient.deleteEqauoptsFile(this);
            if (!successful) {
                this.resetStateUnknown();
                throw new DebugProfileException(ProfileMessages.CRRDG9152);
            }
        }
        catch (DebugProfileException e) {
            this.resetStateUnknown();
            throw e;
        }
    }

    @Override
    protected boolean doValidateProfile() {
        Connection c = ConnectionUtilities.getConnection(this.getConnectionName(), false);
        return this.fLoadModulePairs != null && !this.fLoadModulePairs.isEmpty() && (this.fLocation != null || c != null && c.isConnected() && (c.getErrorState() == Connection.ERROR_STATE.NONE || c.getNonCICSLocation() != null));
    }

    public String getLocation() {
        Connection c = ConnectionUtilities.getConnection(this.getConnectionName(), false);
        if (c != null && c.isConnected() && c.getErrorState() == Connection.ERROR_STATE.NONE) {
            this.fLocation = c.getNonCICSLocation();
        }
        return this.fLocation;
    }

    public void setLocation(String location) {
        if (location != null && this.fLocation != null && !this.fLocation.equals(location)) {
            this.fMode = 0;
            this.fState = 0;
        }
        this.fLocation = location;
    }

    @Override
    protected List<String> getProfileIssues() {
        ArrayList<String> issues = new ArrayList<String>();
        if (!this.doValidateProfile()) {
            if (this.fLoadModulePairs == null || this.fLoadModulePairs.isEmpty()) {
                issues.add(ProfileMessages.CRRDG9105);
            }
            if (this.fLoadModulePairs != null && !this.fLoadModulePairs.isEmpty()) {
                issues.add(ProfileMessages.CRRDG9142);
            }
        }
        return issues;
    }

    @Override
    protected boolean isBackLevelRequired() {
        return false;
    }

    @Override
    protected HttpMessage[] doProfileSynchronization(Connection connection) throws Exception {
        DebugProfileRestClientV1_DTSP_JSON profileJSON = new DebugProfileRestClientV1_DTSP_JSON(this);
        HttpRequestBase request = DebugProfileRestClientV1.buildRequest_UpdateRemoteDTSPProfile(connection.getUserId(), profileJSON, connection);
        HttpResponse response = DebugProfileRestClientV1.executeRequest(request, connection);
        return new HttpMessage[]{request, response};
    }

    @Override
    public void save() {
        if (this.fLocation == null) {
            this.getLocation();
        }
        super.save();
    }

    @Override
    protected boolean checkForGenericProfile() {
        boolean isJobNameGeneric = this.fJobInfo.getJobName().trim().isEmpty();
        boolean isStepNameGeneric = this.fJobInfo.getStepName().trim().isEmpty();
        boolean isSubsystemNameGeneric = this.fIMSOptions.getSubsystemID().trim().isEmpty();
        boolean isTransactionGeneric = this.fIMSOptions.getTransactionID().trim().isEmpty();
        return ExtendedSupportUtillities.checkForGenericDTSPProfile(isJobNameGeneric, isStepNameGeneric, isSubsystemNameGeneric, isTransactionGeneric, this.isGenericLoadModulePairs());
    }

    @Override
    public void setIMSOptions(String subsystemID, String transactionID) {
        this.setIMSOptions(new IMSOptions(subsystemID, transactionID));
    }

    public static class DB2Options {
        private String fDB2ClientID;

        public DB2Options(String db2ClientID) {
            this.fDB2ClientID = db2ClientID;
        }

        public String getDB2ClientID() {
            return this.fDB2ClientID;
        }
    }

    public static class IMSOptions {
        private String fSubsystemID;
        private String fTransactionID;

        public IMSOptions(String subsystemID, String transactionID) {
            this.fSubsystemID = subsystemID;
            this.fTransactionID = transactionID;
        }

        public String getSubsystemID() {
            return this.fSubsystemID;
        }

        public String getTransactionID() {
            return this.fTransactionID;
        }
    }

    public static class JobInfo {
        private String fJobName;
        private String fStepName;

        public JobInfo(String jobName, String stepName) {
            this.fJobName = jobName;
            this.fStepName = stepName;
        }

        public String getJobName() {
            return this.fJobName;
        }

        public String getStepName() {
            return this.fStepName;
        }
    }
}

