/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.profile.internal.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.ibm.debug.pdt.profile.IAdditionalCICSFilters;
import com.ibm.debug.pdt.profile.ICICSDebugProfile;
import com.ibm.debug.pdt.profile.internal.LogUtils;
import com.ibm.debug.pdt.profile.internal.ProfileMessages;
import com.ibm.debug.pdt.profile.internal.ProfilePlugin;
import com.ibm.debug.pdt.profile.internal.compatibility.BackLevelAPIServerException;
import com.ibm.debug.pdt.profile.internal.compatibility.BackLevelDebugProfileClient;
import com.ibm.debug.pdt.profile.internal.configuration.ExtendedSupportUtillities;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.connection.ConnectionUtilities;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileException;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileNameUtils;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import com.ibm.debug.pdt.profile.internal.rest.client.DebugProfileRestClientV1;
import com.ibm.debug.pdt.profile.internal.rest.client.DebugProfileRestClientV1_DTCN_JSON;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.AbstractHttpMessage;
import org.eclipse.osgi.util.NLS;

public class DebugProfileDTCN
extends DebugProfile
implements IDebugProfileConstants,
ICICSDebugProfile {
    private String fRegion;
    private boolean fRegionCheck = false;
    private int fPort = -1;
    private String fTransaction;
    private AdditionalCICSFilters fAdditionalCICSFilters;
    private AdvancedProgramInterruptionCriteria fAdvancedCriteria;

    public DebugProfileDTCN(String name) {
        super(name);
        this.fType = "dtcn";
    }

    public DebugProfileDTCN(UUID uuid) {
        this(DebugProfileNameUtils.generateNewName("REMOTE-PROFILE-"));
        this.fUUID = uuid;
    }

    @Override
    public void setRegion(String region) {
        if (region != null && !region.equals(this.fRegion)) {
            this.fMode = 0;
            this.fState = 0;
        }
        this.fRegion = region;
        if (this.fRegion != null && !this.fRegion.isEmpty()) {
            this.fPort = -1;
        }
    }

    public String getRegion() {
        Connection c;
        if (!this.fRegionCheck && (this.fRegion == null || this.fRegion.isEmpty()) && (c = ConnectionUtilities.getConnection(this.getConnectionName(), false)) != null && c.getErrorState() != Connection.ERROR_STATE.NONE && c.getErrorState() != Connection.ERROR_STATE.CICS_ONLY) {
            Connection.RegionPortPair[] regionInfo;
            this.fRegionCheck = true;
            Connection.RegionPortPair[] regionPortPairArray = regionInfo = c.getCICSRegionAndPorts();
            int n = regionInfo.length;
            int n2 = 0;
            while (n2 < n) {
                Connection.RegionPortPair r = regionPortPairArray[n2];
                if (r.port == this.fPort) {
                    this.fRegion = r.regionName;
                    break;
                }
                ++n2;
            }
        }
        return this.fRegion;
    }

    public void setPort(int port) {
        if (port > 0 && port != this.fPort) {
            this.fMode = 0;
            this.fState = 0;
        }
        this.fPort = port;
        this.fRegionCheck = false;
        if (port > 0) {
            this.fRegion = null;
        }
    }

    public int getPort() {
        return this.fPort;
    }

    @Override
    public void setTransaction(String transaction) {
        this.fTransaction = transaction;
    }

    public String getTransaction() {
        return this.fTransaction;
    }

    @Override
    public void setAdditionalCICSFilters(IAdditionalCICSFilters additionalCICSFilters) {
        this.fAdditionalCICSFilters = (AdditionalCICSFilters)additionalCICSFilters;
    }

    public AdditionalCICSFilters getAdditionalCICSFilters() {
        return this.fAdditionalCICSFilters;
    }

    public void setAdvancedProgramInterruptionCriteria(AdvancedProgramInterruptionCriteria advancedCriteria) {
        this.fAdvancedCriteria = advancedCriteria;
    }

    public AdvancedProgramInterruptionCriteria getAdvancedProgramInterruptionCriteria() {
        return this.fAdvancedCriteria;
    }

    @Override
    protected HttpMessage[] doProfileActivation(Connection connection) throws Exception {
        String userId = connection.getUserId();
        if (this.getOwnerId() != null) {
            if (!connection.isRecordingCollectorSupported()) {
                ProfilePlugin.getTrace().trace("/REST", String.format("DPS version %.1f doesn't support impersonation, user ID %s will be used instead of %s. v1.9+ required for impersonation.", connection.getAPIVersion(), userId.toUpperCase(), this.getOwnerId().toUpperCase()));
            } else {
                userId = this.getOwnerId();
            }
        }
        boolean usingDefaultUserId = false;
        AdditionalCICSFilters cicsFilters = this.getAdditionalCICSFilters();
        if (cicsFilters != null && cicsFilters.getUserID().equalsIgnoreCase("&USERID")) {
            usingDefaultUserId = true;
            this.getAdditionalCICSFilters().setUserID(ConnectionUtilities.uppercaseUserID(userId).trim());
        }
        HttpRequestBase request = null;
        HttpResponse response = null;
        try {
            request = DebugProfileRestClientV1.buildRequest_DeleteRemoteDTCNProfile(this.fRegion, userId, connection);
            response = DebugProfileRestClientV1.executeRequest(request, connection);
            DebugProfileRestClientV1_DTCN_JSON profileJSON = new DebugProfileRestClientV1_DTCN_JSON(this);
            request = DebugProfileRestClientV1.buildRequest_CreateRemoteDTCNProfile(this.fRegion, userId, profileJSON, connection);
            if (this.getOwnerId() != null && connection.isRecordingCollectorSupported()) {
                DebugProfileRestClientV1.addImpersonateUserHeader((AbstractHttpMessage)request, this.getOwnerId());
            }
            response = DebugProfileRestClientV1.executeRequest(request, connection);
        }
        finally {
            if (usingDefaultUserId) {
                this.getAdditionalCICSFilters().setUserID("&USERID");
            }
        }
        return new HttpMessage[]{request, response};
    }

    @Override
    protected void doBackLevelProfileActivation(Connection connection, int mode) throws Exception {
        BackLevelDebugProfileClient.Status statusResult = BackLevelDebugProfileClient.checkPortandSecureMode(connection, this.getPort());
        if (statusResult == BackLevelDebugProfileClient.Status.INVALID_PORT) {
            this.resetStateUnknown();
            throw new DebugProfileException(NLS.bind((String)ProfileMessages.CRRDG9150, (Object)String.valueOf(this.getPort())));
        }
        if (statusResult == BackLevelDebugProfileClient.Status.ERROR_SECURE_MODE) {
            this.resetStateUnknown();
            throw new DebugProfileException(ProfileMessages.CRRDG9153);
        }
        HttpURLConnection httpURLConnection = null;
        boolean usingDefaultUserId = false;
        AdditionalCICSFilters cicsFilters = this.getAdditionalCICSFilters();
        if (cicsFilters != null && cicsFilters.getUserID().equalsIgnoreCase("&USERID")) {
            usingDefaultUserId = true;
            this.getAdditionalCICSFilters().setUserID(ConnectionUtilities.uppercaseUserID(connection.getUserId()).trim());
        }
        try {
            try {
                BackLevelDebugProfileClient.buildRequest_DeleteRemoteDTCNProfile(connection, this.getPort());
                String profileXML = BackLevelDebugProfileClient.backLevelGetDTCNXML(this);
                httpURLConnection = BackLevelDebugProfileClient.buildRequest_CreateRemoteDTCNProfile(profileXML, connection, this.getPort());
                String responseMessage = httpURLConnection.getResponseMessage();
                if (httpURLConnection.getResponseCode() == 400) {
                    this.resetStateUnknown();
                    if (!this.handleBadRequest(responseMessage)) {
                        throw new BackLevelAPIServerException(httpURLConnection.getRequestMethod() + " " + String.valueOf(httpURLConnection.getURL()), "http" + httpURLConnection.getResponseCode() + " " + responseMessage);
                    }
                } else if (httpURLConnection.getResponseCode() != 201) {
                    this.resetStateUnknown();
                    throw new BackLevelAPIServerException(httpURLConnection.getRequestMethod() + " " + String.valueOf(httpURLConnection.getURL()), "http" + httpURLConnection.getResponseCode() + " " + responseMessage);
                }
            }
            catch (IOException e) {
                this.resetStateUnknown();
                if (httpURLConnection == null) {
                    throw new DebugProfileException(NLS.bind((String)ProfileMessages.CRRDG9111, (Object)this.getConnectionName()));
                }
                throw new BackLevelAPIServerException(httpURLConnection.getRequestMethod() + " " + String.valueOf(httpURLConnection.getURL()), e.getMessage());
            }
        }
        finally {
            if (usingDefaultUserId) {
                this.getAdditionalCICSFilters().setUserID("&USERID");
            }
        }
    }

    @Override
    protected HttpMessage[] doProfileDelete(Connection connection) throws Exception {
        String userId = connection.getUserId();
        if (this.getOwnerId() != null && connection.isRecordingCollectorSupported()) {
            userId = this.getOwnerId();
        }
        HttpRequestBase request = null;
        HttpResponse response = null;
        request = DebugProfileRestClientV1.buildRequest_DeleteRemoteDTCNProfile(this.fRegion, userId, connection);
        response = DebugProfileRestClientV1.executeRequest(request, connection);
        return new HttpMessage[]{request, response};
    }

    @Override
    protected void doBackLevelProfileDelete(Connection connection) throws Exception {
        BackLevelDebugProfileClient.Status statusResult = BackLevelDebugProfileClient.checkPortandSecureMode(connection, this.getPort());
        if (statusResult == BackLevelDebugProfileClient.Status.INVALID_PORT) {
            this.resetStateUnknown();
            LogUtils.log(2, "Delete remote profile:" + NLS.bind((String)ProfileMessages.CRRDG9150, (Object)String.valueOf(this.getPort())));
            return;
        }
        if (statusResult == BackLevelDebugProfileClient.Status.ERROR_SECURE_MODE) {
            this.resetStateUnknown();
            throw new DebugProfileException(ProfileMessages.CRRDG9153);
        }
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = BackLevelDebugProfileClient.buildRequest_DeleteRemoteDTCNProfile(connection, this.getPort());
            if (httpURLConnection.getResponseCode() != 200 && httpURLConnection.getResponseCode() != 404) {
                this.resetStateUnknown();
                throw new BackLevelAPIServerException(httpURLConnection.getRequestMethod() + " " + String.valueOf(httpURLConnection.getURL()), "http" + httpURLConnection.getResponseCode() + " " + httpURLConnection.getResponseMessage());
            }
        }
        catch (IOException e) {
            this.resetStateUnknown();
            if (httpURLConnection == null) {
                throw new DebugProfileException(NLS.bind((String)ProfileMessages.CRRDG9111, (Object)this.getConnectionName()));
            }
            throw new BackLevelAPIServerException(httpURLConnection.getRequestMethod() + " " + String.valueOf(httpURLConnection.getURL()), e.getMessage());
        }
    }

    @Override
    protected boolean doValidateProfile() {
        return (this.fRegion != null && !this.fRegion.isEmpty() || this.fPort > -1) && (this.fTransaction != null && !this.fTransaction.isEmpty() || this.fAdditionalCICSFilters != null && !this.fAdditionalCICSFilters.isEmpty() || this.fLoadModulePairs != null && !this.fLoadModulePairs.isEmpty());
    }

    @Override
    protected List<String> getProfileIssues() {
        ArrayList<String> issues = new ArrayList<String>();
        if (this.fPort <= 0 && (this.getRegion() == null || this.getRegion().isEmpty())) {
            issues.add(ProfileMessages.CRRDG9103);
        }
        if (!(this.fTransaction != null && !this.fTransaction.isEmpty() || this.fAdditionalCICSFilters != null && !this.fAdditionalCICSFilters.isEmpty() || this.fLoadModulePairs != null && !this.fLoadModulePairs.isEmpty())) {
            issues.add(ProfileMessages.CRRDG9104);
        }
        return issues;
    }

    @Override
    protected boolean isBackLevelRequired() {
        return this.getRegion() == null || this.getRegion().isEmpty();
    }

    @Override
    protected boolean handleActivateResponse(int statusCode, String responseMessage) throws DebugProfileException {
        switch (statusCode) {
            case 400: {
                return this.handleBadRequest(responseMessage);
            }
            case 500: {
                return this.handleInternalError(responseMessage);
            }
        }
        return false;
    }

    private boolean handleInternalError(String responseMessage) throws DebugProfileException {
        String error;
        if (responseMessage.startsWith("EQAPS1000E") || responseMessage.contains("EDC8128I")) {
            throw new DebugProfileException(NLS.bind((String)ProfileMessages.CRRDG9146, (Object)this.getRegion()));
        }
        if (responseMessage.startsWith("EQAPS")) {
            throw new DebugProfileException(responseMessage);
        }
        if (!responseMessage.startsWith("{")) {
            return false;
        }
        JsonElement element = JsonParser.parseString((String)responseMessage);
        if (element.getAsJsonObject().get("error") != null && (error = element.getAsJsonObject().get("error").getAsString()).contains("EDC8128I")) {
            throw new DebugProfileException(NLS.bind((String)ProfileMessages.CRRDG9146, (Object)this.getRegion()));
        }
        JsonElement msgElement = element.getAsJsonObject().get("messageid");
        if (msgElement != null) {
            if (msgElement.getAsString().equals("EQAPS1000E")) {
                throw new DebugProfileException(NLS.bind((String)ProfileMessages.CRRDG9146, (Object)this.getRegion()));
            }
            throw new DebugProfileException(msgElement.getAsString() + " " + element.getAsJsonObject().get("error").getAsString());
        }
        return false;
    }

    protected boolean handleBadRequest(String responseMessage) throws DebugProfileException {
        if ("Site_Require_Terminal_ID_Specified".equals(responseMessage)) {
            throw new DebugProfileException(ProfileMessages.CRRDG9106);
        }
        if ("Site_Require_At_Least_One_Load_Mod_Name_Specified".equals(responseMessage)) {
            throw new DebugProfileException(ProfileMessages.CRRDG9118);
        }
        if ("Site_Require_Transaction_ID_Specified".equals(responseMessage)) {
            throw new DebugProfileException(ProfileMessages.CRRDG9124);
        }
        if ("Site_Require_At_Least_One_Program_Name_Specified".equals(responseMessage)) {
            throw new DebugProfileException(ProfileMessages.CRRDG9125);
        }
        if ("Site_Require_User_ID_Specified".equals(responseMessage)) {
            throw new DebugProfileException(ProfileMessages.CRRDG9126);
        }
        if ("Site_Require_NetName_Specified".equals(responseMessage)) {
            throw new DebugProfileException(ProfileMessages.CRRDG9127);
        }
        if ("Site_Require_Client_IP_Specified".equals(responseMessage)) {
            throw new DebugProfileException(ProfileMessages.CRRDG9128);
        }
        return false;
    }

    @Override
    protected HttpMessage[] doProfileSynchronization(Connection connection) throws Exception {
        DebugProfileRestClientV1_DTCN_JSON profileJSON = new DebugProfileRestClientV1_DTCN_JSON(this);
        HttpRequestBase request = DebugProfileRestClientV1.buildRequest_UpdateRemoteDTCNProfile(this.fRegion, connection.getUserId(), profileJSON, connection);
        HttpResponse response = DebugProfileRestClientV1.executeRequest(request, connection);
        return new HttpMessage[]{request, response};
    }

    @Override
    protected boolean checkForGenericProfile() {
        boolean isUserIDGeneric = this.fAdditionalCICSFilters.getUserID() == null || this.fAdditionalCICSFilters.getUserID().trim().isEmpty() || this.fAdditionalCICSFilters.getUserID().trim().equals("*");
        boolean isTransactionGeneric = this.fTransaction == null || this.fTransaction.trim().isEmpty() || this.fTransaction.equals("*");
        boolean isIPGeneric = this.fAdditionalCICSFilters.getIP() == null || this.fAdditionalCICSFilters.getIP().trim().isEmpty();
        boolean isTerminalGeneric = this.fAdditionalCICSFilters.getTerminalID() == null || this.fAdditionalCICSFilters.getTerminalID().trim().isEmpty();
        boolean isLoadModuleProgramGeneric = this.isGenericLoadModulePairs();
        return ExtendedSupportUtillities.checkForDTCNGenericProfile(isUserIDGeneric, isTransactionGeneric, isIPGeneric, isTerminalGeneric, isLoadModuleProgramGeneric);
    }

    public static class AdditionalCICSFilters
    implements IAdditionalCICSFilters {
        private String fUserID;
        private String fNetName;
        private String fIP;
        private String fCICS_SYSID;
        private String fTerminalID;

        public AdditionalCICSFilters(String userID, String netName, String ip, String cicsSysID, String terminalID) {
            this.fUserID = userID;
            this.fNetName = netName;
            this.fIP = ip;
            this.fCICS_SYSID = cicsSysID;
            this.fTerminalID = terminalID;
        }

        public String getUserID() {
            return this.fUserID;
        }

        @Override
        public void setUserID(String userId) {
            this.fUserID = userId;
        }

        public String getNetName() {
            return this.fNetName;
        }

        public String getIP() {
            return this.fIP;
        }

        public String getCICSSysID() {
            return this.fCICS_SYSID;
        }

        public String getTerminalID() {
            return this.fTerminalID;
        }

        public boolean isEmpty() {
            return !(this.fUserID != null && !this.fUserID.isEmpty() || this.fNetName != null && !this.fNetName.isEmpty() || this.fIP != null && !this.fIP.isEmpty() || this.fCICS_SYSID != null && !this.fCICS_SYSID.isEmpty() || this.fTerminalID != null && !this.fTerminalID.isEmpty());
        }
    }

    public static class AdvancedProgramInterruptionCriteria {
        private ContainerInfo fContainerInfo;
        private ApplicationInfo fApplicationInfo;
        private CommAreaInfo fCommAreaInfo;
        private boolean fIsURM;

        public AdvancedProgramInterruptionCriteria(ContainerInfo containerInfo, ApplicationInfo applicationInfo, CommAreaInfo commAreaInfo, boolean isURM) {
            this.fContainerInfo = containerInfo;
            this.fApplicationInfo = applicationInfo;
            this.fCommAreaInfo = commAreaInfo;
            this.fIsURM = isURM;
        }

        public ContainerInfo getContainerInfo() {
            return this.fContainerInfo;
        }

        public ApplicationInfo getApplicationInfo() {
            return this.fApplicationInfo;
        }

        public CommAreaInfo getCommAreaInfo() {
            return this.fCommAreaInfo;
        }

        public boolean isUserReplaceableModules() {
            return this.fIsURM;
        }
    }

    public static class ApplicationInfo {
        private String fPlatformName;
        private String fApplicationName;
        private String fOperationName;
        private String fApplicationVersion;

        public ApplicationInfo(String platformName, String applicationName, String operationName, String applicationVersion) {
            this.fPlatformName = platformName;
            this.fApplicationName = applicationName;
            this.fOperationName = operationName;
            this.fApplicationVersion = applicationVersion;
        }

        public String getPlatformName() {
            return this.fPlatformName;
        }

        public String getApplicationName() {
            return this.fApplicationName;
        }

        public String getOperationName() {
            return this.fOperationName;
        }

        public String getApplicationVersion() {
            return this.fApplicationVersion;
        }
    }

    public static class CommAreaInfo {
        private String fOffset;
        private String fData;

        public CommAreaInfo(String offset, String data) {
            this.fOffset = offset;
            this.fData = data;
        }

        public String getOffset() {
            return this.fOffset;
        }

        public String getData() {
            return this.fData;
        }
    }

    public static class ContainerInfo {
        private String fName;
        private String fOffset;
        private String fData;

        public ContainerInfo(String name, String offset, String data) {
            this.fName = name;
            this.fOffset = offset;
            this.fData = data;
        }

        public String getName() {
            return this.fName;
        }

        public String getOffset() {
            return this.fOffset;
        }

        public String getData() {
            return this.fData;
        }
    }
}

