/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.profile.internal.compatibility;

import com.ibm.debug.pdt.profile.internal.compatibility.DebugCompatibilityMessages;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTSP;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileException;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileUtils;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import java.lang.invoke.CallSite;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.osgi.util.NLS;

public class BackLevelDebugProfile_DTSP_XML
implements IDebugProfileConstants {
    private static final String NM2_TAG = "<NM2>";
    private static final String TST_TAG = "<TST>";
    private static final String RTO_TAG = "<RTO>";
    private static final String EQO_TAG = "<EQO>";
    private static final String IMSID_TAG = "<IID>";
    private static final String IMSTRAN_TAG = "<ITR>";
    private static final String JOB_TAG = "<JBN>";
    private static final String STEP_TAG = "<STN>";

    public static Vector<String> getConfigurationContents(DebugProfileDTSP localProfile) throws DebugProfileException {
        Vector<String> configurationContents = new Vector<String>();
        String rto = "";
        String eqo = "";
        String tstStr = "";
        if (localProfile.getIMSOptions() != null) {
            if (BackLevelDebugProfile_DTSP_XML.getValue(localProfile.getIMSOptions().getSubsystemID()) != null) {
                configurationContents.add(IMSID_TAG + BackLevelDebugProfile_DTSP_XML.getValue(localProfile.getIMSOptions().getSubsystemID()));
            }
            if (BackLevelDebugProfile_DTSP_XML.getValue(localProfile.getIMSOptions().getTransactionID()) != null) {
                configurationContents.add(IMSTRAN_TAG + BackLevelDebugProfile_DTSP_XML.getValue(localProfile.getIMSOptions().getTransactionID()));
            }
        }
        if (localProfile.getJobInfo() != null) {
            if (BackLevelDebugProfile_DTSP_XML.getValue(localProfile.getJobInfo().getJobName()) != null) {
                configurationContents.add(JOB_TAG + BackLevelDebugProfile_DTSP_XML.getValue(localProfile.getJobInfo().getJobName()));
            }
            if (BackLevelDebugProfile_DTSP_XML.getValue(localProfile.getJobInfo().getStepName()) != null) {
                configurationContents.add(STEP_TAG + BackLevelDebugProfile_DTSP_XML.getValue(localProfile.getJobInfo().getStepName()));
            }
        }
        if (localProfile.getDebuggerOptions() != null) {
            if (BackLevelDebugProfile_DTSP_XML.getValue(localProfile.getDebuggerOptions().getEqaOptsFile()) != null) {
                eqo = BackLevelDebugProfile_DTSP_XML.getValue(localProfile.getDebuggerOptions().getEqaOptsFile());
            }
            rto = DebugProfileUtils.getUpdatedLEOptions(localProfile, true);
        }
        tstStr = DebugProfileUtils.getTestRuntimeOption(localProfile);
        Vector<Object> vTST = new Vector<CallSite>();
        if (tstStr != null) {
            if (tstStr.length() > 72) {
                vTST = BackLevelDebugProfile_DTSP_XML.separateOptionsLine(tstStr, TST_TAG);
            } else {
                vTST.add(TST_TAG + tstStr);
            }
        }
        int i = 0;
        while (i < vTST.size()) {
            configurationContents.add((String)vTST.elementAt(i));
            ++i;
        }
        Vector<Object> vRTO = new Vector();
        if (rto != null) {
            if (rto.length() > 72) {
                vRTO = BackLevelDebugProfile_DTSP_XML.separateOptionsLine(rto, RTO_TAG);
            } else if (!rto.trim().equalsIgnoreCase("")) {
                vRTO.add(RTO_TAG + rto);
            }
        }
        int i2 = 0;
        while (i2 < vRTO.size()) {
            configurationContents.add((String)vRTO.elementAt(i2));
            ++i2;
        }
        Vector<Object> vEQO = new Vector();
        if (eqo != null) {
            if (eqo.length() > 72) {
                vEQO = BackLevelDebugProfile_DTSP_XML.separateOptionsLine(eqo, EQO_TAG);
            } else if (!eqo.trim().equalsIgnoreCase("")) {
                vEQO.add(EQO_TAG + eqo);
            }
        }
        int i3 = 0;
        while (i3 < vEQO.size()) {
            configurationContents.add((String)vEQO.elementAt(i3));
            ++i3;
        }
        List<DebugProfile.LoadModulePair> loadModules = localProfile.getLoadModulePairs();
        if (loadModules != null && !loadModules.isEmpty()) {
            for (DebugProfile.LoadModulePair loadModule : loadModules) {
                String loadModuleName = BackLevelDebugProfile_DTSP_XML.getValue(loadModule.getLoadModule());
                String compilationUnitName = BackLevelDebugProfile_DTSP_XML.getValue(loadModule.getCompilationUnit());
                if ((loadModuleName == null || loadModuleName.isEmpty()) && (compilationUnitName == null || compilationUnitName.isEmpty())) continue;
                StringBuilder nm2 = new StringBuilder();
                if (loadModuleName != null) {
                    nm2.append(loadModuleName);
                } else {
                    nm2.append("*");
                }
                nm2.append(",");
                if (compilationUnitName != null) {
                    nm2.append(compilationUnitName);
                } else {
                    nm2.append("*");
                }
                configurationContents.add(NM2_TAG + String.valueOf(nm2));
            }
        }
        return configurationContents;
    }

    private static Vector<String> separateOptionsLine(String tstStr, String tag) throws DebugProfileException {
        Vector<String> vTST = new Vector<String>();
        StringTokenizer st = new StringTokenizer(tstStr, ",", true);
        String curTok = "";
        Object accum = "";
        accum = tag;
        while (st.hasMoreTokens()) {
            curTok = st.nextToken();
            if (((String)accum).length() + curTok.length() > 75) {
                if (curTok.length() > 72) {
                    throw new DebugProfileException(NLS.bind((String)DebugCompatibilityMessages.CRRDG8014, (Object[])new Object[]{tstStr}));
                }
                if (((String)accum).endsWith(",")) {
                    vTST.add((String)accum);
                    accum = tag;
                    accum = (String)accum + curTok;
                    continue;
                }
                if (((String)accum).length() >= 79 || !curTok.equalsIgnoreCase(",")) continue;
                accum = (String)accum + curTok;
                vTST.add((String)accum);
                accum = tag;
                continue;
            }
            accum = (String)accum + curTok;
        }
        if (!((String)accum).equalsIgnoreCase(tag)) {
            vTST.add((String)accum);
        }
        return vTST;
    }

    private static String getValue(String fieldValue) {
        if (fieldValue == null || fieldValue.trim().equalsIgnoreCase("")) {
            return null;
        }
        return fieldValue;
    }
}

