/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.profile.internal.compatibility;

import com.ibm.debug.pdt.profile.internal.LogUtils;
import com.ibm.debug.pdt.profile.internal.ProfilePlugin;
import com.ibm.debug.pdt.profile.internal.compatibility.IBackLevelProvider;
import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTCN;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileDTSP;
import com.ibm.debug.pdt.profile.internal.model.DebugProfileException;
import com.ibm.debug.pdt.profile.internal.model.IDebugProfileConstants;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Base64;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class BackLevelDebugProfileClient
implements IDebugProfileConstants {
    private static final String POST = "POST";
    private static final String GET = "GET";
    private static final String PUT = "PUT";
    private static final String DELETE = "DELETE";
    private static final String CLIENTVERSION_0102 = "?clientversion=0102";
    private static final String DTCN = "/dtcn/";
    private static final String HTTPS = "https://";
    private static final String HTTP = "http://";
    private static final IBackLevelProvider fProvider = BackLevelDebugProfileClient.getBackLevelProvider();

    /*
     * Exception decompiling
     */
    private static IBackLevelProvider getBackLevelProvider() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static HttpURLConnection buildRequest_QueryRemoteDTCNProfileForUser(Connection connection, Integer port) throws IOException {
        return BackLevelDebugProfileClient.request(connection, GET, null, port);
    }

    public static HttpURLConnection buildRequest_CreateRemoteDTCNProfile(String profileXML, Connection connection, Integer port) throws IOException {
        return BackLevelDebugProfileClient.request(connection, PUT, profileXML, port);
    }

    public static HttpURLConnection buildRequest_UpdateRemoteDTCNProfile(String profileXML, Connection connection, Integer port) throws IOException {
        return BackLevelDebugProfileClient.request(connection, POST, profileXML, port);
    }

    public static HttpURLConnection buildRequest_DeleteRemoteDTCNProfile(Connection connection, Integer port) throws IOException {
        return BackLevelDebugProfileClient.request(connection, DELETE, null, port);
    }

    public static Status checkPortandSecureMode(Connection connection, Integer port) {
        if (fProvider != null) {
            return fProvider.backLevelCheckPortandSecureMode(connection, port);
        }
        return Status.INVALID_PORT;
    }

    public static HttpURLConnection request(Connection connection, String mode, String profileXML, Integer port) throws IOException {
        URL url = BackLevelDebugProfileClient.getURL(connection, port);
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        if (connection.isSecured() && httpURLConnection instanceof HttpsURLConnection) {
            SSLSocketFactory factory;
            SSLSocketFactory sSLSocketFactory = factory = fProvider == null ? null : fProvider.getBacklevelSSLSocketFactory(connection.getConnectionName(), connection.getHostName());
            if (factory != null) {
                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(factory);
            }
        }
        if (BackLevelDebugProfileClient.getBasicAuth(connection) != null) {
            httpURLConnection.setRequestProperty("Authorization", "Basic " + BackLevelDebugProfileClient.getBasicAuth(connection));
        }
        httpURLConnection.setRequestMethod(mode);
        httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        httpURLConnection.setRequestProperty("Content-Language", "en-US");
        if (profileXML != null) {
            httpURLConnection.setRequestProperty("Content-Length", Integer.toString(profileXML.length()));
        }
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setUseCaches(false);
        ProfilePlugin.getTrace().trace("/REST", "\n>> " + httpURLConnection.getRequestMethod() + "    " + httpURLConnection.getURL().toString());
        try (FilterOutputStream os = null;){
            if (profileXML != null) {
                os = new DataOutputStream(httpURLConnection.getOutputStream());
                ((DataOutputStream)os).writeBytes(profileXML);
                ((DataOutputStream)os).flush();
            }
        }
        ProfilePlugin.getTrace().trace("/REST", "\n<< " + httpURLConnection.getResponseCode() + "   " + httpURLConnection.getResponseMessage());
        return httpURLConnection;
    }

    private static URL getURL(Connection connection, Integer port) throws MalformedURLException {
        URL url = null;
        if (connection.getHostName() != null && connection.getUserId() != null) {
            String protocol = HTTP;
            if (connection.isSecured()) {
                protocol = HTTPS;
            }
            String uri = protocol + connection.getHostName() + ":" + String.valueOf(port) + DTCN + connection.getUserId() + CLIENTVERSION_0102;
            url = new URL(uri);
        } else {
            LogUtils.log("unable to find hostname or username in connection");
        }
        return url;
    }

    private static String getBasicAuth(Connection connection) {
        Object basicAuth = null;
        if (connection.getHostName() != null && connection.getUserId() != null && connection.getUserPassword() != null && connection.getUserPassword().length > 0) {
            basicAuth = connection.getUserId() + ":" + String.valueOf(connection.getUserPassword());
            byte[] byteBasicAuth = ((String)basicAuth).getBytes(Charset.defaultCharset());
            basicAuth = new String(Base64.getEncoder().encode(byteBasicAuth), Charset.defaultCharset());
        }
        return basicAuth;
    }

    public static boolean writeDebugProfile(DebugProfileDTSP localProfile) throws DebugProfileException {
        if (fProvider != null) {
            return fProvider.backLevelWriteDebugProfile(localProfile);
        }
        return false;
    }

    public static boolean deleteEqauoptsFile(DebugProfileDTSP localProfile) throws DebugProfileException {
        if (fProvider != null) {
            return fProvider.backLevelDeleteEqauoptsFile(localProfile);
        }
        return false;
    }

    public static boolean isBackLevelSupported() {
        return fProvider != null;
    }

    public static String backLevelGetDTCNXML(DebugProfileDTCN profile) throws IOException {
        if (fProvider != null) {
            return fProvider.backLevelGetDTCNXML(profile);
        }
        return null;
    }

    public static enum Status {
        UNSECURE_MODE,
        INVALID_PORT,
        ERROR_SECURE_MODE,
        SUCCESS;

    }
}

