/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.playback.internal;

import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.model.DebugEngine;
import com.ibm.debug.pdt.internal.core.model.DebugEngineCommandLogResponseEvent;
import com.ibm.debug.pdt.internal.core.model.DebugEngineTerminatedEvent;
import com.ibm.debug.pdt.internal.core.model.ErrorOccurredEvent;
import com.ibm.debug.pdt.internal.core.model.IDebugEngineEventListener;
import com.ibm.debug.pdt.internal.core.model.IModelEventListener;
import com.ibm.debug.pdt.internal.core.model.MessageReceivedEvent;
import com.ibm.debug.pdt.internal.core.model.ModelStateReadyEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessAddedEvent;
import com.ibm.debug.pdt.internal.epdc.ERepPlaybackControl;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class PlaybackStateCache
implements IDebugEngineEventListener,
IDebugEventSetListener {
    private static final int INTERESTED_EVENTS_MASK = 7;
    private static final Map<String, PlaybackState> fEngineMap = new HashMap<String, PlaybackState>();
    private static final PlaybackStateCache fInstance = new PlaybackStateCache();

    public static boolean isMoveBackAllowed(DebugEngine debugEngine) {
        if (debugEngine.getDebugTarget() instanceof PDTDebugTarget) {
            String id = ((PDTDebugTarget)debugEngine.getDebugTarget()).getId();
            PlaybackState state = fEngineMap.get(id);
            return state != null && state.fMoveBackAllowed;
        }
        return false;
    }

    public static boolean isMoveForwardAllowed(DebugEngine debugEngine) {
        if (debugEngine.getDebugTarget() instanceof PDTDebugTarget) {
            String id = ((PDTDebugTarget)debugEngine.getDebugTarget()).getId();
            PlaybackState state = fEngineMap.get(id);
            return state != null && state.fMoveForwardAllowed;
        }
        return false;
    }

    public static Boolean isPlaybackActive(DebugEngine debugEngine) {
        if (debugEngine.getDebugTarget() instanceof PDTDebugTarget) {
            String id = ((PDTDebugTarget)debugEngine.getDebugTarget()).getId();
            PlaybackState state = fEngineMap.get(id);
            if (state != null) {
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isResumeAllowed(DebugEngine debugEngine) {
        if (debugEngine.getDebugTarget() instanceof PDTDebugTarget) {
            String id = ((PDTDebugTarget)debugEngine.getDebugTarget()).getId();
            PlaybackState state = fEngineMap.get(id);
            return state != null && state.fResumeAllowed;
        }
        return false;
    }

    public static void playbackRecordingStarted(DebugEngine debugEngine) {
        if (debugEngine.getDebugTarget() instanceof PDTDebugTarget) {
            String id = ((PDTDebugTarget)debugEngine.getDebugTarget()).getId();
            PlaybackState state = new PlaybackState();
            fEngineMap.put(id, state);
            debugEngine.addEventListener((IDebugEngineEventListener)fInstance);
        }
    }

    public static void playbackRecordingStopped(DebugEngine debugEngine) {
        if (debugEngine.getDebugTarget() instanceof PDTDebugTarget) {
            String id = ((PDTDebugTarget)debugEngine.getDebugTarget()).getId();
            fEngineMap.remove(id);
            debugEngine.removeListener((IModelEventListener)fInstance);
        }
    }

    public static void updatePlaybackStateFromReply(DebugEngine debugEngine, ERepPlaybackControl reply) {
        String id;
        PlaybackState state;
        if (debugEngine.getDebugTarget() instanceof PDTDebugTarget && (state = fEngineMap.get(id = ((PDTDebugTarget)debugEngine.getDebugTarget()).getId())) != null) {
            state.flag = reply.getFlag();
            state.fMoveForwardAllowed = state.flag != 1 && state.flag != 2;
            state.fMoveBackAllowed = state.flag != 3;
            state.fResumeAllowed = state.flag != 1;
        }
    }

    private PlaybackStateCache() {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void commandLogResponse(DebugEngineCommandLogResponseEvent event) {
    }

    public void debugEngineTerminated(DebugEngineTerminatedEvent event) {
        if (event.getDebugEngine().getDebugTarget() instanceof PDTDebugTarget) {
            String id = ((PDTDebugTarget)event.getDebugEngine().getDebugTarget()).getId();
            fEngineMap.remove(id);
            IWorkbench workbench = PlatformUI.getWorkbench();
            ICommandService commandService = (ICommandService)workbench.getService(ICommandService.class);
            Command command = commandService.getCommand("com.ibm.debug.pdt.playback.command.startrecording");
            State state = command.getState("org.eclipse.ui.commands.toggleState");
            state.setValue((Object)false);
            commandService.refreshElements("com.ibm.debug.pdt.playback.command.startrecording", null);
        }
    }

    public void errorOccurred(ErrorOccurredEvent event) {
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            String id;
            PlaybackState state;
            DebugEngine engine;
            DebugEvent e = events[i];
            if (e.getSource() instanceof PDTDebugElement && (e.getKind() & 7) != 0 && (engine = ((PDTDebugElement)e.getSource()).getDebugEngine()).getDebugTarget() instanceof PDTDebugTarget && (state = fEngineMap.get(id = ((PDTDebugTarget)engine.getDebugTarget()).getId())) != null) {
                state.fMoveBackAllowed = state.flag != 3;
            }
            ++i;
        }
    }

    public void messageReceived(MessageReceivedEvent event) {
    }

    public void modelStateChanged(ModelStateReadyEvent event) {
    }

    public void processAdded(ProcessAddedEvent event) {
    }

    static class PlaybackState {
        public boolean fMoveBackAllowed = false;
        public boolean fMoveForwardAllowed = false;
        public boolean fResumeAllowed = false;
        public int flag;

        PlaybackState() {
        }
    }
}

