/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.persistence;

import com.ibm.debug.pdt.internal.epdc.EStdString;
import com.ibm.debug.pdt.internal.persistence.PersistencePlugin;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.util.Base64Encoder;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class EStdStringConverter
implements Converter {
    private static final String SPECIAL_FORMAT_FIELD = "_specialFormat";
    private static final String LENGTH_FIELD = "_len";
    private static final String BUFFER_FIELD = "_buffer";
    private static final String CACHED_STRING_FIELD = "_string";

    public boolean canConvert(Class clazz) {
        return clazz.equals(EStdString.class);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        EStdString eStdString = (EStdString)value;
        writer.startNode(SPECIAL_FORMAT_FIELD);
        writer.setValue(Boolean.toString(eStdString.isSpecialFormat()));
        writer.endNode();
        writer.startNode(LENGTH_FIELD);
        writer.setValue(Integer.toString(eStdString.getBufferLength()));
        writer.endNode();
        writer.startNode(BUFFER_FIELD);
        Base64Encoder base64 = new Base64Encoder();
        writer.setValue(base64.encode(eStdString.getBuffer()));
        writer.endNode();
        if (eStdString.isSpecialFormat()) {
            writer.startNode(CACHED_STRING_FIELD);
            writer.setValue(eStdString.getCachedString());
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        boolean specialFormat = false;
        int length = 0;
        byte[] buffer = null;
        String cachedString = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nodeName = reader.getNodeName();
            if (nodeName.equals(SPECIAL_FORMAT_FIELD)) {
                specialFormat = Boolean.parseBoolean(reader.getValue());
            } else if (nodeName.equals(LENGTH_FIELD)) {
                try {
                    length = Integer.parseInt(reader.getValue());
                }
                catch (NumberFormatException nfe) {
                    PersistencePlugin.log("Element <_len> has an invalid value.", nfe);
                    return null;
                }
            } else if (nodeName.equals(BUFFER_FIELD)) {
                Base64Encoder base64 = new Base64Encoder();
                buffer = base64.decode(reader.getValue());
            } else if (nodeName.equals(CACHED_STRING_FIELD) && specialFormat) {
                cachedString = reader.getValue();
            }
            reader.moveUp();
        }
        return new EStdString(specialFormat, length, buffer, cachedString);
    }
}

