/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.migrator;

import com.ibm.debug.internal.epdc.ERepGetExceptions;
import com.ibm.debug.internal.pdt.model.Breakpoint;
import com.ibm.debug.internal.pdt.model.ExpressionBase;
import com.ibm.debug.internal.pdt.model.Language;
import com.ibm.debug.pdt.internal.core.IDebuggerProfileMigrator;
import com.ibm.debug.pdt.internal.core.model.DebugModelObject;
import com.ibm.debug.pdt.internal.core.model.DebuggeeException;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ModelPackageAccessHelper;
import com.ibm.debug.pdt.migrator.MigratorUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.TreeMap;

public class DebuggeeProcessProfile20060529Converter
extends DebuggeeProcess.ProgramProfile
implements IDebuggerProfileMigrator {
    static final int VERSION = 20060529;
    private TreeMap<Integer, Breakpoint> fOldBreakpoints;
    private TreeMap<Integer, ExpressionBase> fOldMonitoredExpressions;
    private com.ibm.debug.internal.pdt.model.DebuggeeException[] fOldExceptions;
    private HashMap<Integer, Language> fOldLanguages;

    public DebuggeeProcessProfile20060529Converter() {
        super(20060529);
    }

    public boolean restoreFromOldProfile(DebugModelObject restoreTo, String profileName, int restoreFlags) throws Exception {
        this.read(MigratorUtils.toOldProfileName1(profileName));
        return this.restore((DebuggeeProcess)restoreTo, restoreFlags);
    }

    protected void readObjects(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.fOldBreakpoints = (TreeMap)in.readObject();
        this.fOldMonitoredExpressions = (TreeMap)in.readObject();
        this.fOldExceptions = (com.ibm.debug.internal.pdt.model.DebuggeeException[])in.readObject();
        this.fOldLanguages = (HashMap)in.readObject();
        this.fHeapCheckEnabled = in.readBoolean();
    }

    protected boolean restoreBreakpoints(DebuggeeProcess to) {
        int size;
        if (this.fOldBreakpoints == null || (size = this.fOldBreakpoints.size()) == 0) {
            return true;
        }
        boolean bpok = true;
        Breakpoint[] breakpointArray = this.fOldBreakpoints.values().toArray(new Breakpoint[size]);
        int n = breakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Breakpoint bp = breakpointArray[n2];
            if (bp != null) {
                bpok = bpok ? bp.restore(to) : false;
            }
            ++n2;
        }
        return bpok;
    }

    protected boolean restoreLanguages(DebuggeeProcess to) {
        int size;
        if (this.fOldLanguages == null || (size = this.fOldLanguages.size()) == 0) {
            return true;
        }
        boolean lok = true;
        Language[] languageArray = this.fOldLanguages.values().toArray(new Language[size]);
        int n = languageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language lang = languageArray[n2];
            try {
                lang.restore(to);
            }
            catch (EngineRequestException e) {
                lok = false;
            }
            ++n2;
        }
        return lok;
    }

    protected boolean restoreMonitoredExpressions(DebuggeeProcess to) {
        int size;
        if (this.fOldMonitoredExpressions == null || (size = this.fOldMonitoredExpressions.size()) == 0) {
            return true;
        }
        boolean meok = true;
        ExpressionBase[] expressionBaseArray = this.fOldMonitoredExpressions.values().toArray(new ExpressionBase[size]);
        int n = expressionBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExpressionBase eb = expressionBaseArray[n2];
            if (eb != null) {
                try {
                    eb.restore(to);
                }
                catch (EngineRequestException e) {
                    meok = false;
                }
            }
            ++n2;
        }
        return meok;
    }

    protected boolean restoreExceptions(DebuggeeProcess to) {
        if (this.fOldExceptions == null || this.fOldExceptions.length == 0) {
            return true;
        }
        boolean eok = true;
        DebuggeeException[] newExceptions = new DebuggeeException[this.fOldExceptions.length];
        int i = 0;
        while (i < this.fOldExceptions.length) {
            com.ibm.debug.internal.pdt.model.DebuggeeException cur = this.fOldExceptions[i];
            ERepGetExceptions rep = cur.getException();
            newExceptions[i] = ModelPackageAccessHelper.createDebuggeeException(cur.getCurrentState(), cur.getDefaultState(), cur.getPendingState(), rep.getExceptionStatus(), rep.getExceptionName(), to);
            ++i;
        }
        ModelPackageAccessHelper.setEngineDebuggeeExceptions(to.getDebugEngine(), newExceptions);
        try {
            to.getDebugEngine().changeExceptionStatus();
        }
        catch (EngineRequestException e1) {
            eok = false;
        }
        return eok;
    }

    public void deleteAllSavedDebuggerProfiles() {
        MigratorUtils.deleteOldProfiles1();
    }
}

