/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.debug.internal;

import com.ibm.debug.pdt.internal.core.util.PDTLicenseCheck;
import com.ibm.debug.pdt.launch.internal.zpicl.Activator;
import com.ibm.etools.rdz.license.RDzLicenseRequest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

public class DebugProducCheckUtils {
    private static final String IDZ_ADV = "com.ibm.debug.idz.integrations";
    private static final String DEBUG = "com.ibm.debug.pdt.launch.zpicl";
    public static final String PRODUCT_ZDEBUG = "com.ibm.debug.pdt.zdebug";
    private static final String PLUGIN_VERSION = "1.0.0";
    public static final String PRODUCT_IDZ = "com.ibm.rational.developer.systemz.product.ide";
    private static final String IDZ_PLUGIN = "com.ibm.debug.pdt.idz.launches.ims.isolation";
    private static boolean IDZ_license_checked = false;
    private static boolean IDZ_license_valid = false;
    private static boolean IDZ_adv_license_checked = false;
    private static boolean IDZ_adv_license_valid = false;

    public static boolean isStandaloneDebug() {
        String productID = Platform.getProduct().getId();
        Bundle enginePlugin = Platform.getBundle((String)"com.ibm.zdebug.product");
        Bundle idzPlugin = Platform.getBundle((String)IDZ_PLUGIN);
        boolean imInstall = PRODUCT_ZDEBUG.equals(productID);
        return imInstall || enginePlugin != null && idzPlugin == null;
    }

    public static boolean isIDz() {
        if (Platform.getProduct() == null) {
            return false;
        }
        String productID = Platform.getProduct().getId();
        return PRODUCT_IDZ.equals(productID);
    }

    public static boolean isCodeCoverageLicense(boolean quiet) {
        String productID = Platform.getProduct().getId();
        return PDTLicenseCheck.isLicenceAvailable((short)10, (short)13, (short)-1, (boolean)quiet, (String)productID, (String)"coverage");
    }

    public static boolean isCodeCoverageLicense() {
        return DebugProducCheckUtils.isCodeCoverageLicense(false);
    }

    public static boolean isIDzAdvancedLicense(boolean quiet) {
        if (!IDZ_adv_license_checked || !quiet) {
            try {
                IDZ_adv_license_valid = RDzLicenseRequest.getRDzLicense((Plugin)Activator.getDefault(), (String)IDZ_ADV, (String)PLUGIN_VERSION, (boolean)quiet);
            }
            catch (CoreException e) {
                IDZ_adv_license_valid = false;
            }
            IDZ_adv_license_checked = true;
        }
        return IDZ_adv_license_valid;
    }

    public static boolean isDebugIDzLicense(boolean quiet) {
        if (!IDZ_license_checked || !quiet) {
            try {
                IDZ_license_valid = RDzLicenseRequest.getRDzLicense((Plugin)Activator.getDefault(), (String)DEBUG, (String)PLUGIN_VERSION, (boolean)quiet);
            }
            catch (CoreException e) {
                IDZ_license_valid = false;
            }
            IDZ_license_checked = true;
        }
        return IDZ_license_valid;
    }
}

