/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.jrebidiengine;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugTrayDialog;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class VisualVariableChangeDialog
extends DebugTrayDialog {
    private ExprNodeBase fVariable;
    private Text fValue;
    private static final String SETTINGSSECTION = PICLDebugPlugin.getPluginID() + ".changeVariableDialog";

    public VisualVariableChangeDialog(Shell parentShell, ExprNodeBase variable) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fVariable = variable;
    }

    protected Control createDialogArea(Composite parent) {
        String varType;
        String varValue;
        String varName;
        Composite comp = (Composite)super.createDialogArea(parent);
        try {
            varName = this.fVariable.getName();
            varValue = this.fVariable.getRawValueString();
            varValue = PICLUtils.getVisualTextDisplayString((String)varValue);
            varValue = PICLUtils.getNullFreeDisplayString((String)varValue);
            varType = this.fVariable.getReferenceTypeName();
        }
        catch (DebugException e1) {
            varName = "*error*";
            varValue = "*error*";
            varType = "*error*";
        }
        GridLayout gl = new GridLayout(4, false);
        comp.setLayout((Layout)gl);
        Label l = new Label(comp, 0);
        l.setText(PICLLabels.ChangeVariableDialog_variableName);
        GridData gd = new GridData();
        gd.horizontalAlignment = 3;
        l.setLayoutData((Object)gd);
        l = new Label(comp, 0);
        if (varType != null) {
            l.setText(varType + " " + varName);
        } else {
            l.setText(varName);
        }
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 4;
        l.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 4;
        gd.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.fValue = PICLDebugPlugin.getEditWidgetFactory().getTextField(comp, 2306);
        this.fValue.setLayoutData((Object)gd);
        this.fValue.setText(varValue);
        this.updateDialog();
        this.fValue.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                char keyChar = e.character;
                if (keyChar == '\r') {
                    String crlfValue = VisualVariableChangeDialog.this.fValue.getText();
                    String lineDelimiter = System.getProperty("line.separator");
                    if (lineDelimiter == null) {
                        lineDelimiter = "\r\n";
                    }
                    crlfValue = crlfValue.replaceAll(lineDelimiter, "");
                    VisualVariableChangeDialog.this.fValue.setText(crlfValue);
                    VisualVariableChangeDialog.this.okPressed();
                } else {
                    VisualVariableChangeDialog.this.updateDialog();
                }
            }

            public void keyReleased(KeyEvent e) {
                VisualVariableChangeDialog.this.updateDialog();
            }
        });
        this.fValue.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                VisualVariableChangeDialog.this.updateDialog();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        Dialog.applyDialogFont((Control)parent);
        return comp;
    }

    protected void updateDialog() {
    }

    protected void okPressed() {
        try {
            String newValue = this.fValue.getText();
            newValue = PICLUtils.postProcessVisualTextEditString((String)newValue);
            this.fVariable.setRawValue(newValue);
        }
        catch (DebugException e) {
            PICLDebugPlugin.showMessageDialog((Shell)this.getShell(), (int)1, (String)e.getMessage(), (boolean)false);
        }
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(PICLLabels.ChangeVariableDialog_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, PICLUtils.getHelpResourceString((String)"change_variable_dialog"));
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = PICLDebugPlugin.getInstance().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGSSECTION);
        if (section == null) {
            section = settings.addNewSection(SETTINGSSECTION);
        }
        return section;
    }
}

