/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.jrebidiengine;

import com.ibm.debug.pdt.internal.core.util.IBIDIEngine;
import com.ibm.etools.icerse.universal.bidiTools.bdlayout.ArabicOptionSet;
import com.ibm.etools.icerse.universal.bidiTools.bdlayout.BidiFlag;
import com.ibm.etools.icerse.universal.bidiTools.bdlayout.BidiFlagSet;
import com.ibm.etools.icerse.universal.bidiTools.bdlayout.BidiText;
import com.ibm.etools.icerse.universal.bidiTools.bdlayout.BidiTransform;
import com.ibm.etools.icerse.universal.bidiTools.smartlogical.BidiSmartLogicalTransform;

public class IBMJREBIDIEngine
implements IBIDIEngine {
    private static BidiFlagSet logicalFlagSet = new BidiFlagSet(BidiFlag.ORIENTATION_LTR, BidiFlag.TYPE_IMPLICIT, BidiFlag.SWAP_YES, BidiFlag.TEXT_NOMINAL, BidiFlag.NUMERALS_NOMINAL);
    private static BidiFlagSet visualFlagSet = new BidiFlagSet(BidiFlag.ORIENTATION_LTR, BidiFlag.TYPE_VISUAL, BidiFlag.SWAP_NO, BidiFlag.TEXT_SHAPED, BidiFlag.NUMERALS_CONTEXTUAL);

    public String convertLogicalToVisual(String inputString) {
        BidiText src = new BidiText(logicalFlagSet, inputString);
        BidiTransform transform = new BidiTransform();
        transform.flags = visualFlagSet;
        transform.options = new ArabicOptionSet();
        transform.roundTrip = true;
        transform.wordBreak = false;
        transform.removeMarkers = true;
        BidiText dest = src.transform(transform);
        String outputString = dest.toString();
        return outputString;
    }

    public String convertVisualToLogical(String inputString, boolean expandLamAlefs) {
        String outputString = inputString;
        BidiSmartLogicalTransform smartTransform = new BidiSmartLogicalTransform();
        smartTransform.setOrdering('V');
        outputString = smartTransform.transform(inputString);
        if (expandLamAlefs) {
            outputString = this.expandLamAlefsForDisplay(outputString);
        }
        return outputString;
    }

    public String expandLamAlefsForDisplay(String value) {
        value = value.replaceAll("\ufef5", "\u0644\u0622");
        value = value.replaceAll("\ufef6", "\u0644\u0622");
        value = value.replaceAll("\ufef7", "\u0644\u0623");
        value = value.replaceAll("\ufef8", "\u0644\u0623");
        value = value.replaceAll("\ufef9", "\u0644\u0625");
        value = value.replaceAll("\ufefa", "\u0644\u0625");
        value = value.replaceAll("\ufefb", "\u0644\u0627");
        value = value.replaceAll("\ufefc", "\u0644\u0627");
        return value;
    }
}

