/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.jrebidiengine;

import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.util.DefaultInlineVariableTreeEditor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BIDIInlineVariableTreeEditor
extends DefaultInlineVariableTreeEditor {
    protected Text createTextField(Composite composite) {
        int textStyles = 16388;
        if (SWT.getPlatform().equals("win32")) {
            textStyles |= 0x800;
        }
        return PICLDebugPlugin.getEditWidgetFactory().getTextField(composite, textStyles);
    }

    protected String getValueDisplayText(IVariable variable) throws DebugException {
        if (variable instanceof ExprNodeBase) {
            String valueString = ((ExprNodeBase)variable).getRawValueString();
            valueString = PICLUtils.getVisualTextDisplayString((String)valueString);
            valueString = PICLUtils.getNullFreeDisplayString((String)valueString);
            return valueString;
        }
        return super.getValueDisplayText(variable);
    }

    protected void saveChangesAndCleanup(IVariable variable) {
        String newValue = this.fEditorText.getText();
        try {
            if (variable instanceof ExprNodeBase) {
                ExprNodeBase nodeVar = (ExprNodeBase)variable;
                if (!nodeVar.getRawValueString().equals(newValue)) {
                    nodeVar.setRawValue(newValue);
                }
            } else {
                super.saveChangesAndCleanup(variable);
            }
        }
        catch (DebugException de) {
            PICLDebugPlugin.showMessageDialog((Shell)this.fComposite.getShell(), (int)1, (String)de.getMessage(), (boolean)false);
        }
        catch (Exception e) {
            PICLUtils.logError((Exception)e);
        }
        this.cleanup();
    }
}

