/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.jrebidiengine;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.FindTextDialog;
import com.ibm.debug.pdt.internal.ui.editor.DebuggerEditor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;

public class BIDIFindTextDialog
extends FindTextDialog {
    private Text expressionInput;
    private Button caseSensitiveButton;
    private DebuggerEditor fEditor;

    public BIDIFindTextDialog(DebuggerEditor editor) {
        super(editor);
        this.setTitle(PICLLabels.FindTextDialog_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)editor.getEditorSite().getShell(), PICLUtils.getHelpResourceString((String)"find_text_dialog"));
        this.fEditor = editor;
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData spec = new GridData();
        spec.grabExcessVerticalSpace = false;
        spec.grabExcessHorizontalSpace = true;
        spec.horizontalAlignment = 4;
        spec.verticalAlignment = 2;
        spec.widthHint = 350;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)spec);
        Label expressionInputLabel = new Label(parent, 0);
        expressionInputLabel.setText(PICLLabels.FindTextDialog_text);
        this.expressionInput = PICLDebugPlugin.getEditWidgetFactory().getTextField(parent, 2048);
        spec = new GridData(768);
        spec.horizontalSpan = 2;
        this.expressionInput.setLayoutData((Object)spec);
        this.caseSensitiveButton = new Button(parent, 32);
        this.caseSensitiveButton.setText(PICLLabels.FindTextDialog_case);
        String editorText = null;
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        if (textSelection != null && textSelection.getText() != null && (editorText = textSelection.getText().trim()) != null && !editorText.equals("") && editorText.indexOf(10) > 0) {
            editorText = editorText.substring(0, editorText.indexOf(10));
        }
        if (editorText != null) {
            this.expressionInput.setText(editorText);
        }
        this.expressionInput.setFocus();
        return parent;
    }

    protected void okPressed() {
        String expression = this.expressionInput.getText();
        BIDIFindTextDialog.addExpressionHistory((String)expression);
        IEditorInput input = this.fEditor.getEditorInput();
        if (!(input instanceof EngineSuppliedViewEditorInput)) {
            if (PICLDebugPlugin.fPDT) {
                PICLUtils.logString((Object)((Object)this), (String)"DebuggerEditor: trying to use debug Find Text dialog on a non-EngineSuppliedView");
            }
            return;
        }
        Location stringLocation = this.fEditor.findString(expression, this.caseSensitiveButton.getSelection(), false);
        if (stringLocation == null) {
            this.updateStatus((IStatus)new Status(1, PICLDebugPlugin.getPluginID(), 0, PICLMessages.FindTextDialog_error1, null));
            return;
        }
        this.fEditor.gotoLine(stringLocation.getLineNumber(), false);
        this.fEditor.hiliteWord(stringLocation.getLineNumber(), stringLocation.getColumnNumber(), expression.length());
        this.setReturnCode(0);
        this.close();
    }
}

