/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.jrebidiengine;

import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.editors.jface.VisualTextCellEditor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.elements.adapters.DefaultVariableCellModifier;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class BIDIColumnEditorFactoryAdapter
implements IElementEditor {
    public static final String BIDI_COLUMN_EDITOR_FACTORY_ADAPTER_ID = "com.ibm.debug.pdt.BIDIVariableColumnEditorFactoryAdapter";
    public static final String BIDI_VARIABLE_COLUMN_EDITOR_ID = "com.ibm.debug.pdt.BIDIVariableColumnEditor";
    private BIDIVariableColumnEditor fEditor = new BIDIVariableColumnEditor();

    public CellEditor getCellEditor(IPresentationContext context, String columnId, Object element, Composite parent) {
        return this.fEditor.getCellEditor(context, columnId, element, parent);
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        return this.fEditor.getCellModifier(context, element);
    }

    public String getColumnEditorId(IPresentationContext context, Object element) {
        return BIDI_COLUMN_EDITOR_FACTORY_ADAPTER_ID;
    }

    public static class BIDIVariableCellModifier
    extends DefaultVariableCellModifier {
        public Object getValue(Object element, String property) {
            if (!"org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_VALUE".equals(property)) {
                return null;
            }
            if (element instanceof ExprNodeBase) {
                String valueString = ((ExprNodeBase)element).getRawValueString();
                valueString = PICLUtils.getVisualTextDisplayString((String)valueString);
                valueString = PICLUtils.getNullFreeDisplayString((String)valueString);
                return valueString;
            }
            return super.getValue(element, property);
        }

        public void modify(Object element, String property, Object value) {
            Object oldValue = this.getValue(element, property);
            if (value.equals(oldValue)) {
                return;
            }
            if (!"org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_VALUE".equals(property)) {
                return;
            }
            if (element instanceof ExprNodeBase && value instanceof String) {
                try {
                    value = PICLUtils.postProcessVisualTextEditString((String)((String)value));
                    ((ExprNodeBase)element).setRawValue((String)value);
                }
                catch (DebugException de) {
                    PICLDebugPlugin.showMessageDialog((Shell)PICLUtils.getShell(), (int)1, (String)de.getMessage(), (boolean)false);
                }
                catch (Exception e) {
                    PICLUtils.logError((Exception)e);
                }
            }
        }
    }

    public static class BIDIVariableColumnEditor
    implements IElementEditor {
        protected ICellModifier fCellModifier;

        public CellEditor getCellEditor(IPresentationContext context, String columnId, Object element, Composite parent) {
            return new VisualTextCellEditor(parent, 0x2000000);
        }

        public ICellModifier getCellModifier(IPresentationContext context, Object element) {
            if (this.fCellModifier == null) {
                this.fCellModifier = new BIDIVariableCellModifier();
            }
            return this.fCellModifier;
        }

        public String getId() {
            return BIDIColumnEditorFactoryAdapter.BIDI_VARIABLE_COLUMN_EDITOR_ID;
        }
    }
}

