/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.preferences;

import com.ibm.ftt.debug.ui.composites.ISourceLookupCompositeListener;
import com.ibm.ftt.debug.ui.composites.SourceLookupComposite;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class SourceLookupFieldEditor
extends FieldEditor
implements ISourceLookupCompositeListener {
    private String fPreferenceKey;
    private SourceLookupComposite fSourceLookupComposite;

    public SourceLookupFieldEditor(Composite parent, String prefKey) {
        this.fPreferenceKey = prefKey;
        this.setPreferenceName(this.fPreferenceKey);
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridDataFactory.fillDefaults().grab(true, false).span(numColumns, 1).applyTo((Control)this.fSourceLookupComposite);
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.fSourceLookupComposite = new SourceLookupComposite((ISourceLookupCompositeListener)this, parent, 0, true);
        this.fSourceLookupComposite.setAlwaysAllowBrowse(true);
        this.adjustForNumColumns(numColumns);
    }

    protected void doLoad() {
        IPreferenceStore store = this.getPreferenceStore();
        if (this.fSourceLookupComposite != null) {
            this.fSourceLookupComposite.setInitialValues(store.getString(this.fPreferenceKey));
        }
    }

    protected void doLoadDefault() {
        IPreferenceStore store = this.getPreferenceStore();
        if (this.fSourceLookupComposite != null) {
            this.fSourceLookupComposite.setInitialValues(store.getDefaultString(this.fPreferenceKey));
        }
    }

    protected void doStore() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(this.fPreferenceKey, this.fSourceLookupComposite.getListString());
    }

    public int getNumberOfControls() {
        return 1;
    }

    public void sourceLookupListChanged() {
        String newValue;
        IPreferenceStore store = this.getPreferenceStore();
        String oldValue = store.getString(this.fPreferenceKey);
        if (!oldValue.equals(newValue = this.fSourceLookupComposite.getListString())) {
            this.fireValueChanged(this.fPreferenceKey, oldValue, newValue);
        }
        this.setPresentsDefaultValue(newValue.equals(store.getDefaultString(this.fPreferenceKey)));
    }

    public boolean validate(Text dataset, boolean isUssAllowed) {
        return true;
    }

    public void setFocus() {
        this.fSourceLookupComposite.setFocus();
    }
}

