/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch;

import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.JCLDelegateUtils;
import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.Messages;
import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.MvsBatchLaunchPlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.ftt.debug.ui.DebugLaunchUtils;
import com.ibm.ftt.debug.ui.DebugMessages;
import com.ibm.ftt.debug.ui.IIDzInfoProvider;
import com.ibm.ftt.debug.ui.composites.IJCLLaunchConstants;
import com.ibm.ftt.debug.ui.util.DebugLaunchUIUtils;
import com.ibm.ftt.debug.ui.util.JCLStepException;
import com.ibm.ftt.debug.ui.util.JCLUtils;
import com.ibm.ftt.debug.ui.util.LaunchShortcutUtils;
import com.ibm.ftt.properties.IPropertyGroup;
import com.ibm.ftt.properties.zos.ZOSPropertyGroupContainer;
import com.ibm.ftt.resources.core.physical.IAbstractResource;
import com.ibm.ftt.resources.core.physical.IPhysicalResource;
import com.ibm.ftt.resources.zos.PBSystemIFileProperties;
import com.ibm.ftt.resources.zos.model.MVSFileResource;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class MvsBatchLaunchShortCut
implements ILaunchShortcut2,
IJCLLaunchConstants {
    private static final String JCL_EXTENSION = "jcl";
    private static final String EMPTY = "";
    public static final String LAUNCH_CONFIG_TYPE = "com.ibm.debug.pdt.launch.configType.mvsBatch";
    protected static final ILaunchConfiguration[] EMPTY_LAUNCHES = new ILaunchConfiguration[0];

    public void launch(IEditorPart editor, String mode) {
        block7: {
            try {
                ILaunchConfigurationWorkingCopy copy = LaunchShortcutUtils.getLaunchConfiguration((IEditorPart)editor, (ILaunchConfiguration[])this.getBaseLaunchConfigurations(editor), (String)this.getType());
                if (copy != null) {
                    IEditorInput input = editor.getEditorInput();
                    if (input instanceof IFileEditorInput) {
                        IFile file = ((IFileEditorInput)input).getFile();
                        if (file == null) {
                            throw new CoreException((IStatus)new Status(4, "com.ibm.debug.pdt.idz.launches.common", NLS.bind((String)Messages.CRRDG8408, (Object)(input.toString() + "(null)")), null));
                        }
                        PBSystemIFileProperties props = new PBSystemIFileProperties((IResource)file);
                        Object editObject = props.getRemoteEditObject();
                        if (editObject instanceof IAbstractResource) {
                            IAbstractResource aRes = (IAbstractResource)editObject;
                            this.doLaunch(JCL_EXTENSION.equalsIgnoreCase(file.getFileExtension()), false, aRes, copy, mode);
                        } else {
                            this.doLaunch(JCL_EXTENSION.equalsIgnoreCase(file.getFileExtension()), false, file, copy, mode);
                        }
                        break block7;
                    }
                    throw new CoreException((IStatus)new Status(4, "com.ibm.debug.pdt.idz.launches.common", NLS.bind((String)Messages.CRRDG8408, (Object)input.toString()), null));
                }
                throw new CoreException((IStatus)new Status(4, "com.ibm.debug.pdt.idz.launches.common", Messages.CRRDG8409, null));
            }
            catch (CoreException e) {
                PICLDebugPlugin.showMessageDialog(null, (String)DebugMessages.CRRDG8000, (boolean)false);
                MvsBatchLaunchPlugin.log(e);
            }
        }
    }

    private void setBasicConfigOptions(ILaunchConfigurationWorkingCopy copy, IPropertyGroup group, Object resource, boolean isJCL, boolean isProgram, boolean useLocal) throws CoreException {
        boolean usePropertyGroup;
        String connection = EMPTY;
        boolean bl = usePropertyGroup = group != null;
        if (group != null) {
            connection = ((ZOSPropertyGroupContainer)group.getPropertyGroupContainer()).getSystem();
        } else if (resource instanceof IPhysicalResource) {
            connection = ((IPhysicalResource)resource).getSystem().getName();
        } else if (resource instanceof IFile) {
            String string = connection = copy.hasAttribute("CONNECTION") ? copy.getAttribute("CONNECTION", EMPTY) : DebugLaunchUtils.getFirstConnection().getName();
        }
        if (DebugLaunchUtils.getConnection((String)connection) == null) {
            connection = EMPTY;
        }
        copy.setAttribute("CONNECTION", connection);
        copy.setAttribute("PROPERTY_GROUP", copy.getAttribute("PROPERTY_GROUP", usePropertyGroup ? group.getName() : EMPTY));
        copy.setAttribute("USE_PROPERTY", copy.getAttribute("USE_PROPERTY", usePropertyGroup));
        copy.setAttribute("USE_EXISTING", copy.getAttribute("USE_EXISTING", isJCL));
        copy.setAttribute("USE_PROGRAM", copy.getAttribute("USE_PROGRAM", isProgram));
        copy.setAttribute("USE_LOCAL", copy.getAttribute("USE_LOCAL", useLocal));
    }

    private void setConfigStepsAndJCL(ILaunchConfigurationWorkingCopy copy, boolean isProgram, boolean isJCL, String mbrName, String mode, Object resource, boolean useLocal) throws CoreException {
        if (isProgram) {
            copy.setAttribute("STEP", "GO");
            copy.setAttribute("PROGRAM", copy.getAttribute("PROGRAM", mbrName));
        } else if (isJCL) {
            if (useLocal) {
                copy.setAttribute("JCL", copy.getAttribute("JCL", JCLUtils.getFileWorkspacePath((String)mbrName)));
            } else {
                copy.setAttribute("JCL", copy.getAttribute("JCL", mbrName));
            }
            String profileName = null;
            if (!"run".equals(mode)) {
                boolean connectionChanged;
                JCLUtils.Step[] step = null;
                IZOSSystemImage connection = null;
                boolean bl = connectionChanged = DebugLaunchUtils.getConnection((String)copy.getAttribute("CONNECTION", EMPTY)) == null;
                if (!copy.hasAttribute("STEP") || connectionChanged || copy.getAttribute("USEPROFILE", false) && !JCLDelegateUtils.isAPIProfile((ILaunchConfiguration)copy)) {
                    Object[] connectionAndSteps = this.getConfigurationSelection(copy.getAttribute("CONNECTION", EMPTY), mbrName, resource);
                    if (connectionAndSteps != null && connectionAndSteps[0] != null && connectionAndSteps[1] != null) {
                        connection = (IZOSSystemImage)connectionAndSteps[0];
                        step = (JCLUtils.Step[])connectionAndSteps[1];
                        profileName = this.getProfile();
                    }
                } else {
                    step = JCLUtils.Step.createSteps((String)copy.getAttribute("STEP", EMPTY));
                    String string = profileName = copy.hasAttribute("PROFILE_NAME") ? copy.getAttribute("PROFILE_NAME", null) : this.getProfile();
                }
                if (step == null) {
                    return;
                }
                if (connection != null) {
                    copy.setAttribute("CONNECTION", connection.getName());
                }
                copy.setAttribute("STEP", copy.getAttribute("STEP", JCLUtils.Step.getStepString((JCLUtils.Step[])step)));
                copy.setAttribute("USEPROFILE", profileName != null);
                if (profileName != null) {
                    copy.setAttribute("PROFILE_NAME", profileName);
                }
            }
        } else {
            copy.setAttribute("STEP", "GO");
            copy.setAttribute("SOURCE", copy.getAttribute("SOURCE", mbrName));
        }
    }

    private void setConfigProjectName(ILaunchConfigurationWorkingCopy copy, Object resource, IIDzInfoProvider provider) throws CoreException {
        String subprojectName;
        String projectName = provider == null ? null : provider.getProjectName(resource);
        String string = subprojectName = provider == null ? null : provider.getSubProjectName(resource);
        if (projectName != null && subprojectName != null) {
            copy.setAttribute("PROJECT", copy.getAttribute("PROJECT", projectName));
            copy.setAttribute("SUBPROJECT", copy.getAttribute("SUBPROJECT", subprojectName));
        }
    }

    private void doLaunch(boolean isJCL, boolean isProgram, Object resource, ILaunchConfigurationWorkingCopy copy, String mode) throws CoreException {
        IPropertyGroup group = null;
        boolean usePropertyGroup = false;
        IIDzInfoProvider provider = null;
        boolean localFile = resource instanceof IFile;
        if (!localFile) {
            group = ((IAbstractResource)resource).getCurrentPropertyGroup();
            usePropertyGroup = group != null;
            provider = DebugLaunchUtils.getIDzInfoProvider();
        }
        if (!isJCL && !usePropertyGroup && provider != null) {
            provider.displayPropertyGroupError((IAbstractResource)resource);
            return;
        }
        String mbrName = LaunchShortcutUtils.getQualifiedName((Object)resource);
        this.setBasicConfigOptions(copy, group, resource, isJCL, isProgram, localFile);
        this.setConfigStepsAndJCL(copy, isProgram, isJCL, mbrName, mode, resource, localFile);
        if (provider != null) {
            this.setConfigProjectName(copy, resource, provider);
        }
        if (!copy.getAttribute("CONNECTION", EMPTY).isEmpty() && (copy.hasAttribute("STEP") || "run".equals(mode))) {
            this.doLaunch(mode, copy);
        }
    }

    protected void doLaunch(String mode, ILaunchConfigurationWorkingCopy copy) throws CoreException {
        copy.doSave();
        copy.launch(mode, (IProgressMonitor)new NullProgressMonitor());
    }

    protected String getProfile() {
        return null;
    }

    public void launch(ISelection selection, String mode) {
        block7: {
            try {
                if (!(selection instanceof IStructuredSelection)) {
                    throw new CoreException((IStatus)new Status(4, "com.ibm.debug.pdt.idz.launches.common", NLS.bind((String)Messages.CRRDG8408, selection.getClass()), null));
                }
                ILaunchConfigurationWorkingCopy copy = LaunchShortcutUtils.getLaunchConfiguration((ISelection)selection, (ILaunchShortcut2)this, (String)this.getType());
                if (copy != null) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (item instanceof MVSFileResource) {
                        item = ((MVSFileResource)item).getZOSResource();
                    }
                    if (item instanceof IAbstractResource) {
                        String extension = LaunchShortcutUtils.getExtension((Object)item);
                        boolean isProgram = extension.equals("exe");
                        boolean isJCL = extension.equalsIgnoreCase(JCL_EXTENSION);
                        this.doLaunch(isJCL, isProgram, (IAbstractResource)item, copy, mode);
                        break block7;
                    }
                    if (item instanceof IFile) {
                        String extension = LaunchShortcutUtils.getExtension((Object)item);
                        boolean isProgram = extension.equals("exe");
                        boolean isJCL = extension.equalsIgnoreCase(JCL_EXTENSION);
                        this.doLaunch(isJCL, isProgram, (IFile)item, copy, mode);
                        break block7;
                    }
                    throw new CoreException((IStatus)new Status(4, "com.ibm.debug.pdt.idz.launches.common", NLS.bind((String)Messages.CRRDG8408, (Object)item), null));
                }
                throw new CoreException((IStatus)new Status(4, "com.ibm.debug.pdt.idz.launches.common", Messages.CRRDG8409, null));
            }
            catch (CoreException e) {
                PICLDebugPlugin.showMessageDialog(null, (String)DebugMessages.CRRDG8000, (boolean)false);
                MvsBatchLaunchPlugin.log(e);
            }
        }
    }

    protected Object[] getConfigurationSelection(String system, String jclMbrName, Object resource) throws CoreException {
        block7: {
            List zSystems = JCLUtils.getZSystems();
            IZOSSystemImage currentConnection = DebugLaunchUtils.getConnection((String)system);
            if (currentConnection == null) {
                currentConnection = DebugLaunchUtils.getFirstConnection();
            }
            JCLUtils.Step[] steps = null;
            IFile localJCLFile = resource instanceof IFile ? (IFile)resource : null;
            jclMbrName = resource instanceof IFile ? ((IFile)resource).getName() : jclMbrName;
            try {
                steps = localJCLFile != null ? JCLUtils.getSteps((IZOSSystemImage)currentConnection, (IFile)localJCLFile) : JCLUtils.getSteps((IZOSSystemImage)currentConnection, (String)jclMbrName);
                if (steps.length == 1 && (zSystems.size() == 1 || localJCLFile == null)) {
                    return new Object[]{currentConnection, steps};
                }
                if (steps.length > 0 || zSystems.size() > 1) {
                    Object[] configSelection = JCLUtils.promptForSteps((String)jclMbrName, (String)currentConnection.getName(), (IFile)localJCLFile);
                    if (configSelection != null && configSelection[0] != null && configSelection[1] != null) {
                        currentConnection = (IZOSSystemImage)configSelection[0];
                        steps = (JCLUtils.Step[])configSelection[1];
                        if (steps != null && currentConnection != null) {
                            return new Object[]{currentConnection, steps};
                        }
                    }
                    break block7;
                }
                throw new CoreException((IStatus)new Status(4, "com.ibm.debug.pdt.idz.launches.common", Messages.CRRDG8410, null));
            }
            catch (JCLStepException e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.debug.pdt.idz.launches.common", Messages.CRRDG8411, null));
            }
        }
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        ArrayList<ILaunchConfiguration> result = new ArrayList<ILaunchConfiguration>();
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(this.getType());
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            try {
                Object item = ((IStructuredSelection)selection).getFirstElement();
                if (item instanceof MVSFileResource) {
                    item = ((MVSFileResource)item).getZOSResource();
                }
                String mbrName = LaunchShortcutUtils.getQualifiedName((Object)item);
                IPropertyGroup group = this.getGroup(item);
                if (mbrName != null) {
                    mbrName = mbrName.toUpperCase(Locale.getDefault());
                    String extension = LaunchShortcutUtils.getExtension((Object)item);
                    boolean isJCL = extension.equalsIgnoreCase(JCL_EXTENSION);
                    ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
                    int n = iLaunchConfigurationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                        if (group == null) {
                            String jclSource = config.getAttribute("JCL", EMPTY);
                            if (!jclSource.isEmpty() && jclSource.equals(mbrName)) {
                                result.add(config);
                            } else if (jclSource.startsWith(JCLUtils.getWorkspaceVariable()) && jclSource.substring(JCLUtils.getWorkspaceVariable().length()).equalsIgnoreCase(mbrName)) {
                                result.add(config);
                            } else if (jclSource.matches(JCLUtils.getWorkspaceVariableRegex()) && jclSource.replaceAll(JCLUtils.getWorkspaceVariableRegex(), "$1").equalsIgnoreCase(mbrName)) {
                                result.add(config);
                            }
                        } else {
                            String connection;
                            String propertyGroup = config.getAttribute("PROPERTY_GROUP", EMPTY);
                            if (propertyGroup.equals(group.getName()) && (connection = config.getAttribute("CONNECTION", EMPTY)).equalsIgnoreCase(((ZOSPropertyGroupContainer)group.getPropertyGroupContainer()).getSystem())) {
                                if (isJCL) {
                                    String jclSource = config.getAttribute("JCL", EMPTY).toUpperCase(Locale.getDefault());
                                    if (jclSource.equals(mbrName) || JCLUtils.getWorkspaceVariable().concat(jclSource).equals(mbrName) || JCLUtils.getFileWorkspacePath((String)jclSource).equals(mbrName)) {
                                        result.add(config);
                                    }
                                } else {
                                    boolean useExisting = config.getAttribute("USE_EXISTING", true);
                                    boolean useProgram = config.getAttribute("USE_PROGRAM", true);
                                    String source = config.getAttribute("SOURCE", EMPTY).toUpperCase(Locale.getDefault());
                                    String program = config.getAttribute("PROGRAM", EMPTY).toUpperCase(Locale.getDefault());
                                    if (!useExisting && (useProgram && mbrName.equals(program) || !useProgram && mbrName.equals(source))) {
                                        result.add(config);
                                    }
                                }
                            }
                        }
                        ++n2;
                    }
                    return result.toArray(new ILaunchConfiguration[result.size()]);
                }
            }
            catch (CoreException e) {
                MvsBatchLaunchPlugin.log(e);
            }
        }
        return EMPTY_LAUNCHES;
    }

    private IPropertyGroup getGroup(Object item) {
        IIDzInfoProvider provider = DebugLaunchUtils.getIDzInfoProvider();
        if (provider != null && provider.handles(item)) {
            return provider.getPropertyGroup(item);
        }
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editor) {
        return this.getBaseLaunchConfigurations(editor);
    }

    protected ILaunchConfiguration[] getBaseLaunchConfigurations(IEditorPart editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            boolean isJCL = file != null && file.exists() && JCL_EXTENSION.equalsIgnoreCase(file.getFileExtension());
            String mbrName = null;
            IPropertyGroup group = null;
            PBSystemIFileProperties props = new PBSystemIFileProperties((IResource)file);
            Object editObject = props.getRemoteEditObject();
            if (editObject != null) {
                if (editObject instanceof IAbstractResource) {
                    IIDzInfoProvider provider = DebugLaunchUtils.getIDzInfoProvider();
                    IAbstractResource aRes = (IAbstractResource)editObject;
                    mbrName = aRes.getName();
                    group = aRes.getCurrentPropertyGroup();
                    if (aRes instanceof IPhysicalResource) {
                        mbrName = DebugLaunchUIUtils.convertToDatasetName((String)((IPhysicalResource)aRes).getFullPath().toString());
                    } else if (provider != null && provider.handles((Object)aRes)) {
                        mbrName = DebugLaunchUIUtils.convertToDatasetName((String)provider.getFullName(aRes));
                    }
                }
            } else if (file != null && isJCL) {
                mbrName = LaunchShortcutUtils.getQualifiedName((Object)file);
            }
            ArrayList<ILaunchConfiguration> result = new ArrayList<ILaunchConfiguration>();
            ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(this.getType());
            try {
                ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
                int n = iLaunchConfigurationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String name;
                    boolean useProgram;
                    ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                    String propertyGroup = config.getAttribute("PROPERTY_GROUP", EMPTY);
                    String connection = config.getAttribute("CONNECTION", EMPTY);
                    boolean useExisting = config.getAttribute("USE_EXISTING", true);
                    if (useExisting && isJCL) {
                        String jcl = config.getAttribute("JCL", EMPTY);
                        if (jcl.equalsIgnoreCase(mbrName)) {
                            result.add(config);
                        } else if (jcl.startsWith(JCLUtils.getWorkspaceVariable()) && jcl.substring(JCLUtils.getWorkspaceVariable().length()).equalsIgnoreCase(mbrName)) {
                            result.add(config);
                        } else if (jcl.matches(JCLUtils.getWorkspaceVariableRegex()) && jcl.replaceAll(JCLUtils.getWorkspaceVariableRegex(), "$1").equalsIgnoreCase(mbrName)) {
                            result.add(config);
                        }
                    } else if (!isJCL && propertyGroup != null && group != null && propertyGroup.equals(group.getName()) && connection.equalsIgnoreCase(((ZOSPropertyGroupContainer)group.getPropertyGroupContainer()).getSystem()) && !(useProgram = config.getAttribute("USE_PROGRAM", true)) && (name = config.getAttribute("SOURCE", EMPTY)).equals(mbrName)) {
                        result.add(config);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                MvsBatchLaunchPlugin.log(e);
            }
            return result.toArray(new ILaunchConfiguration[result.size()]);
        }
        return EMPTY_LAUNCHES;
    }

    public IResource getLaunchableResource(ISelection selection) {
        return null;
    }

    public IResource getLaunchableResource(IEditorPart editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    protected String getType() {
        return LAUNCH_CONFIG_TYPE;
    }
}

