/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch;

import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.Labels;
import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.MvsBatchLaunchPlugin;
import com.ibm.ftt.debug.launcher.ApplicationLaunchConstants;
import com.ibm.ftt.debug.ui.composites.IConnectionProvider;
import com.ibm.ftt.debug.ui.composites.IConnectionSettingsCompositeListener;
import com.ibm.ftt.debug.ui.composites.IJCLCompositeListener;
import com.ibm.ftt.debug.ui.composites.IJCLLaunchConstants;
import com.ibm.ftt.debug.ui.composites.IProfileProvider;
import com.ibm.ftt.debug.ui.composites.JCLComposite;
import com.ibm.ftt.debug.ui.tabs.IPropertyGroupProvider;
import com.ibm.ftt.debug.ui.util.JCLUtils;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class MvsBatchLaunchConfigurationTab
extends AbstractLaunchConfigurationTab
implements IJCLLaunchConstants,
IJCLCompositeListener,
IConnectionProvider,
ApplicationLaunchConstants,
IPropertyGroupProvider,
IProfileProvider {
    private JCLComposite fJCLComposite;
    private List<IConnectionSettingsCompositeListener> fListeners = new ArrayList<IConnectionSettingsCompositeListener>();
    private List<SelectionListener> fProfileListeners = new ArrayList<SelectionListener>();
    private boolean fIsExistingJCL;
    private String fMode;

    public MvsBatchLaunchConfigurationTab(boolean isExistingJCL, String mode) {
        this.fIsExistingJCL = isExistingJCL;
        this.fMode = mode;
    }

    public Image getImage() {
        return MvsBatchLaunchPlugin.getDefault().getImageRegistry().get("icons/JCL.png");
    }

    public void createControl(Composite parent) {
        this.fJCLComposite = new JCLComposite((IJCLCompositeListener)this, parent, 0, true, this.fIsExistingJCL, this.fMode);
        for (IConnectionSettingsCompositeListener iConnectionSettingsCompositeListener : this.fListeners) {
            this.fJCLComposite.addConnectionsSettingCompositeListener(iConnectionSettingsCompositeListener);
        }
        for (SelectionListener selectionListener : this.fProfileListeners) {
            this.fJCLComposite.addProfileListener(selectionListener);
        }
        this.fListeners.clear();
        this.setControl((Control)this.fJCLComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.fIsExistingJCL ? "com.ibm.debug.pdt.idz.launches.mvsbatch.jcl_options_tab_standalone" : "com.ibm.debug.pdt.idz.launches.mvsbatch.jcl_options_tab_IDz");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fJCLComposite, this.fIsExistingJCL ? "com.ibm.debug.pdt.idz.launches.mvsbatch.jcl_options_tab_standalone" : "com.ibm.debug.pdt.idz.launches.mvsbatch.jcl_options_tab_IDz");
    }

    public String getName() {
        return Labels.JCL_OPTIONS;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fJCLComposite.initializeFields(configuration.getAttribute("CONNECTION", ""), configuration.getAttribute("PROPERTY_GROUP", ""), configuration.getAttribute("USE_PROPERTY", false), configuration.getAttribute("USE_EXISTING", false), configuration.getAttribute("USE_PROGRAM", true), configuration.getAttribute("PROGRAM", ""), configuration.getAttribute("SOURCE", ""), configuration.getAttribute("JCL", ""), configuration.getAttribute("STEP", ""), configuration.getAttribute("PROJECT", ""), configuration.getAttribute("SUBPROJECT", ""), configuration.getAttribute("USEPROFILE", false), configuration.getAttribute("PROFILE_NAME", ""), configuration.getAttribute("USE_LOCAL", false));
            this.setErrorMessage(this.fJCLComposite.getErrorMessage());
        }
        catch (CoreException e) {
            MvsBatchLaunchPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("CONNECTION", this.fJCLComposite.getConnectionName());
        configuration.setAttribute("com.ibm.ftt.debug.remotemvsconnectionname", this.fJCLComposite.getConnectionName());
        if (this.fJCLComposite.isUsePropertyGroup()) {
            configuration.setAttribute("PROPERTY_GROUP", this.fJCLComposite.getPropertyGroup());
        }
        if (!this.fJCLComposite.getConnectionName().isEmpty()) {
            configuration.setAttribute("USE_PROPERTY", this.fJCLComposite.isUsePropertyGroup());
            configuration.setAttribute("USE_EXISTING", this.fJCLComposite.isUseExisting());
            configuration.setAttribute("USE_PROGRAM", this.fJCLComposite.isUseProgram());
            configuration.setAttribute("PROGRAM", this.fJCLComposite.getProgram());
            configuration.setAttribute("SOURCE", this.fJCLComposite.getSource());
            configuration.setAttribute("JCL", this.fJCLComposite.getJCL());
            configuration.setAttribute("USEPROFILE", this.fJCLComposite.isUseProfile());
            configuration.setAttribute("PROFILE_NAME", this.fJCLComposite.getProfile());
            configuration.setAttribute("USE_LOCAL", this.fJCLComposite.isUseLocalBrowse());
            JCLUtils.Step[] steps = this.fJCLComposite.getSteps();
            if (steps != null) {
                configuration.setAttribute("STEP", JCLUtils.Step.getStepString((JCLUtils.Step[])steps));
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("CONNECTION", "");
        configuration.setAttribute("com.ibm.ftt.debug.remotemvsconnectionname", "");
        configuration.setAttribute("PROPERTY_GROUP", "");
        configuration.setAttribute("USE_PROPERTY", false);
        configuration.setAttribute("USE_EXISTING", false);
        configuration.setAttribute("USE_PROGRAM", true);
        configuration.setAttribute("PROGRAM", "");
        configuration.setAttribute("SOURCE", "");
        configuration.setAttribute("JCL", "");
        configuration.setAttribute("STEP", "");
        configuration.setAttribute("USEPROFILE", false);
        configuration.setAttribute("PROFILE_NAME", "");
        configuration.setAttribute("USE_LOCAL", false);
        this.updateLaunchConfigurationDialog();
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
        this.setErrorMessage(this.fJCLComposite.getErrorMessage());
        this.updateLaunchConfigurationDialog();
    }

    public void widgetSelected(SelectionEvent arg0) {
        this.setErrorMessage(this.fJCLComposite.getErrorMessage());
        this.updateLaunchConfigurationDialog();
    }

    public void modifyText(ModifyEvent arg0) {
        if (this.fJCLComposite != null) {
            this.setErrorMessage(this.fJCLComposite.getErrorMessage());
            this.updateLaunchConfigurationDialog();
        }
    }

    public void handleStepError(String error) {
        this.setErrorMessage(error);
        this.updateLaunchConfigurationDialog();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.getErrorMessage() == null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setErrorMessage(this.fJCLComposite.getErrorMessage());
        this.updateLaunchConfigurationDialog();
    }

    public IZOSSystemImage getConnection() {
        return this.fJCLComposite != null ? this.fJCLComposite.getConnection() : null;
    }

    public void addConnectionsSettingCompositeListener(IConnectionSettingsCompositeListener listener) {
        if (this.fJCLComposite != null) {
            this.fJCLComposite.addConnectionsSettingCompositeListener(listener);
        }
        this.fListeners.add(listener);
    }

    public boolean isUsePropertyGroup() {
        if (this.fJCLComposite != null) {
            return this.fJCLComposite.isUsePropertyGroup();
        }
        return false;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.fJCLComposite.addPropertyGroupListener(listener);
    }

    public boolean canSave() {
        return this.getErrorMessage() == null;
    }

    public void addProfileListener(SelectionListener listener) {
        if (this.fJCLComposite != null) {
            this.fJCLComposite.addProfileListener(listener);
        } else {
            this.fProfileListeners.add(listener);
        }
    }

    public boolean isUseProfile() {
        return this.fJCLComposite.isUseProfile();
    }
}

