/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch;

import com.ibm.debug.daemon.CoreDaemon;
import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.JCLDelegateUtils;
import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.JobStatusDebugTarget;
import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.Labels;
import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.Messages;
import com.ibm.debug.pdt.idz.launches.common.internal.mvsBatch.MvsBatchLaunchPlugin;
import com.ibm.debug.pdt.ui.launchconfig.IConfigurationConstants;
import com.ibm.ftt.debug.launcher.ApplicationLaunchConstants;
import com.ibm.ftt.debug.ui.CCLaunchUtils;
import com.ibm.ftt.debug.ui.DebugLaunchUtils;
import com.ibm.ftt.debug.ui.ICCInfoProvider;
import com.ibm.ftt.debug.ui.IIDzInfoProvider;
import com.ibm.ftt.debug.ui.composites.IJCLLaunchConstants;
import com.ibm.ftt.debug.ui.util.JCLUtils;
import com.ibm.ftt.debug.ui.util.LaunchDelegateUtils;
import com.ibm.ftt.resources.core.physical.IAbstractResource;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class MvsBatchLaunchConfigurationDelegate
extends LaunchConfigurationDelegate
implements IConfigurationConstants,
IJCLLaunchConstants,
ApplicationLaunchConstants {
    public void launch(final ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor progress) throws CoreException {
        boolean isPropertyGroupLaunch;
        progress.beginTask(Labels.LAUNCHING_APPLICATION, 100);
        final IZOSSystemImage connection = DebugLaunchUtils.getConnection((String)config.getAttribute("CONNECTION", null));
        if (connection == null) {
            launch.terminate();
            throw new CoreException((IStatus)new Status(4, "com.ibm.debug.pdt.idz.launches.mvsbatch", Messages.CRRDG8405));
        }
        if (!connection.isConnected()) {
            try {
                connection.connect();
            }
            catch (Exception e) {
                launch.terminate();
                throw new CoreException((IStatus)new Status(4, "com.ibm.debug.pdt.idz.launches.mvsbatch", NLS.bind((String)Messages.CRRDG8401, (Object)connection.getName()) + e.toString()));
            }
        }
        Object resource = null;
        resource = config.getAttribute("USE_LOCAL", false) ? JCLDelegateUtils.getFile(JCLDelegateUtils.getResourceName(config)) : JCLDelegateUtils.getResource(connection, config);
        IIDzInfoProvider provider = null;
        boolean debugUseIntegratedDebugger = false;
        ICCInfoProvider ccprovider = CCLaunchUtils.getCCInfoProvider();
        String ccOptions = null;
        Object ccProperties = null;
        if (resource instanceof IAbstractResource) {
            provider = DebugLaunchUtils.getIDzInfoProvider();
            debugUseIntegratedDebugger = provider != null ? provider.isDTCompat((IAbstractResource)resource, config) : config.getAttribute("com.ibm.ftt.debug.dtCompatibility", true);
            ccOptions = provider == null ? null : provider.getCCOptions((IAbstractResource)resource, config);
        }
        ccProperties = ccprovider == null ? null : ccprovider.getCCProperties(ccOptions, config);
        int[] key = LaunchDelegateUtils.createDebugTarget((IZOSSystemImage)connection, (boolean)debugUseIntegratedDebugger, (ILaunchConfiguration)config, (String)mode, (ILaunch)launch, (Object)ccProperties);
        boolean bl = isPropertyGroupLaunch = !config.getAttribute("USE_EXISTING", false) && config.getAttribute("USE_PROPERTY", true);
        if (mode.equals("run") || key != null && key.length > 0) {
            JobStatusDebugTarget jobDebugTarget = new JobStatusDebugTarget(launch, connection);
            try {
                String jobId;
                String step = config.getAttribute("STEP", "");
                if (!isPropertyGroupLaunch && step.trim().isEmpty() && !mode.equals("run")) {
                    final String jcl = config.getAttribute("JCL", null);
                    if (jcl != null) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                Object[] connectionStepSelection = JCLUtils.promptForSteps((String)jcl, (String)connection.getName(), null);
                                JCLUtils.Step[] steps = (JCLUtils.Step[])connectionStepSelection[1];
                                IZOSSystemImage newConnection = (IZOSSystemImage)connectionStepSelection[0];
                                if (steps != null && steps.length > 0 && newConnection != null) {
                                    try {
                                        ILaunchConfigurationWorkingCopy copy = config.getWorkingCopy();
                                        copy.setAttribute("CONNECTION", (Object)newConnection);
                                        copy.setAttribute("STEP", config.getAttribute("STEP", JCLUtils.Step.getStepString((JCLUtils.Step[])steps)));
                                        copy.doSave();
                                    }
                                    catch (CoreException coreException) {
                                        // empty catch block
                                    }
                                }
                            }
                        });
                        step = config.getAttribute("STEP", null);
                        if (step == null || step.trim().isEmpty()) {
                            MvsBatchLaunchPlugin.log("No steps found in launch config, or selected from the prompt.");
                            launch.terminate();
                            throw new CoreException((IStatus)new Status(4, "com.ibm.debug.pdt.idz.launches.mvsbatch", Messages.CRRDG8406));
                        }
                    } else {
                        MvsBatchLaunchPlugin.log("No JCL found in launch config.");
                        launch.terminate();
                        throw new CoreException((IStatus)new Status(4, "com.ibm.debug.pdt.idz.launches.mvsbatch", Messages.CRRDG8406));
                    }
                }
                String string = jobId = provider != null ? provider.generateAndSubmitJCL(config, launch, mode, key, connection, progress) : JCLDelegateUtils.generateExistingAndSubmitJCL(connection, config, launch, mode, key, progress);
                if (jobId == null) {
                    launch.terminate();
                    throw new CoreException((IStatus)new Status(4, "com.ibm.debug.pdt.idz.launches.mvsbatch", Messages.CRRDG8406));
                }
                jobDebugTarget.setJobId(jobId);
            }
            catch (CoreException e) {
                jobDebugTarget.setMessage(e.getMessage());
                launch.terminate();
                throw e;
            }
        } else {
            launch.terminate();
            if (CoreDaemon.startListening()) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.debug.pdt.idz.launches.mvsbatch", Messages.CRRDG8407));
            }
        }
        progress.done();
    }
}

