/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.debug.ui.util;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WidgetUtil {
    public static final String COPY_RIGHT = "  Licensed Materials - Property of IBM, 5724-T07, Copyright IBM Corp. 2011 All rights reserved.  US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static Label createLabel(Composite parent, String name) {
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData());
        return label;
    }

    public static Label createLabel(Composite parent, String name, int gridData) {
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData(gridData));
        return label;
    }

    public static Label createLabel(Composite parent, String name, String tooltip) {
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData());
        label.setToolTipText(tooltip);
        return label;
    }

    public static Text createText(Composite parent, String tooltip, int width) {
        Text text = new Text(parent, 2048);
        GridData data = new GridData(768);
        data.widthHint = width;
        text.setLayoutData((Object)data);
        text.setToolTipText(tooltip);
        return text;
    }

    public static void createHorizontalFiller(Composite parent) {
        WidgetUtil.createHorizontalFiller(parent, 1);
    }

    public static void createHorizontalFiller(Composite parent, int count) {
        int i = 0;
        while (i < count) {
            new Label(parent, 0).setText("     ");
            ++i;
        }
    }

    public static Composite createComposite(Composite parent, Integer numColumns, Boolean grabExcessVerticalSpace) {
        Composite composite = new Composite(parent, 0);
        WidgetUtil.setGridLayout(composite, numColumns, 5, 5, grabExcessVerticalSpace);
        return composite;
    }

    public static Composite createComposite(Composite parent, Integer numColumns, Integer marginHeight, Integer marginWidth, Boolean grabExcessVerticalSpace) {
        Composite composite = new Composite(parent, 0);
        WidgetUtil.setGridLayout(composite, numColumns, marginHeight, marginWidth, grabExcessVerticalSpace);
        return composite;
    }

    public static void setGridLayout(Composite composite, Integer numColumns, Integer marginHeight, Integer marginWidth, Boolean grabExcessVerticalSpace) {
        GridLayout layout = new GridLayout();
        if (numColumns != null) {
            layout.numColumns = numColumns;
        }
        if (marginHeight != null) {
            layout.marginHeight = marginHeight;
        }
        if (marginWidth != null) {
            layout.marginWidth = marginWidth;
        }
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        if (grabExcessVerticalSpace != null) {
            data.grabExcessVerticalSpace = grabExcessVerticalSpace;
        }
        composite.setLayoutData((Object)data);
    }

    public static Group createGroup(Composite parent, int numColumns, String label) {
        Group composite = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        composite.setText(label);
        return composite;
    }

    public static Combo createCombo(Composite parent) {
        Combo combo = new Combo(parent, 12);
        combo.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(768);
        gd.widthHint = 25;
        combo.setLayoutData((Object)gd);
        return combo;
    }

    public static Combo createCombo(Composite parent, String label) {
        Label lbl = new Label(parent, 0);
        lbl.setText(label);
        Combo combo = new Combo(parent, 12);
        combo.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(768);
        gd.widthHint = 25;
        combo.setLayoutData((Object)gd);
        return combo;
    }

    public static Combo createCombo(Composite parent, String label, String tooltip) {
        Label lbl = new Label(parent, 0);
        lbl.setText(label);
        Combo combo = new Combo(parent, 12);
        combo.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(768);
        gd.widthHint = 25;
        combo.setLayoutData((Object)gd);
        combo.setToolTipText(tooltip);
        return combo;
    }

    public static Combo createCombo(Composite parent, String label, String labelTooltip, String comboTooltip) {
        Label lbl = new Label(parent, 0);
        lbl.setText(label);
        lbl.setToolTipText(labelTooltip);
        Combo combo = new Combo(parent, 12);
        combo.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(768);
        gd.widthHint = 25;
        combo.setLayoutData((Object)gd);
        combo.setToolTipText(comboTooltip);
        return combo;
    }

    public static Button createPushButton(Composite parent, String label) {
        return WidgetUtil.createPushButton(parent, label, 4);
    }

    public static Button createPushButton(Composite parent, String label, int fill) {
        Button button = new Button(parent, 8);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalAlignment = fill;
        button.setLayoutData((Object)data);
        return button;
    }

    public static Button createCheckBox(Composite parent, String label) {
        Button button = new Button(parent, 32);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    public static Button createCheckBox(Composite parent, String label, String tooltip, SelectionListener listener, boolean selection) {
        Button button = WidgetUtil.createCheckBox(parent, label);
        button.setToolTipText(tooltip);
        button.addSelectionListener(listener);
        button.setSelection(selection);
        return button;
    }

    public static Text createText(Composite parent) {
        Text textField = new Text(parent, 2052);
        GridData gd = new GridData(768);
        textField.setLayoutData((Object)gd);
        return textField;
    }

    public static Text createText(Composite parent, String label) {
        Label lbl = new Label(parent, 0);
        lbl.setText(label);
        Text textField = new Text(parent, 2052);
        GridData gd = new GridData(768);
        textField.setLayoutData((Object)gd);
        return textField;
    }

    public static Text createText(Composite parent, String label, String tooltip) {
        Label lbl = new Label(parent, 0);
        lbl.setText(label);
        Text textField = new Text(parent, 2052);
        GridData gd = new GridData(768);
        textField.setLayoutData((Object)gd);
        textField.setToolTipText(tooltip);
        return textField;
    }

    public static Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    public static GridData createFill() {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        return gd;
    }

    public static GridData createHorizontalFill() {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        return gd;
    }

    public static GridData createVerticalFill() {
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        return gd;
    }

    public static void occupyEmptyCell(Composite parent) {
        Label label = new Label(parent, 0);
        String name = "";
        label.setText(name);
        label.setLayoutData((Object)new GridData());
    }
}

