/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.debug.ui.util;

import com.ibm.debug.pdt.profile.internal.connection.Connection;
import com.ibm.ftt.common.logging.LogUtil;
import com.ibm.ftt.debug.DebugTrace;
import com.ibm.ftt.debug.launcher.ApplicationLaunchConstants;
import com.ibm.ftt.resource.utils.PBResourceUtils;
import com.ibm.ftt.resources.core.physical.IOSImage;
import com.ibm.ftt.resources.core.physicalfactory.PhysicalSystemRegistryFactory;
import com.ibm.ftt.resources.zos.PBResourceMvsUtils;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import java.util.Locale;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemStartHere;

public class RemoteUtil
implements ApplicationLaunchConstants {
    public static final String COPY_RIGHT = "  Licensed Materials - Property of IBM, 5724-T07, Copyright IBM Corp. 2011, 2025 All rights reserved.  US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String EMPTY = "";

    public static String getWorkstationIPAddressUsingZOSConnection(boolean connect) {
        if (SystemStartHere.getConnectionsBySystemType((String)"com.ibm.etools.zos.system").length == 0) {
            return EMPTY;
        }
        IZOSSystemImage definedButNotConnectedSystem = null;
        IZOSSystemImage[] systems = PBResourceMvsUtils.getAllMVSSubSystems();
        int i = 0;
        while (i < systems.length) {
            IZOSSystemImage systemImage = systems[i];
            DebugTrace.trace(RemoteUtil.class, 3, systemImage.getName() + "is connected? = " + systemImage.isConnected());
            if (systemImage.isConnected()) {
                return PBResourceUtils.getClientIPAddress((IOSImage)systemImage);
            }
            definedButNotConnectedSystem = systemImage;
            ++i;
        }
        if (connect && definedButNotConnectedSystem != null) {
            try {
                definedButNotConnectedSystem.connect();
                if (definedButNotConnectedSystem.isConnected()) {
                    return PBResourceUtils.getClientIPAddress(definedButNotConnectedSystem);
                }
            }
            catch (Exception e) {
                DebugTrace.trace(RemoteUtil.class, 0, e.getMessage(), e);
                LogUtil.log((int)4, (String)e.getMessage(), (String)"com.ibm.debug.pdt.idz.launches.common", (Throwable)e);
            }
        }
        return EMPTY;
    }

    public static boolean isZOSConnectionDefined() {
        return PBResourceMvsUtils.getAllMVSSubSystems().length > 0;
    }

    public static boolean isZOSConnectionActive() {
        IZOSSystemImage[] systems = PBResourceMvsUtils.getAllMVSSubSystems();
        int i = 0;
        while (i < systems.length) {
            IZOSSystemImage systemImage = systems[i];
            DebugTrace.trace(RemoteUtil.class, 3, systemImage.getName() + "is connected? = " + systemImage.isConnected());
            if (systemImage.isConnected()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean reestablishRSEConnection(String systemName) {
        IOSImage system = null;
        system = RemoteUtil.findSystem(systemName);
        if (system != null) {
            if (!system.isConnected()) {
                try {
                    system.connect();
                }
                catch (Exception exc) {
                    LogUtil.log((int)4, (String)("Exception in ConnectionUtilities.reestablishRSEConnection() - " + exc.getMessage()), (String)"com.ibm.debug.pdt.idz.launches.common");
                }
            }
            return system.isConnected();
        }
        return false;
    }

    public static boolean connectedInRSE(String systemName) {
        IOSImage system = null;
        system = RemoteUtil.findSystem(systemName);
        return system != null && system.isConnected();
    }

    public static boolean rseConnectionExists(String systemName) {
        IOSImage system = RemoteUtil.findSystem(systemName);
        return system != null;
    }

    public static IOSImage findSystem(String systemName) {
        Object[] systems = PhysicalSystemRegistryFactory.getSingleton().getSystems(2);
        IOSImage system = null;
        int i = 0;
        while (i < systems.length) {
            if (systems[i] instanceof IOSImage && (system = (IOSImage)systems[i]).getName().equalsIgnoreCase(systemName)) break;
            ++i;
        }
        return system;
    }

    public static String uppercaseUserID(String user) {
        StringBuilder sb = new StringBuilder(user == null ? EMPTY : user);
        int i = 0;
        while (i < sb.length()) {
            if (String.valueOf(sb.charAt(i)).matches("[a-z]")) {
                sb.replace(i, i + 1, (EMPTY + sb.charAt(i)).toUpperCase(Locale.getDefault()));
            }
            ++i;
        }
        return sb.toString();
    }

    public static IHost getHost(IZOSSystemImage connection) {
        if (connection != null && connection.getName() != null) {
            IHost[] hosts;
            IHost[] iHostArray = hosts = SystemStartHere.getConnections();
            int n = hosts.length;
            int n2 = 0;
            while (n2 < n) {
                IHost h = iHostArray[n2];
                if (h.getName().equals(connection.getName())) {
                    return h;
                }
                ++n2;
            }
        }
        return null;
    }

    public static String getLocalClientPort() {
        String port = Connection.getLocalClientPort((boolean)false);
        if (port.isEmpty()) {
            port = "8001";
        }
        return port;
    }
}

