/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.debug.ui.util;

import com.ibm.ftt.debug.ui.Activator;
import com.ibm.ftt.debug.ui.DebugMessages;
import com.ibm.ftt.debug.ui.util.CommonLaunchMessages;
import com.ibm.ftt.debug.ui.util.JCLUtils;
import com.ibm.ftt.mvs.client.validation.IMVSNameValidator;
import com.ibm.ftt.resource.utils.validators.PBMVSNameValidator;
import com.ibm.ftt.resources.core.physicalfactory.PhysicalSystemRegistryFactory;
import com.ibm.ftt.resources.zos.zosphysical.IZOSCatalog;
import com.ibm.ftt.resources.zos.zosphysical.IZOSPartitionedDataSet;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSDataSetMember;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSPartitionedDataSet;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSSequentialDataSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.osgi.util.NLS;

public class DebugLaunchUIUtils {
    public static final String COPY_RIGHT = "  Licensed Materials - Property of IBM, 5724-T07, Copyright IBM Corp. 2016 All rights reserved.  US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static String convertToDatasetName(String dsn) {
        if (((String)dsn).contains("/")) {
            dsn = ((String)dsn).replace("/", "(");
            dsn = (String)dsn + ")";
        }
        if (((String)dsn).contains("(") && ((String)dsn).substring(((String)dsn).indexOf("(")).contains(".")) {
            int memberIndex = ((String)dsn).indexOf("(") + ((String)dsn).substring(((String)dsn).indexOf("(")).indexOf(".");
            dsn = ((String)dsn).substring(0, memberIndex) + ")";
        }
        return dsn;
    }

    public static String convertToWorkspaceName(IFile file) {
        if (file != null) {
            return file.getFullPath().toString();
        }
        return null;
    }

    public static String isDatasetOrMemberNameExist(String hostName, String name) {
        if (hostName != null && !name.isEmpty()) {
            IZOSCatalog root;
            IZOSSystemImage connection = (IZOSSystemImage)PhysicalSystemRegistryFactory.getSingleton().find(hostName, 2);
            if (!connection.isConnected()) {
                try {
                    connection.connect();
                }
                catch (Exception e) {
                    return NLS.bind((String)DebugMessages.CRRDG8020, (Object)hostName);
                }
            }
            if ((root = (IZOSCatalog)connection.getRoot()) != null) {
                IAdaptable dsm;
                int dsIndex = name.indexOf(40);
                IAdaptable iAdaptable = dsm = dsIndex == -1 ? root.findMember(name) : root.findMember(name.substring(0, dsIndex));
                if (dsIndex > -1 && dsm instanceof IZOSPartitionedDataSet) {
                    dsm = ((IZOSPartitionedDataSet)dsm).findMember(name.substring(dsIndex + 1, name.length() - 1));
                }
                if (dsm == null || !(dsm instanceof ZOSDataSetMember) && !(dsm instanceof ZOSSequentialDataSet)) {
                    return NLS.bind((String)DebugMessages.CRRDG8020, (Object)name);
                }
            }
        }
        return null;
    }

    public static String isDatasetLibExist(String hostName, String name) {
        if (hostName != null && !name.isEmpty()) {
            IZOSCatalog root;
            IZOSSystemImage connection = (IZOSSystemImage)PhysicalSystemRegistryFactory.getSingleton().find(hostName, 2);
            if (!connection.isConnected()) {
                try {
                    connection.connect();
                }
                catch (Exception e) {
                    return NLS.bind((String)DebugMessages.CRRDG8020, (Object)hostName);
                }
            }
            if ((root = (IZOSCatalog)connection.getRoot()) != null) {
                IAdaptable dsm;
                int dsIndex = name.indexOf(40);
                IAdaptable iAdaptable = dsm = dsIndex == -1 ? root.findMember(name) : root.findMember(name.substring(0, dsIndex));
                if (dsm == null) {
                    return NLS.bind((String)DebugMessages.CRRDG8020, (Object)name);
                }
                if (dsIndex > -1 || !(dsm instanceof ZOSPartitionedDataSet)) {
                    return NLS.bind((String)DebugMessages.CRRDG8038, (Object)name);
                }
            }
        }
        return null;
    }

    public static String validateDatasetOrMemberName(String hostName, String name) {
        String nameError = DebugLaunchUIUtils.validateDatasetOrMemberName(hostName, name, true);
        if (nameError != null) {
            return nameError;
        }
        String dataSetMemberNameExists = DebugLaunchUIUtils.isDatasetOrMemberNameExist(hostName, name);
        if (dataSetMemberNameExists != null) {
            return dataSetMemberNameExists;
        }
        return null;
    }

    public static String validateDatasetLibName(String hostName, String name) {
        String nameError = DebugLaunchUIUtils.validateDatasetOrMemberName(hostName, name, true);
        if (nameError != null) {
            return nameError;
        }
        String dataSetMemberNameExists = DebugLaunchUIUtils.isDatasetLibExist(hostName, name);
        if (dataSetMemberNameExists != null) {
            return dataSetMemberNameExists;
        }
        return null;
    }

    public static String validateLocalFile(String jclName) {
        try {
            IResource jclFile = null;
            String jclPath = null;
            if (jclName == null || !jclName.toLowerCase().endsWith(".jcl") && !jclName.matches("^\\{workspace_loc:(?i)(.*\\.jcl)\\}$")) {
                return NLS.bind((String)DebugMessages.CRRDG8022, (Object)jclName);
            }
            jclPath = jclName.startsWith(JCLUtils.getWorkspaceVariable()) ? jclName.substring(JCLUtils.getWorkspaceVariable().length()) : jclName.replaceAll("^\\{workspace_loc:(?i)(.*\\.jcl)\\}$", "$1");
            jclFile = ResourcesPlugin.getWorkspace().getRoot().findMember(jclPath);
            if (jclFile != null && jclFile.exists()) {
                return null;
            }
        }
        catch (Exception e) {
            Activator.log(e);
        }
        return NLS.bind((String)DebugMessages.CRRDG8020, (Object)jclName);
    }

    public static String validateDatasetOrMemberName(String hostName, String name, boolean checkForMember) {
        if (hostName == null) {
            return null;
        }
        String codepage = PBMVSNameValidator.getSingleton().getHostCodePage(hostName);
        if (checkForMember && name.contains("(")) {
            int start = name.indexOf("(");
            if (start == -1 || !name.endsWith(")")) {
                return CommonLaunchMessages.CRRDG9000;
            }
            String dataset = name.substring(0, start);
            String member = name.substring(start + 1, name.length() - 1);
            String datasetError = DebugLaunchUIUtils.validateDatasetOrMemberName(hostName, dataset, false);
            if (datasetError != null) {
                return datasetError;
            }
            int rc = IMVSNameValidator.singleton.validateMemberName(member, codepage);
            if (rc != 0) {
                return DebugLaunchUIUtils.getErrorMessage(rc);
            }
        } else {
            int rc = IMVSNameValidator.singleton.validateDataSetName(name, codepage);
            if (rc != 0) {
                return DebugLaunchUIUtils.getErrorMessage(rc);
            }
            if (name.indexOf(46) == -1) {
                return DebugLaunchUIUtils.getErrorMessage(5);
            }
        }
        return null;
    }

    private static String getErrorMessage(int rc) {
        switch (rc) {
            case 1: {
                return CommonLaunchMessages.CRRDG9000;
            }
            case 2: {
                return CommonLaunchMessages.CRRDG9003;
            }
            case 3: {
                return CommonLaunchMessages.CRRDG9005;
            }
            case 4: {
                return CommonLaunchMessages.CRRDG9004;
            }
            case 5: {
                return CommonLaunchMessages.CRRDG9006;
            }
            case 7: {
                return CommonLaunchMessages.CRRDG9007;
            }
            case 8: {
                return CommonLaunchMessages.CRRDG9008;
            }
            case 9: {
                return CommonLaunchMessages.CRRDG9001;
            }
            case 10: {
                return CommonLaunchMessages.CRRDG9002;
            }
        }
        return "";
    }
}

