/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.debug.ui.util;

import com.ibm.ftt.common.team.integration.IResourcePropertiesInput;
import com.ibm.ftt.common.team.integration.ResourcePropertiesManager;
import com.ibm.ftt.core.language.manager.ILanguageManager;
import com.ibm.ftt.debug.ui.Activator;
import com.ibm.ftt.debug.ui.DebugLaunchUtils;
import com.ibm.ftt.debug.ui.IIDzInfoProvider;
import com.ibm.ftt.language.manager.LanguageManagerFactory;
import com.ibm.ftt.resources.core.physical.IAbstractResource;
import com.ibm.ftt.resources.core.physical.IPhysicalResource;
import com.ibm.ftt.resources.zos.zosphysical.IZOSDataSetMember;
import com.ibm.ftt.resources.zos.zosphysical.IZOSResource;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSResource;
import com.ibm.ftt.ui.actions.builders.utils.IDebugJCLGenerator;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class DebugJCLGenerationUtils
extends DebugLaunchUtils
implements IDebugJCLGenerator {
    private static final String NOTEST = "NOTEST";
    private static final String TEST = "TEST";
    private static final String COLON = ":";
    private static final String EQA_DBG_TRACE = "EQA_DBG_TRACE=";
    private static final String CC = "CC";
    private static final String ENVAR = "ENVAR(";
    private static final String EQA_STARTUP_KEY = "EQA_STARTUP_KEY";
    private static final String COMMA = ",";
    private static final String EMPTY = "";
    private Map<DD_TYPE, List<SourceLookupItem>> fListItemMap = new HashMap<DD_TYPE, List<SourceLookupItem>>();
    public static final String VRM_NEW = "V14.0:";
    public static final int LISTING_IDX = 0;
    public static final int COBOL_SRC_IDX = 1;
    public static final int OTHER_SRC_IDX = 2;
    public static final int SYSADATA_IDX = 3;
    public static final int EQALANGX_IDX = 4;
    public static final int SIDEFILE_IDX = 5;
    public static final int CPP_SIDEFILE_IDX = 6;
    public static final int CPP_MM_IDX = 7;
    protected ILanguageManager fLanguageManager = LanguageManagerFactory.getSingleton();
    private static final Map<IAbstractResource, Integer> fKeyMap = Collections.synchronizedMap(new HashMap());

    public static void registerResource(IAbstractResource resource, int debugKey) {
        fKeyMap.put(resource, debugKey);
    }

    public static String getJCLString(boolean isDDRequested, boolean isDTCompat, Map<DD_TYPE, List<SourceLookupItem>> itemMap) {
        CharArrayWriter cWriter = new CharArrayWriter();
        BufferedWriter writer = new BufferedWriter(cWriter);
        try {
            boolean needsSeperator = false;
            ArrayList<Map.Entry<DD_TYPE, List<SourceLookupItem>>> entries = new ArrayList<Map.Entry<DD_TYPE, List<SourceLookupItem>>>(itemMap.entrySet());
            Collections.sort(entries, new Comparator<Map.Entry<DD_TYPE, List<SourceLookupItem>>>(){

                @Override
                public int compare(Map.Entry<DD_TYPE, List<SourceLookupItem>> arg0, Map.Entry<DD_TYPE, List<SourceLookupItem>> arg1) {
                    return arg0.getKey().toString().compareTo(arg1.getKey().toString());
                }
            });
            block6: for (Map.Entry entry : entries) {
                switch (((List)entry.getValue()).size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (isDDRequested) {
                            DebugJCLGenerationUtils.writeDD(writer, (DD_TYPE)((Object)entry.getKey()), isDTCompat, (List)entry.getValue());
                            break;
                        }
                        if (needsSeperator) {
                            writer.write(44);
                        }
                        needsSeperator = DebugJCLGenerationUtils.writeCEEOPTS(writer, (DD_TYPE)((Object)entry.getKey()), isDTCompat, (List)entry.getValue());
                        break;
                    }
                    default: {
                        if (!isDDRequested && !isDTCompat) {
                            if (needsSeperator) {
                                writer.write(44);
                            }
                            needsSeperator = DebugJCLGenerationUtils.writeCEEOPTS(writer, (DD_TYPE)((Object)entry.getKey()), isDTCompat, (List)entry.getValue());
                            break;
                        }
                        if (!isDDRequested || !isDTCompat) continue block6;
                        DebugJCLGenerationUtils.writeDD(writer, (DD_TYPE)((Object)entry.getKey()), isDTCompat, (List)entry.getValue());
                    }
                }
            }
            writer.close();
            cWriter.close();
        }
        catch (IOException e) {
            Activator.log(e);
        }
        return cWriter.toString();
    }

    private static String getEnVar(DD_TYPE type) {
        switch (type) {
            case EQAADATA: {
                return enVars_TYPE.EQA_DBG_SYSADATA.toString();
            }
            case EQAV4LST: {
                return enVars_TYPE.EQA_DBG_V4LIST.toString();
            }
            case EQADEBUG_STD: {
                return enVars_TYPE.EQA_DBG_SYSDEBUG.toString();
            }
            case EQASRCE_STD: {
                return enVars_TYPE.EQA_DBG_SRCE.toString();
            }
            case EQASRCE_DT: {
                return enVars_TYPE.EQA_SRC_PATH.toString();
            }
        }
        return null;
    }

    private static boolean writeCEEOPTS(BufferedWriter writer, DD_TYPE type, boolean isDTCompat, List<SourceLookupItem> items) throws IOException {
        if (items.size() != 0) {
            if (items.get((int)0).fType == 4 || (type == DD_TYPE.EQADEBUG_STD || type == DD_TYPE.EQADEBUG_DT) && items.get((int)0).fType == 0) {
                ArrayList<SourceLookupItem> newList = new ArrayList<SourceLookupItem>(items);
                newList.remove(0);
                DebugJCLGenerationUtils.writeCEEOPTS(writer, type, isDTCompat, newList);
            } else if (items.size() > 1 && DebugJCLGenerationUtils.getEnVar(type) != null || type == DD_TYPE.EQASRCE_DT && items.get((int)0).fPDS.startsWith("/")) {
                writer.write(34);
                writer.write(DebugJCLGenerationUtils.getEnVar(type));
                writer.write(61);
                writer.write(items.get((int)0).fPDS);
                int i = 1;
                while (i < items.size()) {
                    if (items.get((int)i).fType != 4) {
                        writer.write(58);
                        writer.write(items.get((int)i).fPDS);
                    }
                    ++i;
                }
                writer.write(34);
                return true;
            }
        }
        return false;
    }

    private static void writeDD(BufferedWriter writer, DD_TYPE type, boolean isDTCompat, List<SourceLookupItem> items) throws IOException {
        if (items.size() != 0) {
            if (type == DD_TYPE.EQASRCE_DT && items.get((int)0).fPDS.startsWith("/")) {
                return;
            }
            if (isDTCompat && type == DD_TYPE.EQADEBUG_DT && items.get(0).getComboIndex() == 6) {
                ArrayList<SourceLookupItem> newList = new ArrayList<SourceLookupItem>(items);
                newList.remove(0);
                DebugJCLGenerationUtils.writeDD(writer, type, isDTCompat, newList);
            } else {
                boolean idOnly;
                boolean dtOnly = DebugJCLGenerationUtils.isTypeDTCompatOnly(type) && !isDTCompat;
                boolean bl = idOnly = DebugJCLGenerationUtils.isTypeIDCompatOnly(type) && isDTCompat;
                if (dtOnly || idOnly) {
                    return;
                }
                DebugJCLGenerationUtils.writeDD(writer, false, type, items.get(0), false);
                int i = 1;
                while (i < items.size()) {
                    writer.newLine();
                    DebugJCLGenerationUtils.writeDD(writer, false, type, items.get(i), true);
                    ++i;
                }
                writer.newLine();
            }
        }
    }

    private static void writeDD(BufferedWriter writer, boolean ignore, DD_TYPE type, SourceLookupItem item, boolean isContinuation) throws IOException {
        writer.write("//");
        if (ignore) {
            writer.write("*");
        }
        writer.write(isContinuation ? "        " : DebugJCLGenerationUtils.getTypeString(type));
        writer.write(" DD ");
        writer.write("DISP=SHR,DSN=");
        writer.write(item.fPDS);
    }

    private static String getTypeString(DD_TYPE type) {
        switch (type) {
            case EQADEBUG_STD: 
            case EQADEBUG_DT: {
                return "EQADEBUG";
            }
            case EQASRCE_DT: 
            case EQASRCE_STD: {
                return "EQASRCE";
            }
        }
        return type.toString();
    }

    private static boolean isTypeDTCompatOnly(DD_TYPE type) {
        return type == DD_TYPE.EQADBG || type == DD_TYPE.EQAMDBG || type == DD_TYPE.EQADEBUG_DT || type == DD_TYPE.EQASRCE_DT;
    }

    private static boolean isTypeIDCompatOnly(DD_TYPE type) {
        return type == DD_TYPE.EQAADATA || type == DD_TYPE.EQAV4LST || type == DD_TYPE.EQADEBUG_STD || type == DD_TYPE.EQASRCE_STD;
    }

    public boolean writeDebugOptions(BufferedWriter bufferedWriter, IAbstractResource resource, String intent) {
        int debugKey = -1;
        if (fKeyMap.containsKey(resource)) {
            debugKey = fKeyMap.remove(resource);
        }
        return this.writeDebugOptions(bufferedWriter, resource, intent, debugKey);
    }

    private boolean writeDebugOptions(BufferedWriter bufferedWriter, IAbstractResource resource, String intent, int debugKey) {
        IResourcePropertiesInput propertiesInput = ResourcePropertiesManager.INSTANCE.getResourcePropertiesInput((Object)resource);
        boolean flag = true;
        String testParm = EMPTY;
        String testParmPrefix = EMPTY;
        String debugprop = propertiesInput.getProperty("RUNTIME.DEBUG_USE_INTEGRATED_DEBUGGER");
        String debugLEOptions = propertiesInput.getProperty("RUNTIME.DEBUG_LE_OPTIONS");
        String codecoverageOptions = propertiesInput.getProperty("RUNTIME.CC_OPTIONS");
        boolean isCodeCoverage = intent != null && (intent.endsWith(".CODECOVERAGE") || intent.equals("CODECOVERAGE"));
        boolean isDebug = intent != null && (intent.endsWith(".DEBUGALWAYS") || intent.equals("DEBUGALWAYS"));
        boolean runInBatch = Boolean.parseBoolean(propertiesInput.getProperty("RUNTIME.INBATCH"));
        boolean debugUseIntegratedDebugger = Boolean.parseBoolean(debugprop) || runInBatch && !isDebug && !isCodeCoverage;
        boolean runInDebug = Boolean.parseBoolean(propertiesInput.getProperty("RUNTIME.DEBUG"));
        boolean runInIntegratedDebug = Boolean.parseBoolean(propertiesInput.getProperty("RUNTIME.DEBUG.INTEGRATED.DEBUGGER"));
        boolean codeCoverage = Boolean.parseBoolean(propertiesInput.getProperty("RUNTIME.CODECOVERAGE"));
        boolean codeIntegratedCoverage = Boolean.parseBoolean(propertiesInput.getProperty("RUNTIME.CODECOVERAGE.INTEGRATED.DEBUGGER"));
        boolean debugUseOldInfo = debugprop == null && !runInBatch;
        boolean probeTrace = Boolean.parseBoolean(propertiesInput.getProperty("RUNTIME.DEBUG_PROBE_TRACE"));
        String debugTestLevel = propertiesInput.getProperty("RUNTIME.DEBUG_TEST_LEVEL");
        debugTestLevel = debugTestLevel == null ? EMPTY : debugTestLevel;
        String debugTestPrompt = propertiesInput.getProperty("RUNTIME.DEBUG_TEST_PROMPT");
        debugTestPrompt = debugTestPrompt == null ? EMPTY : debugTestPrompt;
        String debugConnection = propertiesInput.getProperty("RUNTIME.DEBUG_CONNECTION");
        String debugProbeTrace = propertiesInput.getProperty("RUNTIME.DEBUG_TRACE_FILE");
        if (debugProbeTrace != null && debugProbeTrace.startsWith(VRM_NEW)) {
            if (probeTrace) {
                debugProbeTrace = EMPTY;
            } else {
                String[] pairs;
                this.fListItemMap.clear();
                String[] stringArray = pairs = debugProbeTrace.substring(VRM_NEW.length()).split(COMMA);
                int n = pairs.length;
                int n2 = 0;
                while (n2 < n) {
                    String pair = stringArray[n2];
                    String[] pieces = pair.split(COLON);
                    if (pieces.length == 2) {
                        SourceLookupItem sItem = new SourceLookupItem(pieces[0], pieces[1]);
                        DebugJCLGenerationUtils.updateItemSet(this.fListItemMap, sItem, true);
                    }
                    ++n2;
                }
                debugProbeTrace = null;
            }
        } else if (!probeTrace && debugProbeTrace != null) {
            debugProbeTrace = EMPTY;
        }
        boolean subsystemFound = this.isUseCICS(resource) || this.isUseIMS(resource);
        String hostCodePageEntry = this.getHostCodePage(resource);
        IZOSSystemImage systemImage = null;
        IIDzInfoProvider provider = DebugLaunchUtils.getIDzInfoProvider();
        if (resource instanceof IZOSDataSetMember) {
            systemImage = (IZOSSystemImage)((IZOSDataSetMember)resource).getSystem();
        } else if (provider != null) {
            systemImage = provider.getSystem(resource);
        }
        if (!subsystemFound) {
            String goName = EMPTY;
            try {
                boolean parmsNeeded;
                boolean bl = parmsNeeded = isCodeCoverage || isDebug || intent != null && (intent.equalsIgnoreCase("DEBUGALWAYS") || intent.equalsIgnoreCase("CODECOVERAGE"));
                if (parmsNeeded) {
                    testParmPrefix = TEST;
                } else if (intent == null || intent.equals("JCLGEN")) {
                    testParmPrefix = runInDebug || codeCoverage || runInIntegratedDebug || codeIntegratedCoverage ? TEST : NOTEST;
                } else if (intent.equalsIgnoreCase("RUNALWAYS")) {
                    testParmPrefix = NOTEST;
                }
                Object ccoptions = null;
                if (testParmPrefix.equalsIgnoreCase(TEST)) {
                    boolean dbmActive = DebugJCLGenerationUtils.isDebugManagerReady(systemImage.getName());
                    String[] updatedOptions = DebugJCLGenerationUtils.splitLEOptions(debugLEOptions);
                    testParm = DebugJCLGenerationUtils.getTestParm(dbmActive, systemImage, debugUseIntegratedDebugger, debugUseOldInfo, runInIntegratedDebug, codeIntegratedCoverage, updatedOptions.length > 1 ? updatedOptions[1] : hostCodePageEntry, debugTestLevel, debugTestPrompt, debugConnection, updatedOptions.length > 2 ? updatedOptions[2] : null, null);
                    if (debugKey != -1) {
                        ccoptions = isCodeCoverage || intent != null && intent.equalsIgnoreCase("CODECOVERAGE") ? "\"EQA_STARTUP_KEY=CC," + debugKey + "\"" : "\"EQA_STARTUP_KEY=" + debugKey + "\"";
                    } else if (isCodeCoverage || intent != null && intent.equalsIgnoreCase("CODECOVERAGE")) {
                        ccoptions = this.getCCOptionString(isCodeCoverage, intent, codeCoverage, codeIntegratedCoverage, goName, codecoverageOptions);
                    }
                }
                if (parmsNeeded) {
                    String sourceLookupDD = DebugJCLGenerationUtils.getJCLString(true, !debugUseIntegratedDebugger, this.fListItemMap);
                    String sourceLookupEnv = DebugJCLGenerationUtils.getJCLString(false, !debugUseIntegratedDebugger, this.fListItemMap);
                    String[] updatedOptions = DebugJCLGenerationUtils.splitLEOptions(debugLEOptions);
                    DebugJCLGenerationUtils.writeAdditionalDebugOptions(testParm, updatedOptions.length > 0 ? updatedOptions[0] : null, debugProbeTrace, ccoptions, sourceLookupDD, sourceLookupEnv, bufferedWriter);
                }
                bufferedWriter.flush();
            }
            catch (IOException e) {
                flag = false;
            }
        }
        return flag;
    }

    public static void writeAdditionalDebugOptions(String testOptions, String debugLEOptions, String debugProbeTrace, String ccoptions, String sourceLookupDD, String sourceLookupEnv, BufferedWriter writer) throws IOException {
        String envars;
        if (sourceLookupDD != null && !sourceLookupDD.isEmpty()) {
            writer.write(sourceLookupDD);
        }
        writer.write("//CEEOPTS DD *");
        writer.newLine();
        writer.write(testOptions);
        boolean hasTrace = debugProbeTrace != null;
        boolean hasLEOptions = debugLEOptions != null && !debugLEOptions.trim().isEmpty();
        boolean hasCCOptions = ccoptions != null && !ccoptions.trim().isEmpty();
        String string = envars = sourceLookupEnv == null ? EMPTY : sourceLookupEnv;
        if (hasTrace || !envars.isEmpty() || hasCCOptions) {
            writer.newLine();
            writer.write(ENVAR);
        }
        if (hasTrace) {
            writer.newLine();
            writer.write("\"EQA_DBG_TRACE=" + DebugJCLGenerationUtils.cleanTrace(debugProbeTrace) + "\"");
        }
        if (hasCCOptions) {
            if (hasTrace) {
                writer.write(44);
            }
            writer.newLine();
            writer.write(ccoptions);
        }
        if (!envars.isEmpty()) {
            if (hasCCOptions || hasTrace) {
                writer.write(44);
            }
            writer.newLine();
            DebugJCLGenerationUtils.addCEEOpts(writer, envars);
        }
        if (hasLEOptions) {
            DebugJCLGenerationUtils.writeEnvarOptions(debugLEOptions, writer);
            writer.newLine();
            debugLEOptions = DebugJCLGenerationUtils.removeEnvarOptions(debugLEOptions);
        }
        if (hasTrace || !envars.isEmpty() || hasCCOptions) {
            writer.newLine();
            writer.write(")");
        }
        if (hasLEOptions) {
            if (hasTrace || !envars.isEmpty()) {
                writer.newLine();
            }
            DebugJCLGenerationUtils.addCEEOpts(writer, debugLEOptions);
        }
        writer.newLine();
        writer.write("/*");
        writer.newLine();
    }

    private static String removeEnvarOptions(String debugLEOptions) {
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(debugLEOptions, COMMA);
        boolean inEnvar = false;
        boolean needComma = false;
        while (st.hasMoreTokens()) {
            String var = st.nextToken();
            if (var.toUpperCase(Locale.getDefault()).startsWith(ENVAR)) {
                inEnvar = true;
                continue;
            }
            if (inEnvar && var.endsWith(")")) {
                inEnvar = false;
                continue;
            }
            if (inEnvar) continue;
            if (needComma) {
                sb.append(',');
            } else {
                needComma = true;
            }
            sb.append(var);
        }
        return sb.toString();
    }

    private boolean isUseIMS(IAbstractResource resource) {
        IResourcePropertiesInput propertiesInput = ResourcePropertiesManager.INSTANCE.getResourcePropertiesInput((Object)resource);
        String language = this.getLanguageType(resource);
        IIDzInfoProvider provider = DebugLaunchUtils.getIDzInfoProvider();
        if (provider != null) {
            if (language.equalsIgnoreCase(provider.getCOBOLanguageID())) {
                return Boolean.parseBoolean(propertiesInput.getProperty("COBOL.IMS.USEIMS"));
            }
            if (language.equalsIgnoreCase(provider.getPLILanguageID())) {
                return Boolean.parseBoolean(propertiesInput.getProperty("PLI.IMS.USEIMS"));
            }
        }
        return false;
    }

    private String getLanguageType(IAbstractResource res) {
        IPhysicalResource resource = null;
        resource = res.isLogical() ? (IPhysicalResource)Platform.getAdapterManager().getAdapter((Object)res, IPhysicalResource.class) : (IPhysicalResource)res;
        String lang = this.fLanguageManager.getExtensionLanguage(resource);
        return lang != null ? lang : EMPTY;
    }

    private boolean isUseCICS(IAbstractResource resource) {
        IResourcePropertiesInput propertiesInput = ResourcePropertiesManager.INSTANCE.getResourcePropertiesInput((Object)resource);
        String language = this.getLanguageType(resource);
        IIDzInfoProvider provider = DebugLaunchUtils.getIDzInfoProvider();
        if (provider != null) {
            if (language.equalsIgnoreCase(provider.getCOBOLanguageID())) {
                return Boolean.parseBoolean(propertiesInput.getProperty("COBOL.IMS.USEIMS"));
            }
            if (language.equalsIgnoreCase(provider.getPLILanguageID())) {
                return Boolean.parseBoolean(propertiesInput.getProperty("PLI.IMS.USEIMS"));
            }
        }
        return false;
    }

    public static void updateItemSet(Map<DD_TYPE, List<SourceLookupItem>> map, SourceLookupItem sItem, boolean add) {
        switch (sItem.fType) {
            case 0: {
                DebugJCLGenerationUtils.updateItemSet(map, DD_TYPE.EQADEBUG_DT, sItem, add);
                DebugJCLGenerationUtils.updateItemSet(map, DD_TYPE.EQAV4LST, sItem, add);
                break;
            }
            case 3: {
                DebugJCLGenerationUtils.updateItemSet(map, DD_TYPE.EQAADATA, sItem, add);
                break;
            }
            case 4: 
            case 5: {
                DebugJCLGenerationUtils.updateItemSet(map, DD_TYPE.EQADEBUG_DT, sItem, add);
                break;
            }
            case 6: {
                DebugJCLGenerationUtils.updateItemSet(map, DD_TYPE.EQADBG, sItem, add);
                DebugJCLGenerationUtils.updateItemSet(map, DD_TYPE.EQADEBUG_STD, sItem, add);
                break;
            }
            case 1: {
                DebugJCLGenerationUtils.updateItemSet(map, DD_TYPE.EQASRCE_DT, sItem, add);
                DebugJCLGenerationUtils.updateItemSet(map, DD_TYPE.EQASRCE_STD, sItem, add);
                break;
            }
            case 2: {
                DebugJCLGenerationUtils.updateItemSet(map, DD_TYPE.EQADEBUG_DT, sItem, add);
                DebugJCLGenerationUtils.updateItemSet(map, DD_TYPE.EQADEBUG_STD, sItem, add);
                DebugJCLGenerationUtils.updateItemSet(map, DD_TYPE.EQASRCE_STD, sItem, add);
                break;
            }
            case 7: {
                DebugJCLGenerationUtils.updateItemSet(map, DD_TYPE.EQAMDBG, sItem, add);
                break;
            }
        }
    }

    private static void updateItemSet(Map<DD_TYPE, List<SourceLookupItem>> map, DD_TYPE type, SourceLookupItem sItem, boolean add) {
        List<SourceLookupItem> list = map.get((Object)type);
        if (list == null) {
            list = new ArrayList<SourceLookupItem>();
            map.put(type, list);
        }
        if (add) {
            if (!list.contains(sItem)) {
                list.add(sItem);
            }
        } else {
            list.remove(sItem);
        }
    }

    public static String[] splitLEOptions(String leOptions) {
        ArrayList<String> options = new ArrayList<String>();
        if (leOptions != null) {
            int i = leOptions.indexOf(VRM_NEW);
            while (i > -1 && i < leOptions.length()) {
                int nextIdx = leOptions.indexOf(VRM_NEW, i + 1);
                options.add(leOptions.substring(i + VRM_NEW.length(), nextIdx == -1 ? leOptions.length() : nextIdx));
                i = leOptions.indexOf(VRM_NEW, i + 1);
            }
        }
        return options.toArray(new String[options.size()]);
    }

    private static void writeEnvarOptions(String debugLEOptions, BufferedWriter writer) throws IOException {
        StringTokenizer st = new StringTokenizer(debugLEOptions, COMMA);
        boolean inEnvar = false;
        boolean needNewLine = false;
        while (st.hasMoreTokens()) {
            String var = st.nextToken();
            if (var.toUpperCase(Locale.getDefault()).startsWith(ENVAR)) {
                inEnvar = true;
                continue;
            }
            if (!inEnvar) continue;
            if (needNewLine) {
                writer.append(',');
                writer.newLine();
            } else {
                needNewLine = true;
            }
            if (var.endsWith(")")) {
                inEnvar = false;
                writer.write(var.substring(0, var.length() - 1));
                continue;
            }
            writer.write(var);
        }
    }

    public static String cleanTrace(String trace) {
        if (trace == null || trace.trim().isEmpty() || trace.startsWith(EQA_DBG_TRACE) || trace.startsWith("AQE_DBG_TRACE=")) {
            return "./probeTrace_" + System.currentTimeMillis() + ".txt";
        }
        return trace;
    }

    private static void addCEEOpts(BufferedWriter writer, String option) throws IOException {
        int maxLen = 71;
        boolean first = true;
        while (option.length() > 0) {
            int idx;
            if (!first) {
                writer.newLine();
            }
            int n = idx = option.length() < 71 ? option.length() : option.lastIndexOf(44, 71) + 1;
            if (idx == 0) {
                idx = Math.min(71, option.length());
            }
            writer.write(option.substring(0, idx));
            option = option.substring(idx);
            first = false;
        }
    }

    private String getCCOptionString(boolean isCodeCoverage, String intent, boolean codeCoverage, boolean codeIntegratedCoverage, String goName, String codecoverageOptions) {
        if (isCodeCoverage || intent != null && intent.equalsIgnoreCase("JCLGEN") && (codeCoverage || codeIntegratedCoverage) || intent != null && intent.equalsIgnoreCase("CODECOVERAGE")) {
            String profile = goName.trim();
            Object ccoptions = null;
            ccoptions = codecoverageOptions == null ? "EQA_STARTUP_KEY=CC" : codecoverageOptions;
            if (!profile.isEmpty()) {
                int idx = ((String)ccoptions).indexOf(",,");
                ccoptions = idx > -1 ? ((String)ccoptions).substring(0, idx + 1) + profile + ((String)ccoptions).substring(idx + 1) : (String)ccoptions + COMMA + profile;
            }
            ccoptions = "\"" + (String)ccoptions + "\"";
            return ccoptions;
        }
        return EMPTY;
    }

    protected String getHostCodePage(IAbstractResource resource) {
        String hostCodePage = EMPTY;
        IZOSResource physicalResource = (IZOSResource)Platform.getAdapterManager().getAdapter((Object)resource, IPhysicalResource.class);
        hostCodePage = physicalResource == null || ((ZOSResource)physicalResource).getMvsResource() == null ? EMPTY : ((hostCodePage = ((ZOSResource)physicalResource).getMvsResource().getHostCp()) == null ? EMPTY : (hostCodePage.equalsIgnoreCase("IBM-930") || hostCodePage.equalsIgnoreCase("IBM-1390") ? "VADSCP930" : (hostCodePage.equalsIgnoreCase("IBM-939") || hostCodePage.equalsIgnoreCase("IBM-1399") ? "VADSCP939" : EMPTY)));
        return hostCodePage;
    }

    public String getTestParm(IAbstractResource resource, String intent) {
        int amp;
        IResourcePropertiesInput propertiesInput = ResourcePropertiesManager.INSTANCE.getResourcePropertiesInput((Object)resource);
        String debugprop = propertiesInput.getProperty("RUNTIME.DEBUG_USE_INTEGRATED_DEBUGGER");
        String debugLEOptions = propertiesInput.getProperty("RUNTIME.DEBUG_LE_OPTIONS");
        boolean debugUseIntegratedDebugger = Boolean.parseBoolean(debugprop);
        boolean runInIntegratedDebug = Boolean.parseBoolean(propertiesInput.getProperty("RUNTIME.DEBUG.INTEGRATED.DEBUGGER"));
        boolean codeIntegratedCoverage = Boolean.parseBoolean(propertiesInput.getProperty("RUNTIME.CODECOVERAGE.INTEGRATED.DEBUGGER"));
        boolean debugUseOldInfo = debugprop == null;
        boolean probeTrace = Boolean.parseBoolean(propertiesInput.getProperty("RUNTIME.DEBUG_PROBE_TRACE"));
        String debugTestLevel = propertiesInput.getProperty("RUNTIME.DEBUG_TEST_LEVEL");
        debugTestLevel = debugTestLevel == null ? EMPTY : debugTestLevel;
        String debugTestPrompt = propertiesInput.getProperty("RUNTIME.DEBUG_TEST_PROMPT");
        debugTestPrompt = debugTestPrompt == null ? EMPTY : debugTestPrompt;
        String debugConnection = propertiesInput.getProperty("RUNTIME.DEBUG_CONNECTION");
        String debugProbeTrace = propertiesInput.getProperty("RUNTIME.DEBUG_TRACE_FILE");
        if (debugProbeTrace != null && debugProbeTrace.startsWith(VRM_NEW)) {
            if (probeTrace) {
                debugProbeTrace = EMPTY;
            } else {
                String[] pairs;
                this.fListItemMap.clear();
                String[] stringArray = pairs = debugProbeTrace.split(COMMA);
                int n = pairs.length;
                int n2 = 0;
                while (n2 < n) {
                    String pair = stringArray[n2];
                    String[] pieces = pair.split(COLON);
                    if (pieces.length == 2) {
                        SourceLookupItem sItem = new SourceLookupItem(pieces[0], pieces[1]);
                        DebugJCLGenerationUtils.updateItemSet(this.fListItemMap, sItem, true);
                    }
                    ++n2;
                }
                debugProbeTrace = null;
            }
        } else if (!probeTrace && debugProbeTrace != null) {
            debugProbeTrace = EMPTY;
        }
        String hostCodePageEntry = this.getHostCodePage(resource);
        IZOSSystemImage systemImage = null;
        IIDzInfoProvider provider = DebugLaunchUtils.getIDzInfoProvider();
        if (resource instanceof IZOSDataSetMember) {
            systemImage = (IZOSSystemImage)((IZOSDataSetMember)resource).getSystem();
        } else if (provider != null) {
            systemImage = provider.getSystem(resource);
        }
        boolean dbmActive = systemImage != null && DebugJCLGenerationUtils.isDebugManagerReady(systemImage.getName());
        String[] updatedOptions = DebugJCLGenerationUtils.splitLEOptions(debugLEOptions);
        String testOverride = intent.equals("RUNALWAYS") ? NOTEST : null;
        StringBuilder testParm = new StringBuilder(DebugJCLGenerationUtils.getTestParm(dbmActive, systemImage, debugUseIntegratedDebugger, debugUseOldInfo, runInIntegratedDebug, codeIntegratedCoverage, updatedOptions.length > 1 ? updatedOptions[1] : hostCodePageEntry, debugTestLevel, debugTestPrompt, debugConnection, updatedOptions.length > 2 ? updatedOptions[2] : null, testOverride));
        int idx = testParm.indexOf("(");
        if (idx > -1) {
            testParm.insert(idx, '=');
        }
        if ((idx = testParm.lastIndexOf(COMMA)) > -1 && (amp = testParm.indexOf("&", idx)) > -1) {
            testParm.insert(amp, '&');
            testParm.insert(idx + 1, '\"');
            testParm.insert(testParm.length() - 1, '\"');
        }
        return testParm.toString();
    }

    public static enum DD_TYPE {
        EQADEBUG_STD,
        EQADEBUG_DT,
        EQAV4LST,
        EQASRCE_DT,
        EQASRCE_STD,
        EQADBG,
        EQAMDBG,
        EQAADATA;

    }

    public static class SourceLookupItem
    implements IAdaptable,
    IWorkbenchAdapter {
        public String fPDS;
        private int fType;
        private static String PREFIX = "@";
        private static final Object[] NO_CHILDREN = new Object[0];

        public SourceLookupItem(String pds, String type, boolean addPrefix) {
            this(pds, (String)(addPrefix && !type.startsWith(PREFIX) ? PREFIX + type : type));
        }

        public SourceLookupItem(String pds, String type) {
            this.fPDS = pds;
            if (type.startsWith(PREFIX)) {
                this.fType = Integer.parseInt(type.substring(1, type.length()));
            } else {
                this.fType = Integer.parseInt(type);
                if (this.fType > 0) {
                    ++this.fType;
                }
            }
        }

        protected final void finalize() {
        }

        public Object getAdapter(Class c) {
            if (c.equals(IWorkbenchAdapter.class)) {
                return this;
            }
            return null;
        }

        public Object[] getChildren(Object o) {
            return NO_CHILDREN;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return this.fPDS;
        }

        public Object getParent(Object o) {
            return null;
        }

        public int getComboIndex() {
            return this.fType;
        }

        public String getType() {
            return PREFIX + this.fType;
        }

        public static String getType(int comboIndex) {
            return PREFIX + comboIndex;
        }
    }

    public static enum enVars_TYPE {
        EQA_DBG_SYSADATA,
        EQA_DBG_V4LIST,
        EQA_DBG_SYSDEBUG,
        EQA_DBG_SRCE,
        EQA_SRC_PATH;

    }
}

