/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.debug.ui.tabs;

import com.ibm.ftt.common.logging.LogUtil;
import com.ibm.ftt.debug.launcher.ApplicationLaunchConstants;
import com.ibm.ftt.debug.ui.Activator;
import com.ibm.ftt.debug.ui.Messages;
import com.ibm.ftt.debug.ui.composites.ConnectionSettingsComposite;
import com.ibm.ftt.debug.ui.composites.DebugOptionsComposite;
import com.ibm.ftt.debug.ui.composites.IDebugOptionsCompositeListener;
import com.ibm.ftt.debug.ui.tabs.IPropertyGroupProvider;
import com.ibm.ftt.resources.zos.zosphysical.IZOSSystemImage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class DebugOptionsTab
extends AbstractLaunchConfigurationTab
implements ApplicationLaunchConstants,
IDebugOptionsCompositeListener {
    public static final String COPY_RIGHT = "  Licensed Materials - Property of IBM, 5724-T07, Copyright IBM Corp. 2011 All rights reserved.  US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected DebugOptionsComposite fOptionsComposite;
    protected ConnectionSettingsComposite fConnectionsComposite;
    private static final String EMPTY = "";
    private String fDefaultErrorLevel;

    public DebugOptionsTab() {
        this("ALL");
    }

    public DebugOptionsTab(String defaultErrorLevel) {
        this(defaultErrorLevel, null);
    }

    public DebugOptionsTab(String defaultErrorLevel, IPropertyGroupProvider provider) {
        this.fDefaultErrorLevel = defaultErrorLevel == null || defaultErrorLevel.isEmpty() ? "ALL" : defaultErrorLevel;
    }

    public void createControl(Composite parent) {
        parent = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        GridLayoutFactory.swtDefaults().applyTo(parent);
        this.setControl((Control)parent);
        Composite composite = parent;
        this.fOptionsComposite = new DebugOptionsComposite(composite, this);
        this.fConnectionsComposite = this.fOptionsComposite.getConnectionsComposite();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "com.ibm.ftt.debug.ui.debug_options_tab");
        this.doValidation();
    }

    public String getName() {
        return Messages.DebugOptionsTab_7;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String test = configuration.getAttribute("com.ibm.ftt.debug.testoption", "TEST");
            String error = configuration.getAttribute("com.ibm.ftt.debug.testlevel", "ALL");
            String prompt = configuration.getAttribute("com.ibm.ftt.debug.promptlevel", "NOPROMPT");
            String langenv = configuration.getAttribute("com.ibm.ftt.debug.langenvoptions", EMPTY);
            String commands = configuration.getAttribute("com.ibm.ftt.debug.commandsfile", EMPTY);
            String preferences = configuration.getAttribute("com.ibm.ftt.debug.preferencefile", EMPTY);
            String eqaopts = configuration.getAttribute("com.ibm.ftt.debug.eqaoptsfile", EMPTY);
            String trace = null;
            if (configuration.getAttribute("com.ibm.ftt.debug.trace", false)) {
                trace = configuration.getAttribute("com.ibm.ftt.debug.tracedsn", EMPTY);
            }
            boolean isIntegratedDebugger = configuration.getAttribute("com.ibm.ftt.debug.debuggerchoice.integrateddebugger", false);
            String systemName = configuration.getAttribute("com.ibm.ftt.debug.remotemvsconnectionname", EMPTY);
            String connectionString = configuration.getAttribute("com.ibm.ftt.debug.connection", EMPTY);
            if (configuration.hasAttribute("com.ibm.ftt.debug.dtCompatibility") || !configuration.hasAttribute("com.ibm.ftt.debug.debuggerchoice.integrateddebugger")) {
                boolean bl = isIntegratedDebugger = !configuration.getAttribute("com.ibm.ftt.debug.dtCompatibility", true);
            }
            if (connectionString != null && connectionString.length() > 0 && !connectionString.equalsIgnoreCase("TCPIP")) {
                this.fConnectionsComposite.setInitialValues(isIntegratedDebugger, systemName, connectionString);
            } else {
                if (systemName == null) {
                    systemName = EMPTY;
                }
                if (isIntegratedDebugger) {
                    this.fConnectionsComposite.setInitialValuesForIntegratedDebugger(systemName);
                } else {
                    String ip = configuration.getAttribute("com.ibm.ftt.debug.workstationip", EMPTY);
                    String port = configuration.getAttribute("com.ibm.ftt.debug.port", EMPTY);
                    this.fConnectionsComposite.setInitialValuesForDebugTool(systemName, ip, port);
                }
            }
            this.fOptionsComposite.setInitialValues(false, test, error, prompt, langenv, trace, commands, preferences, eqaopts);
        }
        catch (CoreException e) {
            LogUtil.log((int)4, (String)e.getMessage(), (String)"com.ibm.debug.pdt.idz.launches.common", (Throwable)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fConnectionsComposite != null) {
            configuration.setAttribute("com.ibm.ftt.debug.connection", this.fConnectionsComposite.getConnectionString());
            configuration.setAttribute("com.ibm.ftt.debug.port", this.fConnectionsComposite.getPort());
            configuration.setAttribute("com.ibm.ftt.debug.advanceduserid", this.fConnectionsComposite.getUserID());
            configuration.setAttribute("com.ibm.ftt.debug.workstationip", this.fConnectionsComposite.getIP());
            configuration.setAttribute("com.ibm.ftt.debug.dtCompatibility", true);
            if (this.fConnectionsComposite.getConnection() != null) {
                configuration.setAttribute("com.ibm.ftt.debug.remotemvsconnectionname", this.fConnectionsComposite.getConnection().getName());
                configuration.setAttribute("com.ibm.ftt.debug.userid", this.fConnectionsComposite.getConnection().getUserId());
            }
        }
        if (this.fOptionsComposite != null) {
            configuration.setAttribute("com.ibm.ftt.debug.testoption", this.fOptionsComposite.getTestOption());
            configuration.setAttribute("com.ibm.ftt.debug.testlevel", this.fOptionsComposite.getTestLevel());
            configuration.setAttribute("com.ibm.ftt.debug.promptlevel", this.fOptionsComposite.getPrompt());
            configuration.setAttribute("com.ibm.ftt.debug.commandsfile", this.fOptionsComposite.getCommandsDatasetString());
            configuration.setAttribute("com.ibm.ftt.debug.preferencefile", this.fOptionsComposite.getPreferenceDatasetString());
            configuration.setAttribute("com.ibm.ftt.debug.langenvoptions", this.fOptionsComposite.getLanguageEnvironmentString());
            configuration.setAttribute("com.ibm.ftt.debug.eqaoptsfile", this.fOptionsComposite.getEqaoptsDatasetString());
            configuration.setAttribute("com.ibm.ftt.debug.trace", false);
        }
        this.doValidation();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("com.ibm.ftt.debug.testoption", "TEST");
        configuration.setAttribute("com.ibm.ftt.debug.testlevel", this.fDefaultErrorLevel);
        configuration.setAttribute("com.ibm.ftt.debug.promptlevel", "PROMPT");
        configuration.setAttribute("com.ibm.ftt.debug.codecoverage", false);
    }

    public void modifyText(ModifyEvent e) {
        this.doValidation();
        this.updateLaunchConfigurationDialog();
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent event) {
        this.updateLaunchConfigurationDialog();
    }

    protected boolean doValidation() {
        String error = null;
        if (this.fConnectionsComposite != null && !this.fConnectionsComposite.validateControls(null)) {
            error = this.fConnectionsComposite.getErrorText();
        }
        if (error == null && this.fOptionsComposite != null && !this.fOptionsComposite.validateControls(null)) {
            error = this.fOptionsComposite.getErrorText();
        }
        this.setErrorMessage(error);
        return error == null;
    }

    public boolean canSave() {
        return this.doValidation();
    }

    public void setSystemFilter(IZOSSystemImage system) {
        this.fOptionsComposite.setSystemFilter(system != null ? system.getName() : null);
    }

    public Image getImage() {
        return Activator.getDefault().getImageRegistry().get("icons/debug_obj.png");
    }

    public boolean isDTCompatMode() {
        return true;
    }
}

